/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSDictionaryMap;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.pdmodel.graphics.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDPatternResources;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingResources;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.pdmodel.markedcontent.PDPropertyList;
import org.apache.pdfbox.util.MapUtil;

public class PDResources
implements COSObjectable {
    private COSDictionary resources;
    private Map<String, PDFont> fonts = null;
    private Map<PDFont, String> fontMappings = new HashMap<PDFont, String>();
    private Map<String, PDColorSpace> colorspaces = null;
    private Map<String, PDXObject> xobjects = null;
    private Map<PDXObject, String> xobjectMappings = null;
    private HashMap<String, PDXObjectImage> images = null;
    private Map<String, PDExtendedGraphicsState> graphicsStates = null;
    private Map<String, PDPatternResources> patterns = null;
    private Map<String, PDShadingResources> shadings = null;
    private static final Log LOG = LogFactory.getLog(PDResources.class);

    public PDResources() {
        this.resources = new COSDictionary();
    }

    public PDResources(COSDictionary resourceDictionary) {
        this.resources = resourceDictionary;
    }

    public COSDictionary getCOSDictionary() {
        return this.resources;
    }

    @Override
    public COSBase getCOSObject() {
        return this.resources;
    }

    public void clear() {
        if (this.fonts != null) {
            for (PDFont font : this.fonts.values()) {
                font.clear();
            }
            this.fonts.clear();
            this.fonts = null;
        }
        if (this.fontMappings != null) {
            this.fontMappings.clear();
            this.fontMappings = null;
        }
        if (this.colorspaces != null) {
            this.colorspaces.clear();
            this.colorspaces = null;
        }
        if (this.xobjects != null) {
            for (PDXObject xobject : this.xobjects.values()) {
                xobject.clear();
            }
            this.xobjects.clear();
            this.xobjects = null;
        }
        if (this.xobjectMappings != null) {
            this.xobjectMappings.clear();
            this.xobjectMappings = null;
        }
        if (this.images != null) {
            this.images.clear();
            this.images = null;
        }
        if (this.graphicsStates != null) {
            this.graphicsStates.clear();
            this.graphicsStates = null;
        }
        if (this.patterns != null) {
            this.patterns.clear();
            this.patterns = null;
        }
        if (this.shadings != null) {
            this.shadings.clear();
            this.shadings = null;
        }
    }

    public Map<String, PDFont> getFonts(Map<String, PDFont> fontCache) throws IOException {
        return this.getFonts();
    }

    public Map<String, PDFont> getFonts() {
        if (this.fonts == null) {
            this.fonts = new HashMap<String, PDFont>();
            COSDictionary fontsDictionary = (COSDictionary)this.resources.getDictionaryObject(COSName.FONT);
            if (fontsDictionary == null) {
                fontsDictionary = new COSDictionary();
                this.resources.setItem(COSName.FONT, (COSBase)fontsDictionary);
            } else {
                for (COSName fontName : fontsDictionary.keySet()) {
                    COSBase font = fontsDictionary.getDictionaryObject(fontName);
                    if (!(font instanceof COSDictionary)) continue;
                    PDFont newFont = null;
                    try {
                        newFont = PDFontFactory.createFont((COSDictionary)font);
                    }
                    catch (IOException exception) {
                        LOG.error("error while creating a font", exception);
                    }
                    if (newFont == null) continue;
                    this.fonts.put(fontName.getName(), newFont);
                }
            }
            this.setFonts(this.fonts);
        }
        return this.fonts;
    }

    public Map<String, PDXObject> getXObjects() {
        if (this.xobjects == null) {
            this.xobjects = new HashMap<String, PDXObject>();
            COSDictionary xobjectsDictionary = (COSDictionary)this.resources.getDictionaryObject(COSName.XOBJECT);
            if (xobjectsDictionary == null) {
                xobjectsDictionary = new COSDictionary();
                this.resources.setItem(COSName.XOBJECT, (COSBase)xobjectsDictionary);
            } else {
                this.xobjects = new HashMap<String, PDXObject>();
                for (COSName objName : xobjectsDictionary.keySet()) {
                    PDXObject xobject = null;
                    try {
                        xobject = PDXObject.createXObject(xobjectsDictionary.getDictionaryObject(objName));
                    }
                    catch (IOException exception) {
                        LOG.error("error while creating a xobject", exception);
                    }
                    if (xobject == null) continue;
                    this.xobjects.put(objName.getName(), xobject);
                }
            }
            this.setXObjects(this.xobjects);
        }
        return this.xobjects;
    }

    public Map<String, PDXObjectImage> getImages() throws IOException {
        if (this.images == null) {
            Map<String, PDXObject> allXObjects = this.getXObjects();
            this.images = new HashMap();
            for (Map.Entry<String, PDXObject> entry : allXObjects.entrySet()) {
                PDXObject xobject = entry.getValue();
                if (!(xobject instanceof PDXObjectImage)) continue;
                this.images.put(entry.getKey(), (PDXObjectImage)xobject);
            }
        }
        return this.images;
    }

    public void setFonts(Map<String, PDFont> fontsValue) {
        this.fonts = fontsValue;
        if (fontsValue != null) {
            this.resources.setItem(COSName.FONT, (COSBase)COSDictionaryMap.convert(fontsValue));
            this.fontMappings = this.reverseMap(fontsValue, PDFont.class);
        } else {
            this.resources.removeItem(COSName.FONT);
            this.fontMappings = null;
        }
    }

    public void setXObjects(Map<String, PDXObject> xobjectsValue) {
        this.xobjects = xobjectsValue;
        if (xobjectsValue != null) {
            this.resources.setItem(COSName.XOBJECT, (COSBase)COSDictionaryMap.convert(xobjectsValue));
            this.xobjectMappings = this.reverseMap(this.xobjects, PDXObject.class);
        } else {
            this.resources.removeItem(COSName.XOBJECT);
            this.xobjectMappings = null;
        }
    }

    public Map<String, PDColorSpace> getColorSpaces() {
        COSDictionary csDictionary;
        if (this.colorspaces == null && (csDictionary = (COSDictionary)this.resources.getDictionaryObject(COSName.COLORSPACE)) != null) {
            this.colorspaces = new HashMap<String, PDColorSpace>();
            for (COSName csName : csDictionary.keySet()) {
                COSBase cs = csDictionary.getDictionaryObject(csName);
                PDColorSpace colorspace = null;
                try {
                    colorspace = PDColorSpaceFactory.createColorSpace(cs);
                }
                catch (IOException exception) {
                    LOG.error("error while creating a colorspace", exception);
                }
                if (colorspace == null) continue;
                this.colorspaces.put(csName.getName(), colorspace);
            }
        }
        return this.colorspaces;
    }

    public void setColorSpaces(Map<String, PDColorSpace> csValue) {
        this.colorspaces = csValue;
        if (csValue != null) {
            this.resources.setItem(COSName.COLORSPACE, (COSBase)COSDictionaryMap.convert(csValue));
        } else {
            this.resources.removeItem(COSName.COLORSPACE);
        }
    }

    public Map<String, PDExtendedGraphicsState> getGraphicsStates() {
        COSDictionary states;
        if (this.graphicsStates == null && (states = (COSDictionary)this.resources.getDictionaryObject(COSName.EXT_G_STATE)) != null) {
            this.graphicsStates = new HashMap<String, PDExtendedGraphicsState>();
            for (COSName name : states.keySet()) {
                COSDictionary dictionary = (COSDictionary)states.getDictionaryObject(name);
                this.graphicsStates.put(name.getName(), new PDExtendedGraphicsState(dictionary));
            }
        }
        return this.graphicsStates;
    }

    public void setGraphicsStates(Map<String, PDExtendedGraphicsState> states) {
        this.graphicsStates = states;
        if (states != null) {
            Iterator<String> iter = states.keySet().iterator();
            COSDictionary dic = new COSDictionary();
            while (iter.hasNext()) {
                String name = iter.next();
                PDExtendedGraphicsState state = states.get(name);
                dic.setItem(COSName.getPDFName(name), state.getCOSObject());
            }
            this.resources.setItem(COSName.EXT_G_STATE, (COSBase)dic);
        } else {
            this.resources.removeItem(COSName.EXT_G_STATE);
        }
    }

    public PDPropertyList getProperties() {
        PDPropertyList retval = null;
        COSDictionary props = (COSDictionary)this.resources.getDictionaryObject(COSName.PROPERTIES);
        if (props != null) {
            retval = new PDPropertyList(props);
        }
        return retval;
    }

    public void setProperties(PDPropertyList props) {
        this.resources.setItem(COSName.PROPERTIES, props.getCOSObject());
    }

    public Map<String, PDPatternResources> getPatterns() throws IOException {
        COSDictionary patternsDictionary;
        if (this.patterns == null && (patternsDictionary = (COSDictionary)this.resources.getDictionaryObject(COSName.PATTERN)) != null) {
            this.patterns = new HashMap<String, PDPatternResources>();
            for (COSName name : patternsDictionary.keySet()) {
                COSDictionary dictionary = (COSDictionary)patternsDictionary.getDictionaryObject(name);
                this.patterns.put(name.getName(), PDPatternResources.create(dictionary));
            }
        }
        return this.patterns;
    }

    public void setPatterns(Map<String, PDPatternResources> patternsValue) {
        this.patterns = patternsValue;
        if (patternsValue != null) {
            Iterator<String> iter = patternsValue.keySet().iterator();
            COSDictionary dic = new COSDictionary();
            while (iter.hasNext()) {
                String name = iter.next();
                PDPatternResources pattern = patternsValue.get(name);
                dic.setItem(COSName.getPDFName(name), pattern.getCOSObject());
            }
            this.resources.setItem(COSName.PATTERN, (COSBase)dic);
        } else {
            this.resources.removeItem(COSName.PATTERN);
        }
    }

    public Map<String, PDShadingResources> getShadings() throws IOException {
        COSDictionary shadingsDictionary;
        if (this.shadings == null && (shadingsDictionary = (COSDictionary)this.resources.getDictionaryObject(COSName.SHADING)) != null) {
            this.shadings = new HashMap<String, PDShadingResources>();
            for (COSName name : shadingsDictionary.keySet()) {
                COSDictionary dictionary = (COSDictionary)shadingsDictionary.getDictionaryObject(name);
                this.shadings.put(name.getName(), PDShadingResources.create(dictionary));
            }
        }
        return this.shadings;
    }

    public void setShadings(Map<String, PDShadingResources> shadingsValue) {
        this.shadings = shadingsValue;
        if (shadingsValue != null) {
            Iterator<String> iter = shadingsValue.keySet().iterator();
            COSDictionary dic = new COSDictionary();
            while (iter.hasNext()) {
                String name = iter.next();
                PDShadingResources shading = shadingsValue.get(name);
                dic.setItem(COSName.getPDFName(name), shading.getCOSObject());
            }
            this.resources.setItem(COSName.SHADING, (COSBase)dic);
        } else {
            this.resources.removeItem(COSName.SHADING);
        }
    }

    public String addFont(PDFont font) {
        return this.addFont(font, MapUtil.getNextUniqueKey(this.getFonts(), "F"));
    }

    public String addFont(PDFont font, String fontKey) {
        String fontMapping;
        if (this.fonts == null) {
            this.getFonts();
        }
        if ((fontMapping = this.fontMappings.get(font)) == null) {
            fontMapping = fontKey;
            this.fontMappings.put(font, fontMapping);
            this.fonts.put(fontMapping, font);
            this.addFontToDictionary(font, fontMapping);
        }
        return fontMapping;
    }

    private void addFontToDictionary(PDFont font, String fontName) {
        COSDictionary fontsDictionary = (COSDictionary)this.resources.getDictionaryObject(COSName.FONT);
        fontsDictionary.setItem(fontName, (COSObjectable)font);
    }

    public String addXObject(PDXObject xobject, String prefix) {
        String objMapping;
        if (this.xobjects == null) {
            this.getXObjects();
        }
        if ((objMapping = this.xobjectMappings.get(xobject)) == null) {
            objMapping = MapUtil.getNextUniqueKey(this.xobjects, prefix);
            this.xobjectMappings.put(xobject, objMapping);
            this.xobjects.put(objMapping, xobject);
            this.addXObjectToDictionary(xobject, objMapping);
        }
        return objMapping;
    }

    private void addXObjectToDictionary(PDXObject xobject, String xobjectName) {
        COSDictionary xobjectsDictionary = (COSDictionary)this.resources.getDictionaryObject(COSName.XOBJECT);
        xobjectsDictionary.setItem(xobjectName, (COSObjectable)xobject);
    }

    private <T> Map<T, String> reverseMap(Map<String, T> map, Class<T> keyClass) {
        HashMap<T, String> reversed = new HashMap<T, String>();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            reversed.put(keyClass.cast(entry.getValue()), entry.getKey());
        }
        return reversed;
    }
}

