/*
 * Decompiled with CFR 0.152.
 */
package hughai.mapping;

import com.springrts.ai.oo.clb.Map;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import com.springrts.ai.oo.clb.WeaponMount;
import hughai.EnemyTracker;
import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.basictypes.Int2;
import hughai.basictypes.TerrainPos;
import hughai.ui.MainUI;
import hughai.utils.Config;

public class ThreatMap {
    PlayerObjects playerObjects;
    EnemyTracker enemyTracker;
    Config config;
    public static final int granularity = 2;
    int threatmapwidth;
    int threatmapheight;
    private float[][] damagePerSecond;

    public ThreatMap(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.enemyTracker = playerObjects.getEnemyTracker();
        this.config = playerObjects.getConfig();
        this.init();
    }

    public float getThreatAt(ThreatMapPos threatMapPos) {
        return this.damagePerSecond[threatMapPos.x][threatMapPos.y];
    }

    public float getThreatAt(TerrainPos terrainPos) {
        ThreatMapPos threatMapPos = ThreatMapPos.fromTerrainPos(terrainPos);
        return this.getThreatAt(threatMapPos);
    }

    void init() {
        Map map = this.playerObjects.getAicallback().getMap();
        int n = map.getWidth();
        int n2 = map.getHeight();
        this.threatmapwidth = n / 2;
        this.threatmapheight = n2 / 2;
        this.damagePerSecond = new float[this.threatmapwidth][this.threatmapheight];
        this.buildThreatMap();
        this.playerObjects.getCSAI().registerGameListener(new GameListener());
        this.playerObjects.getMainUI().registerButton("Show threat map", new ButtonDrawThreatMap());
    }

    void debug(Object object) {
        this.playerObjects.getLogFile().WriteLine("" + object);
    }

    void buildThreatMap() {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        this.debug("Building threat map ...");
        for (n2 = 0; n2 < this.threatmapheight; ++n2) {
            for (n = 0; n < this.threatmapwidth; ++n) {
                this.damagePerSecond[n][n2] = 0.0f;
            }
        }
        n2 = this.playerObjects.getFrameController().getFrame();
        n = this.config.getMaxTimeToConserveMobileEnemyOnThreatMapGameSeconds();
        int n3 = 30 * n;
        for (Unit unit : this.enemyTracker.getEnemyUnits()) {
            int n4;
            TerrainPos terrainPos = this.enemyTracker.getPos(unit);
            int n5 = this.enemyTracker.getLastLocatedFrame(unit);
            if (terrainPos == null || (n4 = n2 - n5) > n3 && this.enemyTracker.getEnemyPosByStaticUnit().get(unit) == null) continue;
            this.mapEnemy(unit, terrainPos);
        }
        this.debug(" ... threat map done. milliseconds taken: " + (System.currentTimeMillis() - l));
    }

    void mapEnemy(Unit unit, TerrainPos terrainPos) {
        UnitDef unitDef = this.enemyTracker.getEnemyUnitDefByUnit().get(unit);
        this.debug("... unitdef: " + unitDef.getHumanName() + " " + terrainPos);
        if (!unitDef.isAbleToAttack()) {
            return;
        }
        int n = 0;
        try {
            n = (int)((WeaponMount)unitDef.getWeaponMounts().get(0)).getWeaponDef().getRange();
            this.debug("mapping enemy unit " + unitDef.getHumanName() + " " + unit.getUnitId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = (int)terrainPos.x / 8 / 2;
        int n3 = (int)terrainPos.z / 8 / 2;
        this.debug(" ... threatmappos: " + n2 + " " + n3);
        float f = unitDef.getPower();
        int n4 = n / 8 / 2;
        this.debug(" ... power: " + f + " range: " + n4);
        for (int i = -n4; i <= n4; ++i) {
            for (int j = -n4; j <= n4; ++j) {
                if (j * j + i * i >= n4 * n4) continue;
                int n5 = n2 + j;
                int n6 = n3 + i;
                if (n5 < 0 || n5 >= this.threatmapwidth || n6 < 0 || n6 >= this.threatmapheight) continue;
                float[] fArray = this.damagePerSecond[n5];
                int n7 = n6;
                fArray[n7] = fArray[n7] + f;
            }
        }
    }

    public float[][] getDamagePerSecond() {
        return this.damagePerSecond;
    }

    class GameListener
    extends GameAdapter {
        GameListener() {
        }

        @Override
        public void Tick(int n) {
            ThreatMap.this.buildThreatMap();
        }
    }

    class ButtonDrawThreatMap
    implements MainUI.ButtonHandler {
        ButtonDrawThreatMap() {
        }

        @Override
        public void go() {
            boolean[][] blArray = new boolean[ThreatMap.this.threatmapwidth][ThreatMap.this.threatmapheight];
            for (int i = 0; i < ThreatMap.this.threatmapheight; ++i) {
                for (int j = 0; j < ThreatMap.this.threatmapwidth; ++j) {
                    blArray[j][i] = false;
                    if (!(ThreatMap.this.damagePerSecond[j][i] > 1.0f)) continue;
                    blArray[j][i] = true;
                }
            }
            ThreatMap.this.playerObjects.getDrawingUtils().DrawMap(blArray);
        }
    }

    public static class ThreatMapPos
    extends Int2 {
        public ThreatMapPos() {
        }

        public ThreatMapPos(int n, int n2) {
            super(n, n2);
        }

        public static ThreatMapPos fromTerrainPos(TerrainPos terrainPos) {
            return new ThreatMapPos((int)terrainPos.x / 8 / 2, (int)terrainPos.z / 8 / 2);
        }

        public TerrainPos toTerrainPos() {
            return new TerrainPos(this.x * 8 * 2, 0.0f, this.y * 8 * 2);
        }
    }
}

