/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.internal.storage.DocumentedStoreProvider;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.storage.xml.MimeTypeDetector;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;

public abstract class AbstractProvider
extends DocumentedStoreProvider {
    public static final String MIME_TYPE = "application/xml";
    private static final int READ_AHEAD_LIMIT = 2048;
    private static final byte[] HEADER = new byte[]{60, 63, 120, 109, 108, 32};
    protected final Map<String, String> mimeForNameSpaces = new HashMap<String, String>();
    protected final Map<String, String> mimeForRootElements = new HashMap<String, String>();

    protected AbstractProvider(String string) {
        super(string);
    }

    @Override
    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        DataStoreProvider.Prober<ByteBuffer> prober = byteBuffer -> {
            if (byteBuffer.remaining() < HEADER.length) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
            for (int i = 0; i < HEADER.length; ++i) {
                if (byteBuffer.get() == HEADER[i]) continue;
                return ProbeResult.UNSUPPORTED_STORAGE;
            }
            return new MimeTypeDetector(this.mimeForNameSpaces, this.mimeForRootElements, (ByteBuffer)byteBuffer){
                final /* synthetic */ ByteBuffer val$buffer;
                {
                    this.val$buffer = byteBuffer;
                    super(map, map2);
                }

                @Override
                int read() {
                    if (this.val$buffer.hasRemaining()) {
                        return this.val$buffer.get();
                    }
                    this.insufficientBytes = this.val$buffer.limit() != this.val$buffer.capacity();
                    return -1;
                }
            }.probeContent();
        };
        return this.probeContent(storageConnector, ByteBuffer.class, prober.orElse(Reader.class, reader -> {
            for (int i = 0; i < HEADER.length; ++i) {
                if (reader.read() == HEADER[i]) continue;
                return ProbeResult.UNSUPPORTED_STORAGE;
            }
            return new MimeTypeDetector(this.mimeForNameSpaces, this.mimeForRootElements, (Reader)reader){
                private int remaining;
                final /* synthetic */ Reader val$reader;
                {
                    this.val$reader = reader;
                    super(map, map2);
                    this.remaining = 2048;
                }

                @Override
                int read() throws IOException {
                    return --this.remaining >= 0 ? IOUtilities.readCodePoint(this.val$reader) : -1;
                }
            }.probeContent();
        }));
    }
}

