/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.iterator;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.iterator.PSentinelIterator;
import com.oracle.graal.python.builtins.objects.iterator.SentinelIteratorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.iterator.SentinelIteratorBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PSentinelIterator})
public final class SentinelIteratorBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = SentinelIteratorBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SentinelIteratorBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        ReduceNode() {
        }

        @Specialization
        static Object reduce(VirtualFrame frame, PSentinelIterator self, @Bind Node inliningTarget, @Cached PyObjectGetAttr getAttr, @Bind PythonLanguage language) {
            PythonModule builtins = PythonContext.get(inliningTarget).getBuiltins();
            Object iter = getAttr.execute((Frame)frame, inliningTarget, builtins, BuiltinNames.T_ITER);
            Object[] args = self.sentinelReached() ? new Object[]{PFactory.createEmptyTuple(language)} : new Object[]{self.getCallable(), self.getSentinel()};
            return PFactory.createTuple(language, new Object[]{iter, PFactory.createTuple(language, args)});
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doPSentinelIterator(PSentinelIterator self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization
        static Object doIterator(VirtualFrame frame, PSentinelIterator iterator, @Bind Node inliningTarget, @Cached CallNode callNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached PyObjectRichCompareBool eqNode) {
            Object nextValue;
            if (iterator.sentinelReached()) {
                throw NextNode.iteratorExhausted();
            }
            try {
                nextValue = callNode.execute((Frame)frame, iterator.getCallable(), new Object[0]);
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                iterator.markSentinelReached();
                throw NextNode.iteratorExhausted();
            }
            boolean iteratorDone = eqNode.executeEq((Frame)frame, inliningTarget, nextValue, iterator.getSentinel());
            if (iteratorDone) {
                iterator.markSentinelReached();
                throw NextNode.iteratorExhausted();
            }
            return nextValue;
        }
    }
}

