/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractShowDiffAction;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContextUtil;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.util.Consumer;
import com.intellij.util.TreeItem;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.ListTableModel;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CompareWithSelectedRevisionAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        VirtualFile file;
        if (e == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(0);
        }
        if ((file = VcsContextUtil.selectedFile(e.getDataContext())) != null && file.isDirectory()) {
            Project project = e.getProject();
            e.getPresentation().setVisible(CompareWithSelectedRevisionAction.isVisibleForDirectory(project));
            e.getPresentation().setEnabled(CompareWithSelectedRevisionAction.isEnabledForDirectory(project, file));
        } else {
            AbstractShowDiffAction.updateDiffAction(e.getPresentation(), e.getDataContext());
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(2);
        }
        VirtualFile file = Objects.requireNonNull(VcsContextUtil.selectedFile(e.getDataContext()));
        Project project = Objects.requireNonNull(e.getProject());
        AbstractVcs vcs = Objects.requireNonNull(ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file));
        VcsCachingHistory.collectInBackground(vcs, VcsUtil.getFilePath((VirtualFile)file), VcsBackgroundableActions.COMPARE_WITH, (Consumer<? super VcsHistorySession>)((Consumer)session -> {
            if (session == null) {
                return;
            }
            List revisions = session.getRevisionList();
            HistoryAsTreeProvider treeHistoryProvider = session.getHistoryAsTreeProvider();
            if (treeHistoryProvider != null) {
                CompareWithSelectedRevisionAction.showTreePopup(treeHistoryProvider.createTreeOn(revisions), project, (Consumer<? super VcsFileRevision>)((Consumer)selected -> CompareWithSelectedRevisionAction.showSelectedRevision(selected.getRevisionNumber(), vcs, file, project)));
            } else {
                CompareWithSelectedRevisionAction.showListPopup(revisions, project, (Consumer<? super VcsFileRevision>)((Consumer)selected -> CompareWithSelectedRevisionAction.showSelectedRevision(selected.getRevisionNumber(), vcs, file, project)), true);
            }
        }));
    }

    private static void showSelectedRevision(@NotNull VcsRevisionNumber selected, @NotNull AbstractVcs vcs, @NotNull VirtualFile file, @NotNull Project project) {
        if (selected == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(3);
        }
        if (vcs == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(5);
        }
        if (project == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(6);
        }
        if (file.isDirectory()) {
            DiffProvider diffProvider = Objects.requireNonNull(vcs.getDiffProvider());
            VcsDiffUtil.showChangesWithWorkingDirLater(project, file, selected, diffProvider);
        } else {
            DiffActionExecutor.showDiff(vcs.getDiffProvider(), selected, file, project);
        }
    }

    private static void showTreePopup(List<TreeItem<VcsFileRevision>> roots2, Project project, Consumer<? super VcsFileRevision> selectedRevisionConsumer) {
        TreeTableView treeTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)new TreeNodeAdapter(null, null, roots2), new ColumnInfo[]{Holder.BRANCH_COLUMN, Holder.REVISION_COLUMN, Holder.DATE_COLUMN, Holder.AUTHOR_COLUMN}));
        Runnable runnable = () -> {
            int index = treeTable.getSelectionModel().getMinSelectionIndex();
            if (index == -1) {
                return;
            }
            VcsFileRevision revision = CompareWithSelectedRevisionAction.getRevisionAt(treeTable, index);
            if (revision != null) {
                selectedRevisionConsumer.consume((Object)revision);
            }
        };
        treeTable.setSelectionMode(0);
        new PopupChooserBuilder((JTable)treeTable).setTitle(VcsBundle.message((String)"lookup.title.vcs.file.revisions", (Object[])new Object[0])).setItemChosenCallback(runnable).setSouthComponent((JComponent)CompareWithSelectedRevisionAction.createCommentsPanel(treeTable)).setResizable(true).setDimensionServiceKey("Vcs.CompareWithSelectedRevision.Popup").createPopup().showCenteredInCurrentWindow(project);
        int lastRow = treeTable.getRowCount() - 1;
        if (lastRow < 0) {
            return;
        }
        treeTable.getSelectionModel().addSelectionInterval(lastRow, lastRow);
        treeTable.scrollRectToVisible(treeTable.getCellRect(lastRow, 0, true));
    }

    @Nullable
    private static VcsFileRevision getRevisionAt(TreeTableView treeTable, int index) {
        List items = treeTable.getItems();
        if (items.size() <= index) {
            return null;
        }
        return ((TreeNodeAdapter)items.get(index)).getRevision();
    }

    private static JPanel createCommentsPanel(final TreeTableView treeTable) {
        JPanel panel = new JPanel(new BorderLayout());
        final JTextArea textArea = CompareWithSelectedRevisionAction.createTextArea();
        treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                int index;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((index = treeTable.getSelectionModel().getMinSelectionIndex()) == -1) {
                    textArea.setText("");
                } else {
                    VcsFileRevision revision = CompareWithSelectedRevisionAction.getRevisionAt(treeTable, index);
                    if (revision != null) {
                        textArea.setText(revision.getCommitMessage());
                    } else {
                        textArea.setText("");
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/CompareWithSelectedRevisionAction$1", "valueChanged"));
            }
        });
        JScrollPane textScrollPane = ScrollPaneFactory.createScrollPane((Component)textArea);
        panel.add((Component)textScrollPane, "Center");
        textScrollPane.setBorder((Border)IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"border.selected.revision.commit.message", (Object[])new Object[0]), (boolean)false));
        return panel;
    }

    private static JTextArea createTextArea() {
        JTextArea textArea = new JTextArea();
        textArea.setRows(5);
        textArea.setEditable(false);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        return textArea;
    }

    public static void showListPopup(final List<VcsFileRevision> revisions, Project project, Consumer<? super VcsFileRevision> selectedRevisionConsumer, boolean showComments) {
        ColumnInfo[] columns = new ColumnInfo[]{Holder.REVISION_TABLE_COLUMN, Holder.DATE_TABLE_COLUMN, Holder.AUTHOR_TABLE_COLUMN};
        for (VcsFileRevision revision : revisions) {
            if (revision.getBranchName() == null) continue;
            columns = new ColumnInfo[]{Holder.REVISION_TABLE_COLUMN, Holder.BRANCH_TABLE_COLUMN, Holder.DATE_TABLE_COLUMN, Holder.AUTHOR_TABLE_COLUMN};
            break;
        }
        final TableView table = new TableView(new ListTableModel(columns, revisions, 0));
        table.setShowHorizontalLines(false);
        table.setTableHeader(null);
        Runnable runnable = () -> {
            VcsFileRevision revision = (VcsFileRevision)table.getSelectedObject();
            if (revision != null) {
                selectedRevisionConsumer.consume((Object)revision);
            }
        };
        if (table.getModel().getRowCount() == 0) {
            table.clearSelection();
        }
        SpeedSearchBase<TableView> search = new SpeedSearchBase<TableView>(table, null){

            protected int getSelectedIndex() {
                return table.getSelectedRow();
            }

            protected int getElementCount() {
                return revisions.size();
            }

            protected Object getElementAt(int viewIndex) {
                return revisions.get(table.convertRowIndexToModel(viewIndex));
            }

            protected String getElementText(Object element) {
                VcsFileRevision revision = (VcsFileRevision)element;
                return revision.getRevisionNumber().asString() + " " + revision.getBranchName() + " " + revision.getAuthor();
            }

            protected void selectElement(Object element, String selectedText) {
                VcsFileRevision revision = (VcsFileRevision)element;
                TableUtil.selectRows((JTable)((JTable)this.myComponent), (int[])new int[]{((TableView)this.myComponent).convertRowIndexToView(revisions.indexOf(revision))});
                TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
            }
        };
        search.setupListeners();
        table.setMinimumSize((Dimension)new JBDimension(300, 50));
        PopupChooserBuilder builder = new PopupChooserBuilder((JTable)table);
        if (showComments) {
            builder.setSouthComponent((JComponent)CompareWithSelectedRevisionAction.createCommentsPanel((TableView<VcsFileRevision>)table));
        }
        builder.setTitle(VcsBundle.message((String)"lookup.title.vcs.file.revisions", (Object[])new Object[0])).setItemChosenCallback(runnable).setResizable(true).setMovable(true).setDimensionServiceKey("Vcs.CompareWithSelectedRevision.Popup").setMinSize((Dimension)new JBDimension(300, 300));
        JBPopup popup = builder.createPopup();
        popup.showCenteredInCurrentWindow(project);
    }

    private static JPanel createCommentsPanel(final TableView<VcsFileRevision> table) {
        final JTextArea textArea = CompareWithSelectedRevisionAction.createTextArea();
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                VcsFileRevision revision;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((revision = (VcsFileRevision)table.getSelectedObject()) == null) {
                    textArea.setText("");
                } else {
                    textArea.setText(revision.getCommitMessage());
                    textArea.select(0, 0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/CompareWithSelectedRevisionAction$3", "valueChanged"));
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane textScrollPane = ScrollPaneFactory.createScrollPane((Component)textArea);
        JLabel commentLabel = new JLabel(VcsBundle.message((String)"border.selected.revision.commit.message", (Object[])new Object[0]));
        jPanel.add((Component)commentLabel, "North");
        commentLabel.setBorder(IdeBorderFactory.createBorder((int)11));
        textScrollPane.setBorder(null);
        jPanel.add((Component)textScrollPane, "Center");
        jPanel.setPreferredSize((Dimension)new JBDimension(300, 100));
        return jPanel;
    }

    private static boolean isVisibleForDirectory(@Nullable Project project) {
        return project != null;
    }

    private static boolean isEnabledForDirectory(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(7);
        }
        if (project == null) {
            return false;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        DiffProvider diffProvider = vcs != null ? vcs.getDiffProvider() : null;
        return diffProvider != null && diffProvider.canCompareWithWorkingDir();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/CompareWithSelectedRevisionAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/CompareWithSelectedRevisionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showSelectedRevision";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class TreeNodeAdapter
    extends DefaultMutableTreeNode {
        private final TreeItem<VcsFileRevision> myRevision;

        TreeNodeAdapter(TreeNodeAdapter parent, TreeItem<VcsFileRevision> revision, List<TreeItem<VcsFileRevision>> children) {
            if (parent != null) {
                parent.add(this);
            }
            this.myRevision = revision;
            for (TreeItem<VcsFileRevision> treeItem : children) {
                new TreeNodeAdapter(this, treeItem, treeItem.getChildren());
            }
        }

        public VcsFileRevision getRevision() {
            return (VcsFileRevision)this.myRevision.getData();
        }
    }

    private static class Holder {
        private static final ColumnInfo<TreeNodeAdapter, String> BRANCH_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revisions.list.branch", (Object[])new Object[0])){

            public String valueOf(TreeNodeAdapter object) {
                return object.getRevision().getBranchName();
            }
        };
        private static final ColumnInfo<TreeNodeAdapter, String> REVISION_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

            public String valueOf(TreeNodeAdapter object) {
                return object.getRevision().getRevisionNumber().asString();
            }
        };
        private static final ColumnInfo<TreeNodeAdapter, String> DATE_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revisions.list.filter", (Object[])new Object[0])){

            public String valueOf(TreeNodeAdapter object) {
                return DateFormatUtil.formatPrettyDateTime((Date)object.getRevision().getRevisionDate());
            }
        };
        private static final ColumnInfo<TreeNodeAdapter, String> AUTHOR_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0])){

            public String valueOf(TreeNodeAdapter object) {
                return object.getRevision().getAuthor();
            }
        };
        private static final ColumnInfo<VcsFileRevision, String> REVISION_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

            public String valueOf(VcsFileRevision vcsFileRevision) {
                return vcsFileRevision.getRevisionNumber().asString();
            }
        };
        private static final ColumnInfo<VcsFileRevision, String> DATE_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

            public String valueOf(VcsFileRevision vcsFileRevision) {
                Date date = vcsFileRevision.getRevisionDate();
                return date == null ? "" : DateFormatUtil.formatPrettyDateTime((Date)date);
            }
        };
        private static final ColumnInfo<VcsFileRevision, String> AUTHOR_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0])){

            public String valueOf(VcsFileRevision vcsFileRevision) {
                return vcsFileRevision.getAuthor();
            }
        };
        private static final ColumnInfo<VcsFileRevision, String> BRANCH_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revisions.list.branch", (Object[])new Object[0])){

            public String valueOf(VcsFileRevision vcsFileRevision) {
                return vcsFileRevision.getBranchName();
            }
        };

        private Holder() {
        }
    }
}

