/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.Commas;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.QuantifierNounCompatibility;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AgreementSet {
    private static final NodePattern useTo = NodePattern.N.inFormSequence(0, "use", "to");
    static final NodePattern noOne = NodePattern.N.form("one").and(CommonPatterns.afterSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.N.form("no")));
    private static final NodePattern plSgNominal = NodePattern.or(NodePattern.N.withDependent("conj").andOr(CommonPatterns.capitalized.pos("NN.*").label(".*"), NodePattern.N.withHeadRelation("nsubj.*").noDependents("cop").andNot(NodePattern.N.afterHead().withHead("nsubj", NodePattern.N.lemma("be").withDependent("expl"))).andNot(NodePattern.N.withHeadRelation("nsubj").withDependent("conj", NodePattern.N.withDependent("cc", SubjectVerbAgreement.orInCompoundSubject)))), NodePattern.N.form("you|all|no"), EnglishTreePatterns.anyPercent);
    private static final NodePattern lotsOf = NodePattern.N.inFormSequence(0, "lots", "of").noDependents("det");
    private static final NodePattern nonInflectableNominal = NodePattern.or(NodePattern.N.pos("NNP").andNot(NodePattern.N.pos("NNS?")), NodePattern.N.withDependent("appos"), NodePattern.N.form("(any|some|every|no)body|marketing|mother|father|algae|people|lot|peace|nature|.+fulness"), lotsOf);
    private static final NodePattern pluralRequiringDependent = NodePattern.or(NodePattern.N.withHeadRelation("nummod").andNot(Number.one1), NodePattern.N.form("multiple"), CommonPatterns.possiblySkipDown("det:predet", NodePattern.N.form("various|all|more|less|most")).withHead(NodePattern.or(EnglishTreePatterns.typeSynonyms, NodePattern.not(QuantifierNounCompatibility.possiblyUncountable))), Number.pluralDeterminers.noForm("these|those"));
    private static final NodePattern onlyPluralNominal = NodePattern.or(NodePattern.N.pos("NNS").noDependents(NodePattern.N.beforeHead()), NodePattern.N.pos("CD").andNot(noOne), NodePattern.N.withDependent("nummod|amod|det|nmod", pluralRequiringDependent), NodePattern.N.pos("NNS").withDependent("nmod", NodePattern.N.pos("NNP?").withDependent("case", NodePattern.N.inFormSequence(0, "such", "as"))), NodePattern.N.withHeadRelation("nmod").withDependent("case", NodePattern.N.form("of")).andOr(NodePattern.N.withHead(NodePattern.N.lemma("one|amount|number")), NodePattern.N.withHead(NodePattern.N.pos("CD")).andNot(NodePattern.N.inFormSequence(1, "a", "kinds?"))), NodePattern.N.form("these|those").withDependent("acl:relcl"), NodePattern.N.form("we|they|you"), Number.numberDelegatingHead.noForm("lots"));
    static final NodePattern onlySgPronoun = NodePattern.N.form("I|s?he|it");
    static final NodePattern sgRequiringDet = NodePattern.N.form("each|every|n?either|another").beforeHead().andNot(NodePattern.N.form("every|another").withNextSibling(NodePattern.or(NodePattern.N.withHeadRelation("nummod"), NodePattern.N.form("few")).beforeHead()));
    static final NodePattern onlySgNominal = NodePattern.or(Semantics.definitelyUncountableNoun.andNot(Semantics.uncountableOnlyWhenSingular), Semantics.possiblyUncountableForm.withDependent("amod", NodePattern.N.form("much")), onlySgPronoun, CommonPatterns.nerPerson, NodePattern.N.withDependent("det", sgRequiringDet), NodePattern.N.form("one").andOr(NodePattern.N.withDependent("nsubj", onlySgPronoun), NodePattern.N.withDependent("det", NodePattern.N.form("any"))), Articles.suggestOnlySingular);
    private static final NodePattern withAn = NodePattern.N.withDependent("det", NodePattern.N.form("an?"));
    private static final Pair<List<NodeCorrector>, List<Node>> NO_CHANGE = new ImmutablePair(List.of(), List.of());
    private static final NodePattern pastFiniteVerb = NodePattern.N.pos("VBD").and(CommonPatterns.skipUp("cop|aux|aux:pass", NodePattern.N.withDependent("nsubj.*", NodePattern.N.beforeHead())));
    private static final NodePattern caseApostropheS = EnglishTreePatterns.apostropheS.noSpaceBefore().noHeadRelation("cop|aux|aux:pass");
    private static final NodePattern whichToThat = NodePattern.N.form("which").directlyAfter(NodePattern.not(CommonPatterns.comma)).and(EnglishParameters.VARIANT.withValue("US"));
    private static final NodePattern inflectableOne = NodePattern.N.lemma("one").withDependent("amod").noDependents("nmod");
    private static final NodePattern sameSubjectConj = NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl").andOr(NodePattern.N.withDependent("cc.*"), Commas.commaStartingPhrase);
    private static final NodePattern sgNamed = CommonPatterns.capitalized.label("PRODUCT").onlyPos("NN");
    private final Node main;
    private final Number to;
    @Nullable
    private final Node predicate;
    private static final NodePattern isPluralAOk = NodePattern.or(NodePattern.N.withHead("det", Number.numberDelegatingHead), NodePattern.N.directlyBefore(EnglishTreePatterns.aFew));
    private static final NodePattern isSubClauseThat = NodePattern.N.form("that").markAs("That").and(CommonPatterns.skipUp("det", CommonPatterns.skipUp("nsubj.*", EnglishTreePatterns.clause.andNot(NodePattern.ROOT).withPhraseStart(CommonPatterns.skipForward(NodePattern.PUNCT, NodePattern.N.alreadyMarkedAs("That"))))));
    private static final NodePattern copulaSubjectWithFixedNumber = NodePattern.or(CommonPatterns.possiblySkipDown("det", NodePattern.N.form("this|that")), EnglishTreePatterns.capitalizedUnknown);

    AgreementSet(Node main, Number to) {
        this(main, to, AgreementSet.subjectHead(main));
    }

    AgreementSet(Node main, Number to, @Nullable Node predicate) {
        this.main = main;
        this.to = to;
        this.predicate = predicate;
    }

    @Nullable
    static Node subjectHead(Node main) {
        Node head = main.head();
        if (!main.hasHeadRelation("nsubj(:pass|:outer)?") || head == null) {
            return null;
        }
        if (head.findDependents("cop|aux|aux:pass").stream().anyMatch(n -> n.isBefore(main) && EnglishTreePatterns.clausalCopula.matches((Node)n))) {
            return null;
        }
        return head;
    }

    @NotNull
    NodeMatch changeNumber(NodeMatch match) {
        Pair<List<NodeCorrector>, List<Node>> pair = this.changeNumber();
        if (((List)pair.getLeft()).isEmpty()) {
            return match;
        }
        return match.withCorrectors((List)pair.getLeft()).withReportedNodes((Iterable)pair.getRight());
    }

    @NotNull
    Pair<List<NodeCorrector>, List<Node>> changeNumber() {
        return this.changeNumber(Set.of());
    }

    @NotNull
    Pair<List<NodeCorrector>, List<Node>> changeNumber(Set<Node> skip) {
        if (this.suppressCopulaChange(this.main)) {
            return NO_CHANGE;
        }
        List<NodeCorrector> result = null;
        ArrayList<Node> toHighlight = new ArrayList<Node>();
        LinkedHashMap<Node, List<String>> nominalSuggestions = new LinkedHashMap<Node, List<String>>();
        if (this.predicate != null) {
            if (this.suppressCopulaChange(this.predicate)) {
                return NO_CHANGE;
            }
            List allPredicates = ((StreamEx)StreamEx.of((Object)this.predicate).append(this.predicate.findDependents("conj").stream().takeWhile(c -> !this.suppressCopulaChange((Node)c) && sameSubjectConj.matches((Node)c)))).toList();
            List<Node> finiteVerbs = allPredicates.stream().map(p -> EnglishTreePatterns.findFiniteVerb(p)).toList();
            for (Node finite : finiteVerbs) {
                if (skip.contains(finite)) continue;
                List<NodeCorrector> correctors = this.changeVerbNumber(finite, true);
                result = NodeCorrector.joinCorrectors(result, correctors);
                if (correctors == null) continue;
                toHighlight.addAll(AgreementSet.reportVerb(finite));
            }
            for (Node each : allPredicates) {
                List<Node> dependents = each.findDependents("i?obj|obl.*");
                for (Node dependent : dependents) {
                    List<String> suggestions;
                    if (skip.contains(dependent) || !dependent.hasForm("itself|themselves") || (suggestions = AgreementSet.changeNominalNumber(dependent, this.to)) == null) continue;
                    if (suggestions.isEmpty()) {
                        return NO_CHANGE;
                    }
                    nominalSuggestions.put(dependent, suggestions);
                }
            }
        }
        if (!skip.contains(this.main)) {
            if (Number.npNumberGroupAware(this.main) != this.to) {
                List<String> suggestions = AgreementSet.changeNominalNumber(this.main, this.to);
                if (suggestions != null) {
                    if (suggestions.isEmpty()) {
                        return NO_CHANGE;
                    }
                    nominalSuggestions.put(this.main, suggestions);
                }
            } else if (this.isNominalWithIncompatibleDependent(skip)) {
                return NO_CHANGE;
            }
        }
        for (Node det : this.main.findDependents("det")) {
            List<String> suggestions;
            if (skip.contains(det) || (suggestions = AgreementSet.changeNominalNumber(det, this.to)) == null) continue;
            if (suggestions.isEmpty()) {
                return NO_CHANGE;
            }
            nominalSuggestions.put(det, suggestions);
        }
        toHighlight.addAll(nominalSuggestions.keySet().stream().filter(n -> !n.hasForm("an?")).toList());
        if (this.to == Number.plural) {
            result = NodeCorrector.joinCorrectors(result, AgreementSet.fixCaseOnDeterminerRemoval(this.main, nominalSuggestions));
        }
        for (Map.Entry entry : nominalSuggestions.entrySet()) {
            ArrayList<NodeCorrector> nominalCorrectors = new ArrayList<NodeCorrector>();
            for (String replacement : (List)entry.getValue()) {
                Node nominal = (Node)entry.getKey();
                Node next = nominal.nextNode();
                if (caseApostropheS.matches(next) && replacement.endsWith("s")) {
                    toHighlight.add(next);
                    nominalCorrectors.add(NodeCorrector.replaceNodes(nominal, next, replacement));
                    continue;
                }
                nominalCorrectors.add(NodeCorrector.replace(nominal, replacement));
            }
            result = NodeCorrector.joinCorrectors(result, nominalCorrectors);
        }
        for (Node relcl : this.main.findDependents("acl:relcl")) {
            result = NodeCorrector.joinCorrectors(result, this.inflectRelativeClause(skip, toHighlight, relcl));
        }
        Node nextSibling = this.main.nextSibling();
        if (nextSibling != null && nextSibling.hasHeadRelation("acl:relcl")) {
            result = NodeCorrector.joinCorrectors(result, this.inflectRelativeClause(skip, toHighlight, nextSibling));
        }
        return result != null ? new ImmutablePair(result, toHighlight) : NO_CHANGE;
    }

    private boolean isNominalWithIncompatibleDependent(Set<Node> skip) {
        return this.to == Number.singular && (lotsOf.matches(this.main) || this.main.allDependents().stream().anyMatch(n -> !skip.contains(n) && pluralRequiringDependent.matches((Node)n)));
    }

    static List<Node> reportVerb(Node finite) {
        if (EnglishTreePatterns.startsWithApostrophe.matches(finite) && finite.prevNode() != null) {
            return List.of(finite.prevNode(), finite);
        }
        return List.of(finite);
    }

    @Nullable
    private List<NodeCorrector> inflectRelativeClause(Set<Node> skip, List<Node> toHighlight, Node relcl) {
        Node relSubj = relcl.findSingleDependent("nsubj.*");
        Node relFinite = EnglishTreePatterns.findFiniteVerb(relcl);
        if (relSubj != null && relSubj.hasForm("who|which|that") && !skip.contains(relFinite)) {
            List<Node> candidates = EnglishTreePatterns.findRelativeClauseHostCandidates(relSubj, relcl);
            if (candidates.size() != 1 || candidates.get(0) != this.main) {
                return null;
            }
            NodeCorrector whChange = null;
            if (whichToThat.matches(relSubj)) {
                toHighlight.add(relSubj);
                whChange = NodeCorrector.replace(relSubj, "that");
            }
            List<NodeCorrector> numberChange = null;
            Number relclNumber = Number.verbNumber(relFinite);
            if (this.to != relclNumber && relclNumber != Number.ambiguous) {
                toHighlight.addAll(AgreementSet.reportVerb(relFinite));
                numberChange = this.changeVerbNumber(relFinite, false);
            }
            if (whChange != null && numberChange != null) {
                return NodeCorrector.joinCorrectors(List.of(whChange), numberChange);
            }
            return whChange != null ? List.of(whChange) : numberChange;
        }
        return null;
    }

    @Nullable
    private static List<String> changeNominalNumber(Node node, Number to) {
        boolean toPlural;
        if (plSgNominal.matches(node)) {
            return null;
        }
        if (nonInflectableNominal.matches(node)) {
            return List.of();
        }
        boolean bl = toPlural = to == Number.plural;
        if (!toPlural && onlyPluralNominal.matches(node)) {
            return List.of();
        }
        if (toPlural && onlySgNominal.matches(node)) {
            return List.of();
        }
        if (noOne.matches(node)) {
            return toPlural ? List.of() : null;
        }
        if (inflectableOne.matches(node)) {
            return toPlural ? List.of("ones") : List.of("one");
        }
        if (node.hasPos("CD")) {
            return toPlural ? null : List.of();
        }
        if (node.hasLemma("an?")) {
            return toPlural && !isPluralAOk.matches(node) ? List.of("") : null;
        }
        if (node.hasLemma("this")) {
            return toPlural ? List.of("these") : null;
        }
        if (node.hasLemma("that")) {
            return !toPlural || isSubClauseThat.matches(node) ? null : List.of("those");
        }
        if (node.hasLemma("these")) {
            return toPlural ? null : List.of("this");
        }
        if (node.hasLemma("those")) {
            return toPlural ? null : List.of("that");
        }
        if (node.hasForm("advice")) {
            return toPlural ? List.of("pieces of advice") : null;
        }
        if (node.hasForm("itself")) {
            return toPlural ? List.of("themselves") : null;
        }
        if (node.hasForm("themselves")) {
            return !toPlural ? List.of("itself") : null;
        }
        if (node.hasPos("NNP?S")) {
            return toPlural || node.hasPos("NNP?") ? null : node.tree().treeSupport().inflectNode(node, "NNP?S", node.hasPos("NNPS") ? "NNP" : "NN");
        }
        if (node.hasPos("NN")) {
            return toPlural ? node.tree().treeSupport().inflectNode(node, "NN", "NNS") : null;
        }
        return null;
    }

    private static List<NodeCorrector> fixCaseOnDeterminerRemoval(Node main, Map<Node, List<String>> nominalSuggestions) {
        Node next;
        Node an = StreamEx.of(main.findDependents("det")).findFirst(n -> n.hasForm("an?")).orElse(null);
        if (an != null && (next = an.nextNode()) != null && nominalSuggestions.containsKey(next)) {
            nominalSuggestions.remove(an);
            return StreamEx.of((Collection)nominalSuggestions.remove(next)).map(s -> NodeCorrector.replaceNodes(an, next, s)).toList();
        }
        return null;
    }

    private boolean suppressCopulaChange(Node predicate) {
        if (!predicate.hasDependent("cop") || predicate.hasDependent("case")) {
            return false;
        }
        if (this.to == Number.plural && sgNamed.matches(predicate)) {
            return true;
        }
        if (this.to == Number.singular && predicate.hasPos("NNS") && !withAn.matches(predicate) || this.to == Number.plural && predicate.hasPos("NN")) {
            Node subj = EnglishTreePatterns.findSubject(predicate);
            return copulaSubjectWithFixedNumber.matches(subj);
        }
        return predicate.hasPos(this.to == Number.singular ? "NNPS" : "NNP");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    List<NodeCorrector> changeVerbNumber(Node finite, boolean maySuggestPast) {
        result = new ArrayList<NodeCorrector>();
        if (!maySuggestPast) ** GOTO lbl-1000
        if (this.main.hasDependent("acl:relcl") && !this.main.hasDependent("nmod") && !finite.hasHeadRelation("cop") && finite.hasPos("VBP?") || AgreementSet.useTo.matches(finite)) ** GOTO lbl-1000
        if (finite.back().anyMatch((Predicate<Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, matches(ai.grazie.rules.tree.Node ), (Lai/grazie/rules/tree/Node;)Z)((NodePattern)AgreementSet.pastFiniteVerb))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = suggestPast = false;
        }
        if (this.to == Number.plural) {
            if (Number.verbNumber(finite) != Number.singular) {
                return null;
            }
            result.add(AgreementSet.decontract(finite, AgreementSet.verbToPlural(finite)));
            if (suggestPast) {
                result.add(AgreementSet.toPast(finite, "were"));
            }
            return result;
        }
        if (Number.verbNumber(finite) != Number.plural) {
            return null;
        }
        if (finite.hasForm("were")) {
            return List.of(AgreementSet.decontract(finite, NodeCorrector.replace(finite, new String[]{"was"})));
        }
        result.add(AgreementSet.decontract(finite, NodeCorrector.inflect(finite, "VB.*", "VBZ")));
        if (suggestPast) {
            result.add(AgreementSet.toPast(finite, "was"));
        }
        return result;
    }

    private static NodeCorrector toPast(Node verb, String beForm) {
        NodeCorrector past = verb.hasLemma("be") ? NodeCorrector.replace(verb, beForm) : NodeCorrector.inflect(verb, "VB.*", "VBD");
        return AgreementSet.decontract(verb, past);
    }

    private static NodeCorrector verbToPlural(Node verb) {
        return verb.hasForm("was") ? NodeCorrector.replace(verb, "were") : (verb.hasLemma("be") ? NodeCorrector.replace(verb, "are") : (verb.hasLemma("have") ? NodeCorrector.replace(verb, "have") : NodeCorrector.inflect(verb, "VB.*", "VBP")));
    }

    private static NodeCorrector decontract(Node verb, NodeCorrector corrector) {
        return EnglishTreePatterns.startsWithApostrophe.matches(verb) ? NodeCorrector.insertBefore(verb, " ").join(corrector) : corrector;
    }
}

