/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.injection.MarkdownCodeFenceErrorHighlightingIntention;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.intellij.plugins.markdown.util.MarkdownPluginScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J%\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\b\u0010\u0013\u001a\u00020\bH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/injection/MarkdownCodeFenceErrorHighlightingIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "getText", "", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "invoke", "", "setHideErrors", "hideErrors", "startInWriteAction", "CodeAnalyzerRestartListener", "intellij.markdown"})
public final class MarkdownCodeFenceErrorHighlightingIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = MarkdownBundle.message("markdown.hide.problems.intention.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile psiFile) {
        PsiFile psiFile2;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                PsiFile psiFile3 = psiFile;
                if (!Intrinsics.areEqual((Object)(psiFile3 != null ? psiFile3.getFileType() : null), (Object)((Object)MarkdownFileType.INSTANCE)) || !MarkdownSettings.Companion.getInstance(project).getShowProblemsInCodeBlocks()) {
                    return false;
                }
                psiFile2 = psiFile;
                if (psiFile2 == null) break block5;
                Editor editor3 = editor2;
                if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) {
                    return false;
                }
                if ((psiFile2 = psiFile2.findElementAt(editor3.getOffset())) != null) break block6;
            }
            return false;
        }
        PsiFile element2 = psiFile2;
        return PsiTreeUtil.getParentOfType((PsiElement)element2, MarkdownCodeFence.class) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.setHideErrors(project, true);
        NotificationGroup notificationGroup = MarkdownNotifications.INSTANCE.getGroup();
        String string = MarkdownBundle.message("markdown.hide.problems.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = MarkdownBundle.message("markdown.hide.problems.notification.content", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Notification notification = notificationGroup.createNotification(string, string2, NotificationType.INFORMATION);
        String string3 = MarkdownBundle.message("markdown.hide.problems.notification.rollback.action.text", new Object[0]);
        notification.addAction((AnAction)new NotificationAction(this, project, string3){
            final /* synthetic */ MarkdownCodeFenceErrorHighlightingIntention this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                MarkdownCodeFenceErrorHighlightingIntention.access$setHideErrors(this.this$0, this.$project, false);
                notification.expire();
            }
        });
        notification.notify(project);
    }

    private final void setHideErrors(Project project, boolean hideErrors) {
        MarkdownSettings.Companion.getInstance(project).update((Function1<? super MarkdownSettings, Unit>)((Function1)arg_0 -> MarkdownCodeFenceErrorHighlightingIntention.setHideErrors$lambda$0(hideErrors, arg_0)));
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static final Unit setHideErrors$lambda$0(boolean $hideErrors, MarkdownSettings it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        it.setShowProblemsInCodeBlocks(!$hideErrors);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setHideErrors(MarkdownCodeFenceErrorHighlightingIntention $this, Project project, boolean hideErrors) {
        $this.setHideErrors(project, hideErrors);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/injection/MarkdownCodeFenceErrorHighlightingIntention$CodeAnalyzerRestartListener;", "Lorg/intellij/plugins/markdown/settings/MarkdownSettings$ChangeListener;", "<init>", "()V", "settingsChanged", "", "settings", "Lorg/intellij/plugins/markdown/settings/MarkdownSettings;", "intellij.markdown"})
    public static final class CodeAnalyzerRestartListener
    implements MarkdownSettings.ChangeListener {
        @Override
        public void settingsChanged(@NotNull MarkdownSettings settings) {
            Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
            Project project = settings.getProject$intellij_markdown();
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            if (fileEditorManager == null) {
                return;
            }
            FileEditorManager editorManager = fileEditorManager;
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
            if (daemonCodeAnalyzer == null) {
                return;
            }
            DaemonCodeAnalyzer codeAnalyzer = daemonCodeAnalyzer;
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
            PsiManager psiManager2 = psiManager;
            CoroutineScope coroutineScope = MarkdownPluginScope.Companion.scope(project);
            BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(editorManager, psiManager2, codeAnalyzer, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ FileEditorManager $editorManager;
                final /* synthetic */ PsiManager $psiManager;
                final /* synthetic */ DaemonCodeAnalyzer $codeAnalyzer;
                {
                    this.$editorManager = $editorManager;
                    this.$psiManager = $psiManager;
                    this.$codeAnalyzer = $codeAnalyzer;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$launch;
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                            this.label = 1;
                            Object object2 = CoroutinesKt.readAction(() -> settingsChanged.1.invokeSuspend$lambda$0(this.$editorManager, (CoroutineScope)$this$launch, this.$psiManager, this.$codeAnalyzer), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                /*
                 * WARNING - void declaration
                 */
                private static final Unit invokeSuspend$lambda$0(FileEditorManager $editorManager, CoroutineScope $$this$launch, PsiManager $psiManager, DaemonCodeAnalyzer $codeAnalyzer) {
                    void $this$filterTo$iv$iv;
                    VirtualFile[] virtualFileArray = $editorManager.getOpenFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
                    Object[] $this$filter$iv = virtualFileArray;
                    boolean $i$f$filter = false;
                    Object[] objectArray = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (void element$iv$iv : $this$filterTo$iv$iv) {
                        VirtualFile it = (VirtualFile)element$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!MarkdownLanguageUtilsKt.hasMarkdownType(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List files = (List)destination$iv$iv;
                    for (VirtualFile file : files) {
                        PsiFile psi;
                        if (!file.isValid()) {
                            CoroutineScope $this$thisLogger$iv = $$this$launch;
                            boolean $i$f$thisLogger = false;
                            Logger logger = Logger.getInstance(CoroutineScope.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            logger.warn("Virtual file " + file + " is not valid");
                            continue;
                        }
                        if ($psiManager.findFile(file) == null) continue;
                        $codeAnalyzer.restart(psi, (Object)$$this$launch);
                    }
                    return Unit.INSTANCE;
                }
            }), (int)2, null);
        }
    }
}

