/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class AssertStatement
extends Statement {
    public static final TokenRole ASSERT_KEYWORD_ROLE = new TokenRole("assert", 1);

    public AssertStatement(int offset) {
        super(offset);
    }

    public final JavaTokenNode getColon() {
        return this.getChildByRole(Roles.COLON);
    }

    public final Expression getCondition() {
        return this.getChildByRole(Roles.CONDITION);
    }

    public final void setCondition(Expression value) {
        this.setChildByRole(Roles.CONDITION, value);
    }

    public final Expression getMessage() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setMessage(Expression message) {
        this.setChildByRole(Roles.EXPRESSION, message);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitAssertStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof AssertStatement) {
            AssertStatement otherAssert = (AssertStatement)other;
            return this.getCondition().matches(otherAssert.getCondition(), match) && this.getMessage().matches(otherAssert.getMessage());
        }
        return false;
    }
}

