/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.gcs;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.util.SecurityUtils;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.StorageRetryStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.settings.SecureString;
import org.opensearch.repositories.gcs.GoogleApplicationDefaultCredentials;
import org.opensearch.repositories.gcs.GoogleCloudStorageClientSettings;
import org.opensearch.repositories.gcs.GoogleCloudStorageHttpStatsCollector;
import org.opensearch.repositories.gcs.GoogleCloudStorageOperationsStats;
import org.opensearch.repositories.gcs.GoogleShouldRetryStorageStrategy;
import org.opensearch.repositories.gcs.ProxySettings;
import org.opensearch.repositories.gcs.TruststoreSettings;
import org.opensearch.secure_sm.AccessController;

public class GoogleCloudStorageService {
    private static final Logger logger = LogManager.getLogger(GoogleCloudStorageService.class);
    private volatile Map<String, GoogleCloudStorageClientSettings> clientSettings = Collections.emptyMap();
    private volatile Map<String, Storage> clientCache = Collections.emptyMap();
    private final GoogleApplicationDefaultCredentials googleApplicationDefaultCredentials;

    public GoogleCloudStorageService() {
        this.googleApplicationDefaultCredentials = new GoogleApplicationDefaultCredentials();
    }

    public GoogleCloudStorageService(GoogleApplicationDefaultCredentials googleApplicationDefaultCredentials) {
        this.googleApplicationDefaultCredentials = googleApplicationDefaultCredentials;
    }

    public synchronized void refreshAndClearCache(Map<String, GoogleCloudStorageClientSettings> clientsSettings) {
        this.clientCache = Collections.emptyMap();
        this.clientSettings = MapBuilder.newMapBuilder(clientsSettings).immutableMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Storage client(String clientName, String repositoryName, GoogleCloudStorageOperationsStats stats) throws IOException {
        Storage storage = this.clientCache.get(repositoryName);
        if (storage != null) {
            return storage;
        }
        GoogleCloudStorageService googleCloudStorageService = this;
        synchronized (googleCloudStorageService) {
            Storage existing = this.clientCache.get(repositoryName);
            if (existing != null) {
                return existing;
            }
            GoogleCloudStorageClientSettings settings = this.clientSettings.get(clientName);
            if (settings == null) {
                throw new IllegalArgumentException("Unknown client name [" + clientName + "]. Existing client configs: " + Strings.collectionToDelimitedString(this.clientSettings.keySet(), (String)","));
            }
            logger.debug(() -> new ParameterizedMessage("creating GCS client with client_name [{}], endpoint [{}]", (Object)clientName, (Object)settings.getHost()));
            Storage storage2 = this.createClient(settings, stats);
            this.clientCache = MapBuilder.newMapBuilder(this.clientCache).put((Object)repositoryName, (Object)storage2).immutableMap();
            return storage2;
        }
    }

    synchronized void closeRepositoryClient(String repositoryName) {
        this.clientCache = MapBuilder.newMapBuilder(this.clientCache).remove((Object)repositoryName).immutableMap();
    }

    private Storage createClient(GoogleCloudStorageClientSettings clientSettings, GoogleCloudStorageOperationsStats stats) throws IOException {
        HttpTransport httpTransport = this.createHttpTransport(clientSettings);
        final GoogleCloudStorageHttpStatsCollector httpStatsCollector = new GoogleCloudStorageHttpStatsCollector(stats);
        HttpTransportOptions httpTransportOptions = new HttpTransportOptions(HttpTransportOptions.newBuilder().setConnectTimeout(GoogleCloudStorageService.toTimeout(clientSettings.getConnectTimeout()).intValue()).setReadTimeout(GoogleCloudStorageService.toTimeout(clientSettings.getReadTimeout()).intValue()).setHttpTransportFactory(() -> httpTransport)){

            public HttpRequestInitializer getHttpRequestInitializer(ServiceOptions<?, ?> serviceOptions) {
                HttpRequestInitializer requestInitializer = super.getHttpRequestInitializer(serviceOptions);
                return httpRequest -> {
                    if (requestInitializer != null) {
                        requestInitializer.initialize(httpRequest);
                    }
                    httpRequest.setResponseInterceptor((HttpResponseInterceptor)httpStatsCollector);
                };
            }
        };
        StorageOptions storageOptions = this.createStorageOptions(clientSettings, httpTransportOptions);
        return (Storage)storageOptions.getService();
    }

    private HttpTransport createHttpTransport(GoogleCloudStorageClientSettings clientSettings) throws IOException {
        return (HttpTransport)AccessController.doPrivilegedChecked(() -> {
            try {
                NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
                TruststoreSettings truststoreSettings = clientSettings.getTruststoreSettings();
                builder.trustCertificates(this.loadTrustStore(truststoreSettings));
                final ProxySettings proxySettings = clientSettings.getProxySettings();
                if (proxySettings != ProxySettings.NO_PROXY_SETTINGS) {
                    if (proxySettings.isAuthenticated()) {
                        Authenticator.setDefault(new Authenticator(this){

                            @Override
                            protected PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(proxySettings.getUsername(), proxySettings.getPassword().toCharArray());
                            }
                        });
                    }
                    builder.setProxy(new Proxy(proxySettings.getType(), proxySettings.getAddress()));
                }
                return builder.build();
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Failed to configure HTTP transport security", e);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        });
    }

    private KeyStore loadTrustStore(TruststoreSettings truststoreSettings) throws GeneralSecurityException, IOException {
        KeyStore certTrustStore;
        if (truststoreSettings.isConfigured()) {
            Path truststorePath = truststoreSettings.path();
            String truststoreType = truststoreSettings.type();
            SecureString truststorePassword = truststoreSettings.password();
            certTrustStore = KeyStore.getInstance(truststoreType);
            try (InputStream trustStoreStream = Files.newInputStream(truststorePath, new OpenOption[0]);){
                SecurityUtils.loadKeyStore((KeyStore)certTrustStore, (InputStream)trustStoreStream, (String)truststorePassword.toString());
            }
            logger.debug("Loaded custom truststore from path: {} with type: {}", (Object)truststorePath, (Object)truststoreType);
        } else {
            if (Security.getProvider("BCFIPS") != null) {
                throw new IllegalStateException("FIPS mode is active but no custom truststore is configured. Please configure gcs.client.<client-name>.truststore.path and gcs.client.<client-name>.truststore.secure_password settings.");
            }
            certTrustStore = GoogleUtils.getCertificateTrustStore();
            logger.debug("Using Google default certificate trust store");
        }
        return certTrustStore;
    }

    StorageOptions createStorageOptions(GoogleCloudStorageClientSettings clientSettings, HttpTransportOptions httpTransportOptions) {
        StorageOptions.Builder storageOptionsBuilder = ((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setTransportOptions((TransportOptions)httpTransportOptions)).setHeaderProvider(() -> {
            MapBuilder mapBuilder = MapBuilder.newMapBuilder();
            if (Strings.hasLength((String)clientSettings.getApplicationName())) {
                mapBuilder.put((Object)"user-agent", (Object)clientSettings.getApplicationName());
            }
            return mapBuilder.immutableMap();
        })).setStorageRetryStrategy((StorageRetryStrategy)new GoogleShouldRetryStorageStrategy());
        if (Strings.hasLength((String)clientSettings.getHost())) {
            storageOptionsBuilder.setHost(clientSettings.getHost());
        }
        if (Strings.hasLength((String)clientSettings.getProjectId())) {
            storageOptionsBuilder.setProjectId(clientSettings.getProjectId());
        }
        if (clientSettings.getCredential() == null) {
            logger.info("\"Application Default Credentials\" will be in use");
            GoogleCredentials credentials = this.googleApplicationDefaultCredentials.get();
            if (credentials != null) {
                storageOptionsBuilder.setCredentials((Credentials)credentials);
            }
        } else {
            ServiceAccountCredentials serviceAccountCredentials = clientSettings.getCredential();
            URI tokenServerUri = clientSettings.getTokenUri();
            if (Strings.hasLength((String)tokenServerUri.toString())) {
                serviceAccountCredentials = serviceAccountCredentials.toBuilder().setTokenServerUri(tokenServerUri).build();
            }
            storageOptionsBuilder.setCredentials((Credentials)serviceAccountCredentials);
        }
        return (StorageOptions)AccessController.doPrivileged(() -> storageOptionsBuilder.build());
    }

    static Integer toTimeout(TimeValue timeout) {
        if (timeout == null || TimeValue.ZERO.equals((Object)timeout)) {
            return -1;
        }
        if (TimeValue.MINUS_ONE.equals((Object)timeout)) {
            return 0;
        }
        return Math.toIntExact(timeout.getMillis());
    }
}

