/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.http.HttpResponse;
import com.google.cloud.storage.multipartupload.model.CompleteMultipartUploadResponse;
import com.google.cloud.storage.multipartupload.model.UploadPartResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

final class ChecksumResponseParser {
    private ChecksumResponseParser() {
    }

    static UploadPartResponse parseUploadResponse(HttpResponse response) {
        String eTag = response.getHeaders().getETag();
        Map<String, String> hashes = ChecksumResponseParser.extractHashesFromHeader(response);
        return UploadPartResponse.builder().eTag(eTag).md5(hashes.get("md5")).build();
    }

    static CompleteMultipartUploadResponse parseCompleteResponse(HttpResponse response) throws IOException {
        Map<String, String> hashes = ChecksumResponseParser.extractHashesFromHeader(response);
        CompleteMultipartUploadResponse completeMpuResponse = (CompleteMultipartUploadResponse)response.parseAs(CompleteMultipartUploadResponse.class);
        return CompleteMultipartUploadResponse.builder().location(completeMpuResponse.location()).bucket(completeMpuResponse.bucket()).key(completeMpuResponse.key()).etag(completeMpuResponse.etag()).crc32c(hashes.get("crc32c")).build();
    }

    static Map<String, String> extractHashesFromHeader(HttpResponse response) {
        return Optional.ofNullable(response.getHeaders().getFirstHeaderStringValue("x-goog-hash")).map(h -> Arrays.stream(h.split(",")).map(s -> s.trim().split("=", 2)).filter(a -> ((String[])a).length == 2).filter(a -> "crc32c".equalsIgnoreCase(a[0]) || "md5".equalsIgnoreCase(a[0])).collect(Collectors.toMap(a -> a[0].toLowerCase(), a -> a[1], (v1, v2) -> v1))).orElse(Collections.emptyMap());
    }
}

