/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.scripts_painless_execute;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class PainlessContextSetup
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PainlessContextSetup> {
    @Nonnull
    private final JsonData document;
    @Nonnull
    private final String index;
    @Nullable
    private final Query query;
    public static final JsonpDeserializer<PainlessContextSetup> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PainlessContextSetup::setupPainlessContextSetupDeserializer);

    private PainlessContextSetup(Builder builder) {
        this.document = ApiTypeHelper.requireNonNull(builder.document, this, "document");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.query = builder.query;
    }

    public static PainlessContextSetup of(Function<Builder, ObjectBuilder<PainlessContextSetup>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final JsonData document() {
        return this.document;
    }

    @Nonnull
    public final String index() {
        return this.index;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("document");
        this.document.serialize(generator, mapper);
        generator.writeKey("index");
        generator.write(this.index);
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPainlessContextSetupDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::document, JsonData._DESERIALIZER, "document");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::query, Query._DESERIALIZER, "query");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.document.hashCode();
        result = 31 * result + this.index.hashCode();
        result = 31 * result + Objects.hashCode(this.query);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PainlessContextSetup other = (PainlessContextSetup)o;
        return this.document.equals(other.document) && this.index.equals(other.index) && Objects.equals(this.query, other.query);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, PainlessContextSetup> {
        private JsonData document;
        private String index;
        @Nullable
        private Query query;

        public Builder() {
        }

        private Builder(PainlessContextSetup o) {
            this.document = o.document;
            this.index = o.index;
            this.query = o.query;
        }

        private Builder(Builder o) {
            this.document = o.document;
            this.index = o.index;
            this.query = o.query;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder document(JsonData value) {
            this.document = value;
            return this;
        }

        @Nonnull
        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        @Nonnull
        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        @Override
        @Nonnull
        public PainlessContextSetup build() {
            this._checkSingleUse();
            return new PainlessContextSetup(this);
        }
    }
}

