/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.agent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import java.lang.invoke.CallSite;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLAgentType;
import org.opensearch.ml.common.MLMemoryType;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.MLTaskType;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.agent.MLMemorySpec;
import org.opensearch.ml.common.contextmanager.ContextManagementTemplate;
import org.opensearch.ml.common.contextmanager.ContextManager;
import org.opensearch.ml.common.contextmanager.ContextManagerHookProvider;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.hooks.HookRegistry;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.execute.agent.AgentInput;
import org.opensearch.ml.common.input.execute.agent.AgentInputProcessor;
import org.opensearch.ml.common.input.execute.agent.AgentMLInput;
import org.opensearch.ml.common.input.execute.agent.ContentBlock;
import org.opensearch.ml.common.input.execute.agent.ContentType;
import org.opensearch.ml.common.input.execute.agent.InputType;
import org.opensearch.ml.common.input.execute.agent.Message;
import org.opensearch.ml.common.memory.Memory;
import org.opensearch.ml.common.model.ModelProvider;
import org.opensearch.ml.common.model.ModelProviderFactory;
import org.opensearch.ml.common.output.MLTaskOutput;
import org.opensearch.ml.common.output.Output;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.settings.SettingsChangeListener;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.utils.MLTaskUtils;
import org.opensearch.ml.engine.Executable;
import org.opensearch.ml.engine.algorithms.agent.AgentUtils;
import org.opensearch.ml.engine.algorithms.agent.MLAGUIAgentRunner;
import org.opensearch.ml.engine.algorithms.agent.MLAgentRunner;
import org.opensearch.ml.engine.algorithms.agent.MLChatAgentRunner;
import org.opensearch.ml.engine.algorithms.agent.MLConversationalFlowAgentRunner;
import org.opensearch.ml.engine.algorithms.agent.MLFlowAgentRunner;
import org.opensearch.ml.engine.algorithms.agent.MLPlanExecuteAndReflectAgentRunner;
import org.opensearch.ml.engine.algorithms.contextmanager.ContextManagerFactory;
import org.opensearch.ml.engine.annotation.Function;
import org.opensearch.ml.engine.encryptor.Encryptor;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.ml.engine.memory.ConversationIndexMessage;
import org.opensearch.ml.memory.action.conversation.GetInteractionAction;
import org.opensearch.ml.memory.action.conversation.GetInteractionRequest;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.PutDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.client.Client;

@Function(value=FunctionName.AGENT)
public class MLAgentExecutor
implements Executable,
SettingsChangeListener {
    @Generated
    private static final Logger log = LogManager.getLogger(MLAgentExecutor.class);
    public static final String MEMORY_ID = "memory_id";
    public static final String QUESTION = "question";
    public static final String PARENT_INTERACTION_ID = "parent_interaction_id";
    public static final String REGENERATE_INTERACTION_ID = "regenerate_interaction_id";
    public static final String MESSAGE_HISTORY_LIMIT = "message_history_limit";
    public static final String ERROR_MESSAGE = "error_message";
    public static final String CONTEXT_MANAGEMENT_PROCESSED = "context_management_processed";
    private Client client;
    private SdkClient sdkClient;
    private Settings settings;
    private ClusterService clusterService;
    private NamedXContentRegistry xContentRegistry;
    private Map<String, Tool.Factory> toolFactories;
    private Map<String, Memory.Factory> memoryFactoryMap;
    private volatile Boolean isMultiTenancyEnabled;
    private Encryptor encryptor;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public MLAgentExecutor(Client client, SdkClient sdkClient, Settings settings, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Map<String, Tool.Factory> toolFactories, Map<String, Memory.Factory> memoryFactoryMap, MLFeatureEnabledSetting mlFeatureEnabledSetting, Encryptor encryptor) {
        this.client = client;
        this.sdkClient = sdkClient;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.toolFactories = toolFactories;
        this.memoryFactoryMap = memoryFactoryMap;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.encryptor = encryptor;
        this.isMultiTenancyEnabled = mlFeatureEnabledSetting.isMultiTenancyEnabled();
    }

    public void onMultiTenancyEnabledChanged(boolean isEnabled) {
        this.isMultiTenancyEnabled = isEnabled;
    }

    @Override
    public void execute(Input input, ActionListener<Output> listener, TransportChannel channel) {
        if (!(input instanceof AgentMLInput)) {
            throw new IllegalArgumentException("wrong input");
        }
        AgentMLInput agentMLInput = (AgentMLInput)input;
        String agentId = agentMLInput.getAgentId();
        String tenantId = agentMLInput.getTenantId();
        Boolean isAsync = agentMLInput.getIsAsync();
        if (agentMLInput.getInputDataset() == null && !agentMLInput.hasStandardInput()) {
            throw new IllegalArgumentException("Agent input data can not be empty.");
        }
        RemoteInferenceInputDataSet dataSet = (RemoteInferenceInputDataSet)agentMLInput.getInputDataset();
        if (!(dataSet != null && dataSet.getParameters() != null || agentMLInput.hasStandardInput())) {
            throw new IllegalArgumentException("Agent input data can not be empty.");
        }
        if (this.isMultiTenancyEnabled.booleanValue() && tenantId == null) {
            throw new OpenSearchStatusException("You don't have permission to access this resource", RestStatus.FORBIDDEN, new Object[0]);
        }
        ArrayList<ModelTensors> outputs = new ArrayList<ModelTensors>();
        ArrayList modelTensors = new ArrayList();
        outputs.add(ModelTensors.builder().mlModelTensors(modelTensors).build());
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-agent")).id(agentId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        if (MLIndicesHandler.doesMultiTenantIndexExist(this.clusterService, this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), ".plugins-ml-agent")) {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.sdkClient.getDataObjectAsync(getDataObjectRequest, (Executor)this.client.threadPool().executor("opensearch_ml_general")).whenComplete((response, throwable) -> {
                    block32: {
                        context.restore();
                        log.debug("Completed Get Agent Request, Agent id:{}", (Object)agentId);
                        if (throwable != null) {
                            Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                            if (ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                                log.error("Failed to get Agent index", (Throwable)cause);
                                listener.onFailure((Exception)new OpenSearchStatusException("Failed to get agent index", RestStatus.NOT_FOUND, new Object[0]));
                            } else {
                                log.error("Failed to get ML Agent {}", (Object)agentId, (Object)cause);
                                listener.onFailure(cause);
                            }
                        } else {
                            try {
                                GetResponse getAgentResponse;
                                GetResponse getResponse = getAgentResponse = response.parser() == null ? null : GetResponse.fromXContent((XContentParser)response.parser());
                                if (getAgentResponse != null && getAgentResponse.isExists()) {
                                    try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getAgentResponse.getSourceAsString());){
                                        HookRegistry hookRegistry;
                                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                        MLAgent mlAgent = MLAgent.parse((XContentParser)parser);
                                        HookRegistry hookRegistry2 = hookRegistry = agentMLInput.getHookRegistry() != null ? agentMLInput.getHookRegistry() : new HookRegistry();
                                        if (this.isMultiTenancyEnabled.booleanValue() && !Objects.equals(tenantId, mlAgent.getTenantId())) {
                                            listener.onFailure((Exception)new OpenSearchStatusException("You don't have permission to access this resource", RestStatus.FORBIDDEN, new Object[0]));
                                        }
                                        this.processAgentInput(agentMLInput, mlAgent);
                                        RemoteInferenceInputDataSet inputDataSet = (RemoteInferenceInputDataSet)agentMLInput.getInputDataset();
                                        Map requestParameters = inputDataSet.getParameters();
                                        MLAgent finalMlAgent = mlAgent = this.applyMemoryContainerOverride(mlAgent, inputDataSet, agentId);
                                        MLMemorySpec memorySpec = mlAgent.getMemory();
                                        if (!this.mlFeatureEnabledSetting.isRemoteAgenticMemoryEnabled()) {
                                            String memoryConfig;
                                            boolean usesRemoteMemory = memorySpec != null && MLMemoryType.REMOTE_AGENTIC_MEMORY.name().equalsIgnoreCase(memorySpec.getType());
                                            String string = memoryConfig = requestParameters != null ? (String)requestParameters.get("memory_configuration") : null;
                                            if (usesRemoteMemory || !Strings.isNullOrEmpty((String)memoryConfig)) {
                                                listener.onFailure((Exception)new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_REMOTE_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]));
                                                return;
                                            }
                                        }
                                        String memoryId = (String)inputDataSet.getParameters().get(MEMORY_ID);
                                        String parentInteractionId = (String)inputDataSet.getParameters().get(PARENT_INTERACTION_ID);
                                        String regenerateInteractionId = (String)inputDataSet.getParameters().get(REGENERATE_INTERACTION_ID);
                                        String appType = finalMlAgent.getAppType();
                                        String question = (String)inputDataSet.getParameters().get(QUESTION);
                                        if (parentInteractionId != null && regenerateInteractionId != null) {
                                            throw new IllegalArgumentException("Provide either `parent_interaction_id` to update an existing interaction, or `regenerate_interaction_id` to create a new one.");
                                        }
                                        MLTask mlTask = MLTask.builder().taskType(MLTaskType.AGENT_EXECUTION).functionName(FunctionName.AGENT).state(MLTaskState.CREATED).workerNodes((List)ImmutableList.of((Object)this.clusterService.localNode().getId())).createTime(Instant.now()).lastUpdateTime(Instant.now()).async(false).tenantId(tenantId).build();
                                        if (memoryId == null && regenerateInteractionId != null) {
                                            throw new IllegalArgumentException("A memory ID must be provided to regenerate.");
                                        }
                                        if (memorySpec != null && memorySpec.getType() != null && this.memoryFactoryMap != null && this.memoryFactoryMap.containsKey(MLMemoryType.from((String)memorySpec.getType()).name()) && (memoryId == null || parentInteractionId == null)) {
                                            Memory.Factory memoryFactory;
                                            Map<String, Object> memoryParams = AgentUtils.createMemoryParams(question, memoryId, appType, finalMlAgent, requestParameters);
                                            log.debug("MLAgentExecutor creating new memory, params: {}", AgentUtils.sanitizeForLogging(memoryParams));
                                            if (memoryParams != null && memoryParams.containsKey("endpoint")) {
                                                memoryFactory = this.memoryFactoryMap.get(MLMemoryType.REMOTE_AGENTIC_MEMORY.name());
                                                log.info("Detected inline connector metadata, using RemoteAgenticConversationMemory");
                                            } else {
                                                memoryFactory = this.memoryFactoryMap.get(MLMemoryType.from((String)memorySpec.getType()).name());
                                            }
                                            if (memoryFactory == null) {
                                                listener.onFailure((Exception)new IllegalArgumentException("Memory factory not found for type: " + (memoryParams != null && memoryParams.containsKey("endpoint") ? MLMemoryType.REMOTE_AGENTIC_MEMORY.name() : MLMemoryType.from((String)memorySpec.getType()).name())));
                                                return;
                                            }
                                            memoryFactory.create(memoryParams, ActionListener.wrap(memory -> {
                                                inputDataSet.getParameters().put(MEMORY_ID, memory.getId());
                                                if (regenerateInteractionId != null) {
                                                    log.info("Regenerate for existing interaction {}", (Object)regenerateInteractionId);
                                                    this.client.execute((ActionType)GetInteractionAction.INSTANCE, (ActionRequest)new GetInteractionRequest(regenerateInteractionId), ActionListener.wrap(interactionRes -> {
                                                        inputDataSet.getParameters().putIfAbsent(QUESTION, interactionRes.getInteraction().getInput());
                                                        this.saveRootInteractionAndExecute(listener, tenantId, (Memory)memory, inputDataSet, mlTask, isAsync, outputs, modelTensors, finalMlAgent, channel, hookRegistry, agentMLInput);
                                                    }, e -> {
                                                        log.error("Failed to get existing interaction for regeneration", (Throwable)e);
                                                        listener.onFailure(e);
                                                    }));
                                                } else {
                                                    this.saveRootInteractionAndExecute(listener, tenantId, (Memory)memory, inputDataSet, mlTask, isAsync, outputs, modelTensors, finalMlAgent, channel, hookRegistry, agentMLInput);
                                                }
                                            }, ex -> {
                                                log.error("Failed to read conversation memory", (Throwable)ex);
                                                listener.onFailure(ex);
                                            }));
                                        } else {
                                            Map<String, Object> memoryParams = AgentUtils.createMemoryParams(question, memoryId, appType, finalMlAgent, requestParameters);
                                            log.debug("MLAgentExecutor loading existing memory, params: {}", AgentUtils.sanitizeForLogging(memoryParams));
                                            if (memorySpec != null && memorySpec.getType() != null) {
                                                Memory.Factory memoryFactory;
                                                if (memoryParams != null && memoryParams.containsKey("endpoint")) {
                                                    memoryFactory = this.memoryFactoryMap.get(MLMemoryType.REMOTE_AGENTIC_MEMORY.name());
                                                    log.info("Detected inline connector metadata, using RemoteAgenticConversationMemory");
                                                } else {
                                                    memoryFactory = this.memoryFactoryMap.get(MLMemoryType.from((String)memorySpec.getType()).name());
                                                }
                                                if (memoryFactory != null) {
                                                    memoryFactory.create(memoryParams, ActionListener.wrap(createdMemory -> this.executeAgent(inputDataSet, tenantId, mlTask, isAsync, memoryId, finalMlAgent, outputs, modelTensors, listener, (Memory)createdMemory, channel, hookRegistry), ex -> {
                                                        log.error("Failed to find memory with memory_id: {}", (Object)memoryId, ex);
                                                        listener.onFailure(ex);
                                                    }));
                                                    return;
                                                }
                                            }
                                            this.executeAgent(inputDataSet, tenantId, mlTask, isAsync, memoryId, finalMlAgent, outputs, modelTensors, listener, null, channel, hookRegistry);
                                        }
                                        break block32;
                                    }
                                    catch (Exception e) {
                                        log.error("Failed to parse ml agent {}", (Object)agentId, (Object)e);
                                        listener.onFailure(e);
                                    }
                                    break block32;
                                }
                                listener.onFailure((Exception)new OpenSearchStatusException("Failed to find agent with the provided agent id: " + agentId, RestStatus.NOT_FOUND, new Object[0]));
                            }
                            catch (Exception e) {
                                log.error("Failed to get agent", (Throwable)e);
                                listener.onFailure(e);
                            }
                        }
                    }
                });
            }
        } else {
            listener.onFailure((Exception)new ResourceNotFoundException("Agent index not found", new Object[0]));
        }
    }

    private void saveRootInteractionAndExecute(ActionListener<Output> listener, String tenantId, Memory memory, RemoteInferenceInputDataSet inputDataSet, MLTask mlTask, boolean isAsync, List<ModelTensors> outputs, List<ModelTensor> modelTensors, MLAgent mlAgent, TransportChannel channel, HookRegistry hookRegistry, AgentMLInput agentMLInput) {
        String appType = mlAgent.getAppType();
        String question = (String)inputDataSet.getParameters().get(QUESTION);
        String regenerateInteractionId = (String)inputDataSet.getParameters().get(REGENERATE_INTERACTION_ID);
        if (agentMLInput.getAgentInput() != null && agentMLInput.getAgentInput().getInputType() == InputType.MESSAGES) {
            this.storeMessagesInMemory(memory, (List)agentMLInput.getAgentInput().getInput(), appType, (ActionListener<Void>)ActionListener.wrap(v -> this.createParentInteractionAndExecute(tenantId, memory, appType, question, regenerateInteractionId, inputDataSet, mlTask, isAsync, mlAgent, outputs, modelTensors, listener, channel, hookRegistry), ex -> {
                log.error("Failed to store message pairs in memory", (Throwable)ex);
                listener.onFailure(ex);
            }));
        } else {
            this.createParentInteractionAndExecute(tenantId, memory, appType, question, regenerateInteractionId, inputDataSet, mlTask, isAsync, mlAgent, outputs, modelTensors, listener, channel, hookRegistry);
        }
    }

    private void createParentInteractionAndExecute(String tenantId, Memory memory, String appType, String question, String regenerateInteractionId, RemoteInferenceInputDataSet inputDataSet, MLTask mlTask, boolean isAsync, MLAgent mlAgent, List<ModelTensors> outputs, List<ModelTensor> modelTensors, ActionListener<Output> listener, TransportChannel channel, HookRegistry hookRegistry) {
        ConversationIndexMessage msg = ConversationIndexMessage.conversationIndexMessageBuilder().type(appType).question(question).response("").finalAnswer(true).sessionId(memory.getId()).build();
        memory.save((org.opensearch.ml.common.memory.Message)msg, null, null, null, ActionListener.wrap(interaction -> {
            log.info("Created parent interaction ID: {}", (Object)interaction.getId());
            inputDataSet.getParameters().put(PARENT_INTERACTION_ID, interaction.getId());
            if (regenerateInteractionId != null) {
                memory.deleteInteractionAndTrace(regenerateInteractionId, ActionListener.wrap(deleted -> this.executeAgent(inputDataSet, tenantId, mlTask, isAsync, memory.getId(), mlAgent, outputs, modelTensors, listener, memory, channel, hookRegistry), e -> {
                    log.error("Failed to regenerate for interaction {}", (Object)regenerateInteractionId, e);
                    listener.onFailure(e);
                }));
            } else {
                this.executeAgent(inputDataSet, tenantId, mlTask, isAsync, memory.getId(), mlAgent, outputs, modelTensors, listener, memory, channel, hookRegistry);
            }
        }, ex -> {
            log.error("Failed to create parent interaction", (Throwable)ex);
            listener.onFailure(ex);
        }));
    }

    private void processContextManagement(MLAgent mlAgent, HookRegistry hookRegistry, RemoteInferenceInputDataSet inputDataSet) {
        try {
            String runtimeContextManagement = (String)inputDataSet.getParameters().get("context_management_name");
            if (runtimeContextManagement != null && !runtimeContextManagement.trim().isEmpty()) {
                log.info("Using runtime context management parameter: {}", (Object)runtimeContextManagement);
                return;
            }
            ContextManagementTemplate template = null;
            String templateName = null;
            if (mlAgent.hasContextManagementTemplate()) {
                templateName = mlAgent.getContextManagementTemplateName();
                log.info("Agent '{}' has context management template reference: {}", (Object)mlAgent.getName(), (Object)templateName);
                inputDataSet.getParameters().put("context_management_name", templateName);
                return;
            }
            if (mlAgent.getInlineContextManagement() != null) {
                template = mlAgent.getInlineContextManagement();
                templateName = template.getName();
                log.info("Agent '{}' has inline context management configuration: {}", (Object)mlAgent.getName(), (Object)templateName);
            }
            if (template != null) {
                this.processInlineContextManagement(template, hookRegistry);
                inputDataSet.getParameters().put(CONTEXT_MANAGEMENT_PROCESSED, "true");
                inputDataSet.getParameters().put("context_management_name", templateName);
            }
        }
        catch (Exception e) {
            log.error("Failed to process context management for agent '{}': {}", (Object)mlAgent.getName(), (Object)e.getMessage(), (Object)e);
        }
    }

    private void processInlineContextManagement(ContextManagementTemplate template, HookRegistry hookRegistry) {
        try {
            log.debug("Processing inline context management template: {}", (Object)template.getName());
            List<ContextManager> contextManagers = ContextManagerFactory.createContextManagers(template, this.client);
            if (!contextManagers.isEmpty()) {
                ContextManagerHookProvider hookProvider = new ContextManagerHookProvider(contextManagers, template.getHooks());
                hookProvider.registerHooks(hookRegistry);
                log.info("Successfully registered {} context managers from template '{}'", (Object)contextManagers.size(), (Object)template.getName());
            } else {
                log.warn("No context managers created from template '{}'", (Object)template.getName());
            }
        }
        catch (Exception e) {
            log.error("Failed to process inline context management template '{}': {}", (Object)template.getName(), (Object)e.getMessage(), (Object)e);
        }
    }

    @VisibleForTesting
    void storeMessagesInMemory(Memory memory, List<Message> messages, String appType, ActionListener<Void> listener) {
        ArrayList<ConversationIndexMessage> messagePairs = new ArrayList<ConversationIndexMessage>();
        StringBuilder userTextBuilder = new StringBuilder();
        StringBuilder assistantTextBuilder = new StringBuilder();
        boolean skippingTrailingUsers = true;
        String currentRole = null;
        for (int i = messages.size() - 1; i >= 0; --i) {
            String text;
            String role;
            Message message = messages.get(i);
            if (message == null || message.getRole() == null || !(role = message.getRole().toLowerCase()).equals("user") && !role.equals("assistant") || skippingTrailingUsers && role.equals("user")) continue;
            if (skippingTrailingUsers && role.equals("assistant")) {
                skippingTrailingUsers = false;
                log.info("Stopped skipping at assistant message at index {}", (Object)i);
            }
            if (currentRole != null && currentRole.equals("user") && role.equals("assistant")) {
                String userText = userTextBuilder.toString().trim();
                String assistantText = assistantTextBuilder.toString().trim();
                if (!userText.isEmpty() && !assistantText.isEmpty()) {
                    ConversationIndexMessage msg = ConversationIndexMessage.conversationIndexMessageBuilder().type(appType).question(userText).response(assistantText).finalAnswer(true).sessionId(memory.getId()).build();
                    messagePairs.add(msg);
                }
                userTextBuilder.setLength(0);
                assistantTextBuilder.setLength(0);
            }
            if (role.equals("user")) {
                text = this.extractTextFromMessage(message);
                if (!text.isEmpty()) {
                    if (userTextBuilder.length() > 0) {
                        userTextBuilder.insert(0, "\n");
                    }
                    userTextBuilder.insert(0, text);
                }
            } else if (role.equals("assistant") && !(text = this.extractTextFromMessage(message)).isEmpty()) {
                if (assistantTextBuilder.length() > 0) {
                    assistantTextBuilder.insert(0, "\n");
                }
                assistantTextBuilder.insert(0, text);
            }
            currentRole = role;
        }
        String userText = userTextBuilder.toString().trim();
        String assistantText = assistantTextBuilder.toString().trim();
        if (!userText.isEmpty() && !assistantText.isEmpty()) {
            ConversationIndexMessage msg = ConversationIndexMessage.conversationIndexMessageBuilder().type(appType).question(userText).response(assistantText).finalAnswer(true).sessionId(memory.getId()).build();
            messagePairs.add(msg);
        }
        Collections.reverse(messagePairs);
        if (messagePairs.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        this.saveMessagePairsSequentially(memory, messagePairs, listener);
    }

    @VisibleForTesting
    void saveMessagePairsSequentially(Memory memory, List<ConversationIndexMessage> messagePairs, ActionListener<Void> finalListener) {
        this.saveNextMessagePair(memory, messagePairs, 0, finalListener);
    }

    @VisibleForTesting
    void saveNextMessagePair(Memory memory, List<ConversationIndexMessage> messagePairs, int index, ActionListener<Void> finalListener) {
        if (index >= messagePairs.size()) {
            finalListener.onResponse(null);
            return;
        }
        ConversationIndexMessage msg = messagePairs.get(index);
        ActionListener saveListener = ActionListener.wrap(interaction -> {
            log.info("Stored message pair {} of {} in memory with interaction ID: {}", (Object)(index + 1), (Object)messagePairs.size(), (Object)interaction.getId());
            this.saveNextMessagePair(memory, messagePairs, index + 1, finalListener);
        }, ex -> {
            log.error("Failed to store message pair {} of {} in memory", (Object)(index + 1), (Object)messagePairs.size(), ex);
            this.saveNextMessagePair(memory, messagePairs, index + 1, finalListener);
        });
        memory.save((org.opensearch.ml.common.memory.Message)msg, null, null, null, saveListener);
    }

    private void executeAgent(RemoteInferenceInputDataSet inputDataSet, String tenantId, MLTask mlTask, boolean isAsync, String memoryId, MLAgent mlAgent, List<ModelTensors> outputs, List<ModelTensor> modelTensors, ActionListener<Output> listener, Memory memory, TransportChannel channel, HookRegistry hookRegistry) {
        String mcpConnectorConfigJSON;
        String string = mcpConnectorConfigJSON = mlAgent.getParameters() != null ? (String)mlAgent.getParameters().get("mcp_connectors") : null;
        if (mcpConnectorConfigJSON != null && !this.mlFeatureEnabledSetting.isMcpConnectorEnabled()) {
            listener.onFailure((Exception)new OpenSearchException(MLCommonsSettings.ML_COMMONS_MCP_CONNECTOR_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        if (mlAgent.hasContextManagement()) {
            this.processContextManagement(mlAgent, hookRegistry, inputDataSet);
        }
        MLAgentRunner mlAgentRunner = this.getAgentRunner(mlAgent, hookRegistry);
        String parentInteractionId = (String)inputDataSet.getParameters().get(PARENT_INTERACTION_ID);
        if (isAsync) {
            HashMap<String, String> agentResponse = new HashMap<String, String>();
            if (memoryId != null && !memoryId.isEmpty()) {
                agentResponse.put(MEMORY_ID, memoryId);
            }
            if (parentInteractionId != null && !parentInteractionId.isEmpty()) {
                agentResponse.put(PARENT_INTERACTION_ID, parentInteractionId);
            }
            mlTask.setResponse(agentResponse);
            mlTask.setAsync(true);
            this.indexMLTask(mlTask, (ActionListener<IndexResponse>)ActionListener.wrap(indexResponse -> {
                String taskId = indexResponse.getId();
                mlTask.setTaskId(taskId);
                MLTaskOutput outputBuilder = MLTaskOutput.builder().taskId(taskId).status(MLTaskState.RUNNING.toString()).build();
                if (memoryId != null && !memoryId.isEmpty()) {
                    outputBuilder.setResponse(agentResponse);
                }
                listener.onResponse((Object)outputBuilder);
                ActionListener<Object> agentActionListener = this.createAsyncTaskUpdater(mlTask, tenantId, outputs, modelTensors, parentInteractionId, memory);
                inputDataSet.getParameters().put("task_id", taskId);
                try {
                    mlAgentRunner.run(mlAgent, inputDataSet.getParameters(), agentActionListener, channel);
                }
                catch (Exception e) {
                    log.error("Failed to run agent", (Throwable)e);
                    agentActionListener.onFailure(e);
                }
            }, e -> {
                log.error("Failed to create task for agent async execution", (Throwable)e);
                listener.onFailure(e);
            }));
        } else {
            ActionListener<Object> agentActionListener = this.createAgentActionListener(listener, outputs, modelTensors, mlAgent.getType(), parentInteractionId, memory);
            try {
                mlAgentRunner.run(mlAgent, inputDataSet.getParameters(), agentActionListener, channel);
            }
            catch (Exception e2) {
                log.error("Failed to run agent", (Throwable)e2);
                agentActionListener.onFailure(e2);
            }
        }
    }

    private ActionListener<Object> createAgentActionListener(ActionListener<Output> listener, List<ModelTensors> outputs, List<ModelTensor> modelTensors, String agentType, String parentInteractionId, Memory memory) {
        return ActionListener.wrap(output -> {
            if (output != null) {
                this.processOutput(output, modelTensors);
                listener.onResponse((Object)ModelTensorOutput.builder().mlModelOutputs(outputs).build());
            } else {
                listener.onResponse(null);
            }
        }, ex -> {
            log.error("Failed to run {} agent", (Object)agentType, ex);
            this.updateInteractionWithFailure(parentInteractionId, memory, ex.getMessage());
            listener.onFailure(ex);
        });
    }

    private ActionListener<Object> createAsyncTaskUpdater(MLTask mlTask, String tenantId, List<ModelTensors> outputs, List<ModelTensor> modelTensors, String parentInteractionId, Memory memory) {
        String taskId = mlTask.getTaskId();
        HashMap agentResponse = new HashMap();
        HashMap updatedTask = new HashMap();
        return ActionListener.wrap(output -> {
            if (output != null) {
                this.processOutput(output, modelTensors);
                agentResponse.put("inference_results", outputs);
            } else {
                agentResponse.put(ERROR_MESSAGE, "No output found from agent execution");
            }
            mlTask.setResponse(agentResponse);
            updatedTask.put("response", agentResponse);
            updatedTask.put("state", MLTaskState.COMPLETED);
            MLTaskUtils.updateMLTaskDirectly((String)taskId, (String)tenantId, (Map)updatedTask, (Client)this.client, (SdkClient)this.sdkClient, (ActionListener)ActionListener.wrap(response -> log.info("Updated ML task {} with agent execution results", (Object)taskId), e -> log.error("Failed to update ML task {} with agent execution results: {}", (Object)taskId, (Object)e.getMessage(), e)));
        }, ex -> {
            agentResponse.put(ERROR_MESSAGE, ex.getMessage());
            updatedTask.put("response", agentResponse);
            updatedTask.put("state", MLTaskState.FAILED);
            mlTask.setResponse(agentResponse);
            MLTaskUtils.updateMLTaskDirectly((String)taskId, (String)tenantId, (Map)updatedTask, (Client)this.client, (SdkClient)this.sdkClient, (ActionListener)ActionListener.wrap(response -> log.info("Updated ML task {} with agent execution failed reason", (Object)taskId), e -> log.error("Failed to update ML task {} with agent execution results: {}", (Object)taskId, (Object)e.getMessage(), e)));
            this.updateInteractionWithFailure(parentInteractionId, memory, ex.getMessage());
        });
    }

    @VisibleForTesting
    protected MLAgentRunner getAgentRunner(MLAgent mlAgent, HookRegistry hookRegistry) {
        MLAgentType agentType = MLAgentType.from((String)mlAgent.getType().toUpperCase(Locale.ROOT));
        switch (agentType) {
            case FLOW: {
                return new MLFlowAgentRunner(this.client, this.settings, this.clusterService, this.xContentRegistry, this.toolFactories, this.memoryFactoryMap, this.sdkClient, this.encryptor);
            }
            case CONVERSATIONAL_FLOW: {
                return new MLConversationalFlowAgentRunner(this.client, this.settings, this.clusterService, this.xContentRegistry, this.toolFactories, this.memoryFactoryMap, this.sdkClient, this.encryptor);
            }
            case CONVERSATIONAL: {
                return new MLChatAgentRunner(this.client, this.settings, this.clusterService, this.xContentRegistry, this.toolFactories, this.memoryFactoryMap, this.sdkClient, this.encryptor, hookRegistry);
            }
            case PLAN_EXECUTE_AND_REFLECT: {
                return new MLPlanExecuteAndReflectAgentRunner(this.client, this.settings, this.clusterService, this.xContentRegistry, this.toolFactories, this.memoryFactoryMap, this.sdkClient, this.encryptor, hookRegistry);
            }
            case AG_UI: {
                return new MLAGUIAgentRunner(this.client, this.settings, this.clusterService, this.xContentRegistry, this.toolFactories, this.memoryFactoryMap, this.sdkClient, this.encryptor);
            }
        }
        throw new IllegalArgumentException("Unsupported agent type");
    }

    public void processOutput(Object output, List<ModelTensor> modelTensors) throws PrivilegedActionException {
        Gson gson = new Gson();
        if (output instanceof ModelTensorOutput) {
            ModelTensorOutput modelTensorOutput = (ModelTensorOutput)output;
            modelTensorOutput.getMlModelOutputs().forEach(outs -> modelTensors.addAll(outs.getMlModelTensors()));
        } else if (output instanceof ModelTensor) {
            modelTensors.add((ModelTensor)output);
        } else if (output instanceof List) {
            if (((List)output).get(0) instanceof ModelTensor) {
                modelTensors.addAll((List)output);
            } else if (((List)output).get(0) instanceof ModelTensors) {
                ((List)output).forEach(outs -> modelTensors.addAll(outs.getMlModelTensors()));
            } else {
                String result = AccessController.doPrivileged(() -> gson.toJson(output));
                modelTensors.add(ModelTensor.builder().name("response").result(result).build());
            }
        } else {
            String result = output instanceof String ? (String)output : AccessController.doPrivileged(() -> gson.toJson(output));
            modelTensors.add(ModelTensor.builder().name("response").result(result).build());
        }
    }

    public void indexMLTask(MLTask mlTask, ActionListener<IndexResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.sdkClient.putDataObjectAsync(((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().index(".plugins-ml-task")).tenantId(mlTask.getTenantId())).dataObject((ToXContentObject)mlTask).build()).whenComplete((r, throwable) -> {
                context.restore();
                if (throwable != null) {
                    Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                    log.error("Failed to index ML task", (Throwable)cause);
                    listener.onFailure(cause);
                } else {
                    try {
                        IndexResponse indexResponse = IndexResponse.fromXContent((XContentParser)r.parser());
                        log.info("Task creation result: {}, Task id: {}", (Object)indexResponse.getResult(), (Object)indexResponse.getId());
                        listener.onResponse((Object)indexResponse);
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to create ML task for {}, {}", (Object)mlTask.getFunctionName(), (Object)mlTask.getTaskType(), (Object)e);
            listener.onFailure(e);
        }
    }

    private void updateInteractionWithFailure(String interactionId, Memory memory, String errorMessage) {
        if (interactionId != null && memory != null) {
            String failureMessage = "Agent execution failed: " + errorMessage;
            HashMap<String, CallSite> updateContent = new HashMap<String, CallSite>();
            updateContent.put("response", (CallSite)((Object)failureMessage));
            memory.update(interactionId, updateContent, ActionListener.wrap(res -> log.info("Updated interaction {} with failure message", (Object)interactionId), e -> log.warn("Failed to update interaction {} with failure message", (Object)interactionId, e)));
        }
    }

    void processAgentInput(AgentMLInput agentMLInput, MLAgent mlAgent) {
        RemoteInferenceInputDataSet remoteInferenceInputDataSet;
        MLAgentType agentType = MLAgentType.from((String)mlAgent.getType());
        if (mlAgent.getModel() == null && agentType != MLAgentType.AG_UI) {
            return;
        }
        if (agentMLInput.getAgentInput() != null && agentMLInput.getAgentInput().getInputType() == InputType.MESSAGES && MLAgentType.from((String)mlAgent.getType()) == MLAgentType.PLAN_EXECUTE_AND_REFLECT) {
            throw new IllegalArgumentException("Messages input is not supported for Plan Execute and Reflect Agent.");
        }
        if (agentMLInput.getInputDataset() != null && (remoteInferenceInputDataSet = (RemoteInferenceInputDataSet)agentMLInput.getInputDataset()).getParameters().containsKey(QUESTION)) {
            AgentInput standardInput = new AgentInput(remoteInferenceInputDataSet.getParameters().get(QUESTION));
            agentMLInput.setAgentInput(standardInput);
        }
        try {
            String question = AgentInputProcessor.extractQuestionText((AgentInput)agentMLInput.getAgentInput());
            if (agentMLInput.getInputDataset() == null) {
                agentMLInput.setInputDataset((MLInputDataset)new RemoteInferenceInputDataSet(new HashMap()));
            }
            RemoteInferenceInputDataSet remoteDataSet = (RemoteInferenceInputDataSet)agentMLInput.getInputDataset();
            if (mlAgent.getModel() != null) {
                ModelProvider modelProvider = ModelProviderFactory.getProvider((String)mlAgent.getModel().getModelProvider());
                Map parameters = modelProvider.mapAgentInput(agentMLInput.getAgentInput(), agentType);
                parameters.put(QUESTION, question);
                remoteDataSet.getParameters().putAll(parameters);
            } else {
                remoteDataSet.getParameters().putIfAbsent(QUESTION, question);
            }
        }
        catch (Exception e) {
            log.error("Failed to process standardized input for agent {}", (Object)mlAgent.getName(), (Object)e);
            throw new IllegalArgumentException("Failed to process standardized agent input: " + e.getMessage(), e);
        }
    }

    private MLAgent applyMemoryContainerOverride(MLAgent mlAgent, RemoteInferenceInputDataSet inputDataSet, String agentId) {
        String containerParam;
        Map requestParameters = inputDataSet.getParameters();
        MLMemorySpec memorySpec = mlAgent.getMemory();
        String containerOverride = null;
        if (requestParameters != null && requestParameters.containsKey("memory_container_id") && !Strings.isNullOrEmpty((String)(containerParam = (String)requestParameters.get("memory_container_id")))) {
            containerOverride = containerParam;
        }
        if (containerOverride != null) {
            if (memorySpec == null) {
                throw new IllegalArgumentException("memory_container_id override requires the agent to be configured with memory");
            }
            String currentContainerId = memorySpec.getMemoryContainerId();
            if (!containerOverride.equals(currentContainerId)) {
                MLMemorySpec updatedSpec = memorySpec.toBuilder().memoryContainerId(containerOverride).build();
                mlAgent = mlAgent.toBuilder().memory(updatedSpec).build();
                log.debug("Agent {} overriding memory container from {} to {}", (Object)agentId, (Object)currentContainerId, (Object)containerOverride);
            }
        }
        return mlAgent;
    }

    @VisibleForTesting
    String extractTextFromMessage(Message message) {
        if (message == null || message.getContent() == null) {
            return "";
        }
        StringBuilder textBuilder = new StringBuilder();
        for (ContentBlock block : message.getContent()) {
            if (block.getType() != ContentType.TEXT || block.getText() == null) continue;
            textBuilder.append(block.getText().trim());
            textBuilder.append("\n");
        }
        return textBuilder.toString().trim();
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public SdkClient getSdkClient() {
        return this.sdkClient;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public ClusterService getClusterService() {
        return this.clusterService;
    }

    @Generated
    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Generated
    public Map<String, Tool.Factory> getToolFactories() {
        return this.toolFactories;
    }

    @Generated
    public Map<String, Memory.Factory> getMemoryFactoryMap() {
        return this.memoryFactoryMap;
    }

    @Generated
    public Boolean getIsMultiTenancyEnabled() {
        return this.isMultiTenancyEnabled;
    }

    @Generated
    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    @Generated
    public MLFeatureEnabledSetting getMlFeatureEnabledSetting() {
        return this.mlFeatureEnabledSetting;
    }

    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @Generated
    public void setSdkClient(SdkClient sdkClient) {
        this.sdkClient = sdkClient;
    }

    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Generated
    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Generated
    public void setXContentRegistry(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
    }

    @Generated
    public void setToolFactories(Map<String, Tool.Factory> toolFactories) {
        this.toolFactories = toolFactories;
    }

    @Generated
    public void setMemoryFactoryMap(Map<String, Memory.Factory> memoryFactoryMap) {
        this.memoryFactoryMap = memoryFactoryMap;
    }

    @Generated
    public void setIsMultiTenancyEnabled(Boolean isMultiTenancyEnabled) {
        this.isMultiTenancyEnabled = isMultiTenancyEnabled;
    }

    @Generated
    public void setEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Generated
    public void setMlFeatureEnabledSetting(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLAgentExecutor)) {
            return false;
        }
        MLAgentExecutor other = (MLAgentExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isMultiTenancyEnabled = this.getIsMultiTenancyEnabled();
        Boolean other$isMultiTenancyEnabled = other.getIsMultiTenancyEnabled();
        if (this$isMultiTenancyEnabled == null ? other$isMultiTenancyEnabled != null : !((Object)this$isMultiTenancyEnabled).equals(other$isMultiTenancyEnabled)) {
            return false;
        }
        Client this$client = this.getClient();
        Client other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        SdkClient this$sdkClient = this.getSdkClient();
        SdkClient other$sdkClient = other.getSdkClient();
        if (this$sdkClient == null ? other$sdkClient != null : !this$sdkClient.equals(other$sdkClient)) {
            return false;
        }
        Settings this$settings = this.getSettings();
        Settings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        ClusterService this$clusterService = this.getClusterService();
        ClusterService other$clusterService = other.getClusterService();
        if (this$clusterService == null ? other$clusterService != null : !this$clusterService.equals(other$clusterService)) {
            return false;
        }
        NamedXContentRegistry this$xContentRegistry = this.getXContentRegistry();
        NamedXContentRegistry other$xContentRegistry = other.getXContentRegistry();
        if (this$xContentRegistry == null ? other$xContentRegistry != null : !this$xContentRegistry.equals(other$xContentRegistry)) {
            return false;
        }
        Map<String, Tool.Factory> this$toolFactories = this.getToolFactories();
        Map<String, Tool.Factory> other$toolFactories = other.getToolFactories();
        if (this$toolFactories == null ? other$toolFactories != null : !((Object)this$toolFactories).equals(other$toolFactories)) {
            return false;
        }
        Map<String, Memory.Factory> this$memoryFactoryMap = this.getMemoryFactoryMap();
        Map<String, Memory.Factory> other$memoryFactoryMap = other.getMemoryFactoryMap();
        if (this$memoryFactoryMap == null ? other$memoryFactoryMap != null : !((Object)this$memoryFactoryMap).equals(other$memoryFactoryMap)) {
            return false;
        }
        Encryptor this$encryptor = this.getEncryptor();
        Encryptor other$encryptor = other.getEncryptor();
        if (this$encryptor == null ? other$encryptor != null : !this$encryptor.equals(other$encryptor)) {
            return false;
        }
        MLFeatureEnabledSetting this$mlFeatureEnabledSetting = this.getMlFeatureEnabledSetting();
        MLFeatureEnabledSetting other$mlFeatureEnabledSetting = other.getMlFeatureEnabledSetting();
        return !(this$mlFeatureEnabledSetting == null ? other$mlFeatureEnabledSetting != null : !this$mlFeatureEnabledSetting.equals(other$mlFeatureEnabledSetting));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLAgentExecutor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isMultiTenancyEnabled = this.getIsMultiTenancyEnabled();
        result = result * 59 + ($isMultiTenancyEnabled == null ? 43 : ((Object)$isMultiTenancyEnabled).hashCode());
        Client $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        SdkClient $sdkClient = this.getSdkClient();
        result = result * 59 + ($sdkClient == null ? 43 : $sdkClient.hashCode());
        Settings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        ClusterService $clusterService = this.getClusterService();
        result = result * 59 + ($clusterService == null ? 43 : $clusterService.hashCode());
        NamedXContentRegistry $xContentRegistry = this.getXContentRegistry();
        result = result * 59 + ($xContentRegistry == null ? 43 : $xContentRegistry.hashCode());
        Map<String, Tool.Factory> $toolFactories = this.getToolFactories();
        result = result * 59 + ($toolFactories == null ? 43 : ((Object)$toolFactories).hashCode());
        Map<String, Memory.Factory> $memoryFactoryMap = this.getMemoryFactoryMap();
        result = result * 59 + ($memoryFactoryMap == null ? 43 : ((Object)$memoryFactoryMap).hashCode());
        Encryptor $encryptor = this.getEncryptor();
        result = result * 59 + ($encryptor == null ? 43 : $encryptor.hashCode());
        MLFeatureEnabledSetting $mlFeatureEnabledSetting = this.getMlFeatureEnabledSetting();
        result = result * 59 + ($mlFeatureEnabledSetting == null ? 43 : $mlFeatureEnabledSetting.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLAgentExecutor(client=" + String.valueOf(this.getClient()) + ", sdkClient=" + String.valueOf(this.getSdkClient()) + ", settings=" + String.valueOf(this.getSettings()) + ", clusterService=" + String.valueOf(this.getClusterService()) + ", xContentRegistry=" + String.valueOf(this.getXContentRegistry()) + ", toolFactories=" + String.valueOf(this.getToolFactories()) + ", memoryFactoryMap=" + String.valueOf(this.getMemoryFactoryMap()) + ", isMultiTenancyEnabled=" + this.getIsMultiTenancyEnabled() + ", encryptor=" + String.valueOf(this.getEncryptor()) + ", mlFeatureEnabledSetting=" + String.valueOf(this.getMlFeatureEnabledSetting()) + ")";
    }

    @Generated
    public MLAgentExecutor() {
    }
}

