/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.testutils;

import com.amazon.randomcutforest.testutils.NormalMixtureTestData;
import java.util.Random;

public class ExampleDataSets {
    public static double[][] generateFan(int numberPerBlade, int numberOfBlades) {
        if (numberOfBlades > 12 || numberPerBlade <= 0) {
            return null;
        }
        int newDimensions = 2;
        int dataSize = numberOfBlades * numberPerBlade;
        Random prg = new Random(0L);
        NormalMixtureTestData generator = new NormalMixtureTestData(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
        double[][] data = generator.generateTestData(dataSize, newDimensions, 100);
        double[][] transformedData = new double[data.length][newDimensions];
        block0: for (int j = 0; j < data.length; ++j) {
            transformedData[j][0] = 0.05 * data[j][0];
            transformedData[j][1] = 0.2 * data[j][1];
            double toss = prg.nextDouble();
            for (int i = 0; i < numberOfBlades + 1; ++i) {
                if (!(toss < (double)i * 1.0 / (double)numberOfBlades)) continue;
                double[] vec = ExampleDataSets.rotateClockWise(transformedData[j], Math.PI * 2 * (double)i / (double)numberOfBlades);
                transformedData[j][0] = vec[0] + 0.6 * Math.sin(Math.PI * 2 * (double)i / (double)numberOfBlades);
                transformedData[j][1] = vec[1] + 0.6 * Math.cos(Math.PI * 2 * (double)i / (double)numberOfBlades);
                continue block0;
            }
        }
        return transformedData;
    }

    public static double[] rotateClockWise(double[] point, double theta) {
        double[] result = new double[]{Math.cos(theta) * point[0] + Math.sin(theta) * point[1], -Math.sin(theta) * point[0] + Math.cos(theta) * point[1]};
        return result;
    }

    public static double[][] generate(int size) {
        Random prg = new Random();
        double[][] data = new double[size][2];
        for (int i = 0; i < size; ++i) {
            boolean test = false;
            while (!test) {
                double y;
                double x = 2.0 * prg.nextDouble() - 1.0;
                if (x * x + (y = 2.0 * prg.nextDouble() - 1.0) * y <= 1.0) {
                    if (y > 0.0) {
                        if (x > 0.0 && (x - 0.5) * (x - 0.5) + y * y <= 0.25) {
                            test = (x - 0.5) * (x - 0.5) + y * y > 0.03125 && prg.nextDouble() < 0.6;
                        }
                    } else if (x > 0.0) {
                        if ((x - 0.5) * (x - 0.5) + y * y > 0.03125) {
                            test = (x - 0.5) * (x - 0.5) + y * y < 0.25 || prg.nextDouble() < 0.4;
                        }
                    } else {
                        boolean bl = test = (x + 0.5) * (x + 0.5) + y * y > 0.25 && prg.nextDouble() < 0.2;
                    }
                }
                if (!test) continue;
                data[i][0] = x;
                data[i][1] = y;
            }
        }
        return data;
    }
}

