/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.expression.core;

import java.util.List;
import java.util.Map;
import org.opensearch.sql.legacy.expression.core.Expression;
import org.opensearch.sql.legacy.expression.core.builder.ArithmeticFunctionFactory;
import org.opensearch.sql.legacy.expression.core.builder.ExpressionBuilder;
import org.opensearch.sql.legacy.expression.core.operator.ScalarOperation;
import org.opensearch.sql.legacy.expression.domain.BindingTuple;
import org.opensearch.sql.legacy.expression.model.ExprValue;
import shaded.com.google.common.collect.ImmutableMap;

public class ExpressionFactory {
    private static final Map<ScalarOperation, ExpressionBuilder> operationExpressionBuilderMap = new ImmutableMap.Builder().put((Object)ScalarOperation.ADD, (Object)ArithmeticFunctionFactory.add()).put((Object)ScalarOperation.SUBTRACT, (Object)ArithmeticFunctionFactory.subtract()).put((Object)ScalarOperation.MULTIPLY, (Object)ArithmeticFunctionFactory.multiply()).put((Object)ScalarOperation.DIVIDE, (Object)ArithmeticFunctionFactory.divide()).put((Object)ScalarOperation.MODULES, (Object)ArithmeticFunctionFactory.modules()).put((Object)ScalarOperation.ABS, (Object)ArithmeticFunctionFactory.abs()).put((Object)ScalarOperation.ACOS, (Object)ArithmeticFunctionFactory.acos()).put((Object)ScalarOperation.ASIN, (Object)ArithmeticFunctionFactory.asin()).put((Object)ScalarOperation.ATAN, (Object)ArithmeticFunctionFactory.atan()).put((Object)ScalarOperation.ATAN2, (Object)ArithmeticFunctionFactory.atan2()).put((Object)ScalarOperation.TAN, (Object)ArithmeticFunctionFactory.tan()).put((Object)ScalarOperation.CBRT, (Object)ArithmeticFunctionFactory.cbrt()).put((Object)ScalarOperation.CEIL, (Object)ArithmeticFunctionFactory.ceil()).put((Object)ScalarOperation.COS, (Object)ArithmeticFunctionFactory.cos()).put((Object)ScalarOperation.COSH, (Object)ArithmeticFunctionFactory.cosh()).put((Object)ScalarOperation.EXP, (Object)ArithmeticFunctionFactory.exp()).put((Object)ScalarOperation.FLOOR, (Object)ArithmeticFunctionFactory.floor()).put((Object)ScalarOperation.LN, (Object)ArithmeticFunctionFactory.ln()).put((Object)ScalarOperation.LOG, (Object)ArithmeticFunctionFactory.log()).put((Object)ScalarOperation.LOG2, (Object)ArithmeticFunctionFactory.log2()).put((Object)ScalarOperation.LOG10, (Object)ArithmeticFunctionFactory.log10()).build();

    public static Expression of(ScalarOperation op, List<Expression> expressions) {
        return operationExpressionBuilderMap.get((Object)op).build(expressions);
    }

    public static Expression ref(final String bindingName) {
        return new Expression(){

            @Override
            public ExprValue valueOf(BindingTuple tuple) {
                return tuple.resolve(bindingName);
            }

            public String toString() {
                return String.format("%s", bindingName);
            }
        };
    }

    public static Expression literal(final ExprValue value) {
        return new Expression(){

            @Override
            public ExprValue valueOf(BindingTuple tuple) {
                return value;
            }

            public String toString() {
                return String.format("%s", value);
            }
        };
    }

    public static Expression cast(final Expression expr) {
        return new Expression(){

            @Override
            public ExprValue valueOf(BindingTuple tuple) {
                return expr.valueOf(tuple);
            }

            public String toString() {
                return String.format("cast(%s)", expr);
            }
        };
    }
}

