/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.pollingingest;

import java.util.Objects;
import org.opensearch.cluster.metadata.IngestionSource;
import org.opensearch.index.IngestionConsumerFactory;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.engine.EngineFactory;
import org.opensearch.index.engine.IngestionEngine;
import org.opensearch.index.engine.NRTReplicationEngine;

public class IngestionEngineFactory
implements EngineFactory {
    private final IngestionConsumerFactory ingestionConsumerFactory;

    public IngestionEngineFactory(IngestionConsumerFactory ingestionConsumerFactory) {
        this.ingestionConsumerFactory = Objects.requireNonNull(ingestionConsumerFactory);
    }

    @Override
    public Engine newReadWriteEngine(EngineConfig config) {
        boolean isAllActiveIngestion;
        IngestionSource ingestionSource = config.getIndexSettings().getIndexMetadata().getIngestionSource();
        boolean bl = isAllActiveIngestion = ingestionSource != null && ingestionSource.isAllActiveIngestionEnabled();
        if (isAllActiveIngestion) {
            IngestionEngine ingestionEngine = new IngestionEngine(config, this.ingestionConsumerFactory);
            ingestionEngine.start();
            return ingestionEngine;
        }
        if (config.isReadOnlyReplica()) {
            return new NRTReplicationEngine(config);
        }
        IngestionEngine ingestionEngine = new IngestionEngine(config, this.ingestionConsumerFactory);
        ingestionEngine.start();
        return ingestionEngine;
    }
}

