/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.internal;

import jakarta.persistence.Entity;
import jakarta.persistence.GenerationType;
import jakarta.persistence.QueryHint;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.TableGenerator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Imported;
import org.hibernate.annotations.Parameter;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCollectionUserTypeRegistrationImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCompositeUserTypeRegistrationImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConfigurationParameterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConverterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConverterRegistrationImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddableInstantiatorRegistrationImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityListenerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbFilterDefImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbGenericIdGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJavaTypeRegistrationImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJdbcTypeRegistrationImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedHqlQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedNativeQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedStoredProcedureQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbQueryHint;
import org.hibernate.boot.jaxb.mapping.spi.JaxbQueryHintContainer;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSequenceGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSqlResultSetMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTableGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUserTypeRegistrationImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.JpaEventListenerStyle;
import org.hibernate.boot.models.annotations.internal.GenericGeneratorAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedNativeQueryJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedQueryJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedStoredProcedureQueryJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.QueryHintJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.SequenceGeneratorJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.SqlResultSetMappingJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.TableGeneratorJpaAnnotation;
import org.hibernate.boot.models.spi.CollectionTypeRegistration;
import org.hibernate.boot.models.spi.CompositeUserTypeRegistration;
import org.hibernate.boot.models.spi.ConversionRegistration;
import org.hibernate.boot.models.spi.ConverterRegistration;
import org.hibernate.boot.models.spi.EmbeddableInstantiatorRegistration;
import org.hibernate.boot.models.spi.FilterDefRegistration;
import org.hibernate.boot.models.spi.GenericGeneratorRegistration;
import org.hibernate.boot.models.spi.GlobalRegistrar;
import org.hibernate.boot.models.spi.GlobalRegistrations;
import org.hibernate.boot.models.spi.JavaTypeRegistration;
import org.hibernate.boot.models.spi.JdbcTypeRegistration;
import org.hibernate.boot.models.spi.JpaEventListener;
import org.hibernate.boot.models.spi.NamedNativeQueryRegistration;
import org.hibernate.boot.models.spi.NamedQueryRegistration;
import org.hibernate.boot.models.spi.NamedStoredProcedureQueryRegistration;
import org.hibernate.boot.models.spi.SequenceGeneratorRegistration;
import org.hibernate.boot.models.spi.SqlResultSetMappingRegistration;
import org.hibernate.boot.models.spi.TableGeneratorRegistration;
import org.hibernate.boot.models.spi.UserTypeRegistration;
import org.hibernate.boot.models.xml.internal.QueryProcessing;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserCollectionType;
import org.hibernate.usertype.UserType;

public class GlobalRegistrationsImpl
implements GlobalRegistrations,
GlobalRegistrar {
    private final ModelsContext sourceModelContext;
    private final BootstrapContext bootstrapContext;
    private List<JpaEventListener> jpaEventListeners;
    private List<ConversionRegistration> converterRegistrations;
    private List<JavaTypeRegistration> javaTypeRegistrations;
    private List<JdbcTypeRegistration> jdbcTypeRegistrations;
    private List<UserTypeRegistration> userTypeRegistrations;
    private List<CompositeUserTypeRegistration> compositeUserTypeRegistrations;
    private List<CollectionTypeRegistration> collectionTypeRegistrations;
    private List<EmbeddableInstantiatorRegistration> embeddableInstantiatorRegistrations;
    private Map<String, FilterDefRegistration> filterDefRegistrations;
    private Map<String, String> importedRenameMap;
    private Map<String, SequenceGeneratorRegistration> sequenceGeneratorRegistrations;
    private Map<String, TableGeneratorRegistration> tableGeneratorRegistrations;
    private Map<String, GenericGeneratorRegistration> genericGeneratorRegistrations;
    private Set<ConverterRegistration> jpaConverters;
    private Map<String, SqlResultSetMappingRegistration> sqlResultSetMappingRegistrations;
    private Map<String, NamedQueryRegistration> namedQueryRegistrations;
    private Map<String, NamedNativeQueryRegistration> namedNativeQueryRegistrations;
    private Map<String, NamedStoredProcedureQueryRegistration> namedStoredProcedureQueryRegistrations;

    public GlobalRegistrationsImpl(ModelsContext sourceModelContext, BootstrapContext bootstrapContext) {
        this.sourceModelContext = sourceModelContext;
        this.bootstrapContext = bootstrapContext;
    }

    @Override
    public <T> T as(Class<T> type) {
        return (T)this;
    }

    @Override
    public List<JpaEventListener> getEntityListenerRegistrations() {
        return this.jpaEventListeners == null ? Collections.emptyList() : this.jpaEventListeners;
    }

    @Override
    public List<ConversionRegistration> getConverterRegistrations() {
        return this.converterRegistrations == null ? Collections.emptyList() : this.converterRegistrations;
    }

    @Override
    public List<JavaTypeRegistration> getJavaTypeRegistrations() {
        return this.javaTypeRegistrations == null ? Collections.emptyList() : this.javaTypeRegistrations;
    }

    @Override
    public List<JdbcTypeRegistration> getJdbcTypeRegistrations() {
        return this.jdbcTypeRegistrations == null ? Collections.emptyList() : this.jdbcTypeRegistrations;
    }

    @Override
    public List<UserTypeRegistration> getUserTypeRegistrations() {
        return this.userTypeRegistrations == null ? Collections.emptyList() : this.userTypeRegistrations;
    }

    @Override
    public List<CompositeUserTypeRegistration> getCompositeUserTypeRegistrations() {
        return this.compositeUserTypeRegistrations == null ? Collections.emptyList() : this.compositeUserTypeRegistrations;
    }

    @Override
    public List<CollectionTypeRegistration> getCollectionTypeRegistrations() {
        return this.collectionTypeRegistrations == null ? Collections.emptyList() : this.collectionTypeRegistrations;
    }

    @Override
    public List<EmbeddableInstantiatorRegistration> getEmbeddableInstantiatorRegistrations() {
        return this.embeddableInstantiatorRegistrations == null ? Collections.emptyList() : this.embeddableInstantiatorRegistrations;
    }

    @Override
    public Map<String, FilterDefRegistration> getFilterDefRegistrations() {
        return this.filterDefRegistrations == null ? Collections.emptyMap() : this.filterDefRegistrations;
    }

    @Override
    public Map<String, String> getImportedRenames() {
        return this.importedRenameMap == null ? Collections.emptyMap() : this.importedRenameMap;
    }

    @Override
    public Map<String, SequenceGeneratorRegistration> getSequenceGeneratorRegistrations() {
        return this.sequenceGeneratorRegistrations == null ? Collections.emptyMap() : this.sequenceGeneratorRegistrations;
    }

    @Override
    public Map<String, TableGeneratorRegistration> getTableGeneratorRegistrations() {
        return this.tableGeneratorRegistrations == null ? Collections.emptyMap() : this.tableGeneratorRegistrations;
    }

    @Override
    public Map<String, GenericGeneratorRegistration> getGenericGeneratorRegistrations() {
        return this.genericGeneratorRegistrations == null ? Collections.emptyMap() : this.genericGeneratorRegistrations;
    }

    @Override
    public Set<ConverterRegistration> getJpaConverters() {
        return this.jpaConverters == null ? Collections.emptySet() : this.jpaConverters;
    }

    @Override
    public Map<String, SqlResultSetMappingRegistration> getSqlResultSetMappingRegistrations() {
        return this.sqlResultSetMappingRegistrations == null ? Collections.emptyMap() : this.sqlResultSetMappingRegistrations;
    }

    @Override
    public Map<String, NamedQueryRegistration> getNamedQueryRegistrations() {
        return this.namedQueryRegistrations == null ? Collections.emptyMap() : this.namedQueryRegistrations;
    }

    @Override
    public Map<String, NamedNativeQueryRegistration> getNamedNativeQueryRegistrations() {
        return this.namedNativeQueryRegistrations == null ? Collections.emptyMap() : this.namedNativeQueryRegistrations;
    }

    @Override
    public Map<String, NamedStoredProcedureQueryRegistration> getNamedStoredProcedureQueryRegistrations() {
        return this.namedStoredProcedureQueryRegistrations == null ? Collections.emptyMap() : this.namedStoredProcedureQueryRegistrations;
    }

    public void collectJavaTypeRegistrations(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.JAVA_TYPE_REGISTRATION, this.sourceModelContext, usage -> this.collectJavaTypeRegistration(this.toClassDetails(usage.javaType().getName()), this.toClassDetails(usage.descriptorClass().getName())));
    }

    public void collectJavaTypeRegistrations(List<JaxbJavaTypeRegistrationImpl> registrations) {
        if (CollectionHelper.isEmpty(registrations)) {
            return;
        }
        registrations.forEach(reg -> this.collectJavaTypeRegistration(this.toClassDetails(reg.getClazz()), this.toClassDetails(reg.getDescriptor())));
    }

    public void collectJavaTypeRegistration(ClassDetails javaType, ClassDetails descriptor) {
        this.collectJavaTypeRegistration(new JavaTypeRegistration(javaType, descriptor));
    }

    public void collectJavaTypeRegistration(JavaTypeRegistration registration) {
        if (this.javaTypeRegistrations == null) {
            this.javaTypeRegistrations = new ArrayList<JavaTypeRegistration>();
        }
        this.javaTypeRegistrations.add(registration);
    }

    public void collectJdbcTypeRegistrations(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.JDBC_TYPE_REGISTRATION, this.sourceModelContext, usage -> this.collectJdbcTypeRegistration(usage.registrationCode(), this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(usage.value().getName())));
    }

    public void collectJdbcTypeRegistrations(List<JaxbJdbcTypeRegistrationImpl> registrations) {
        if (CollectionHelper.isEmpty(registrations)) {
            return;
        }
        registrations.forEach(reg -> this.collectJdbcTypeRegistration(reg.getCode(), this.toClassDetails(reg.getDescriptor())));
    }

    public void collectJdbcTypeRegistration(Integer registrationCode, ClassDetails descriptor) {
        if (this.jdbcTypeRegistrations == null) {
            this.jdbcTypeRegistrations = new ArrayList<JdbcTypeRegistration>();
        }
        this.jdbcTypeRegistrations.add(new JdbcTypeRegistration(registrationCode, descriptor));
    }

    public void collectConverterRegistrations(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.CONVERTER_REGISTRATION, this.sourceModelContext, usage -> this.collectConverterRegistration(new ConversionRegistration(usage.domainType(), usage.converter(), usage.autoApply(), (AnnotationDescriptor<? extends Annotation>)HibernateAnnotations.CONVERTER_REGISTRATION)));
    }

    public void collectConverterRegistrations(List<JaxbConverterRegistrationImpl> registrations) {
        if (CollectionHelper.isEmpty(registrations)) {
            return;
        }
        registrations.forEach(registration -> {
            String explicitDomainTypeName = registration.getClazz();
            Class explicitDomainType = StringHelper.isNotEmpty(explicitDomainTypeName) ? this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(explicitDomainTypeName).toJavaClass() : null;
            Class converterType = this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(registration.getConverter()).toJavaClass();
            boolean autoApply = registration.isAutoApply();
            this.collectConverterRegistration(new ConversionRegistration(explicitDomainType, converterType, autoApply, (AnnotationDescriptor<? extends Annotation>)HibernateAnnotations.CONVERTER_REGISTRATION));
        });
    }

    public void collectConverterRegistration(ConversionRegistration conversion) {
        if (this.converterRegistrations == null) {
            this.converterRegistrations = new ArrayList<ConversionRegistration>();
        }
        this.converterRegistrations.add(conversion);
    }

    public void collectUserTypeRegistrations(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.TYPE_REGISTRATION, this.sourceModelContext, usage -> this.collectUserTypeRegistration(usage.basicClass(), usage.userType()));
    }

    public void collectUserTypeRegistrations(List<JaxbUserTypeRegistrationImpl> registrations) {
        if (CollectionHelper.isEmpty(registrations)) {
            return;
        }
        registrations.forEach(reg -> {
            ClassDetails domainTypeDetails = this.toClassDetails(reg.getClazz());
            ClassDetails descriptorDetails = this.toClassDetails(reg.getDescriptor());
            this.collectUserTypeRegistration(domainTypeDetails, descriptorDetails);
        });
    }

    public void collectUserTypeRegistration(ClassDetails domainClass, ClassDetails userTypeClass) {
        if (this.userTypeRegistrations == null) {
            this.userTypeRegistrations = new ArrayList<UserTypeRegistration>();
        }
        this.userTypeRegistrations.add(new UserTypeRegistration(domainClass, userTypeClass));
    }

    public void collectUserTypeRegistration(Class<?> domainClass, Class<? extends UserType<?>> userTypeClass) {
        this.collectUserTypeRegistration(this.toClassDetails(domainClass.getName()), this.toClassDetails(userTypeClass.getName()));
    }

    public void collectCompositeUserTypeRegistrations(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.COMPOSITE_TYPE_REGISTRATION, this.sourceModelContext, usage -> this.collectCompositeUserTypeRegistration(usage.embeddableClass(), usage.userType()));
    }

    public void collectCompositeUserTypeRegistrations(List<JaxbCompositeUserTypeRegistrationImpl> registrations) {
        if (CollectionHelper.isEmpty(registrations)) {
            return;
        }
        registrations.forEach(reg -> this.collectCompositeUserTypeRegistration(this.toClassDetails(reg.getClazz()), this.toClassDetails(reg.getDescriptor())));
    }

    public void collectCompositeUserTypeRegistration(ClassDetails domainClass, ClassDetails userTypeClass) {
        if (this.compositeUserTypeRegistrations == null) {
            this.compositeUserTypeRegistrations = new ArrayList<CompositeUserTypeRegistration>();
        }
        this.compositeUserTypeRegistrations.add(new CompositeUserTypeRegistration(domainClass, userTypeClass));
    }

    public void collectCompositeUserTypeRegistration(Class<?> domainClass, Class<? extends CompositeUserType<?>> userTypeClass) {
        this.collectCompositeUserTypeRegistration(this.toClassDetails(domainClass.getName()), this.toClassDetails(userTypeClass.getName()));
    }

    public void collectCollectionTypeRegistrations(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.COLLECTION_TYPE_REGISTRATION, this.sourceModelContext, usage -> this.collectCollectionTypeRegistration(usage.classification(), usage.type(), this.extractParameterMap(usage.parameters())));
    }

    private Map<String, String> extractParameterMap(Parameter[] parameters) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Parameter parameter : parameters) {
            result.put(parameter.name(), parameter.value());
        }
        return result;
    }

    public void collectCollectionTypeRegistrations(List<JaxbCollectionUserTypeRegistrationImpl> registrations) {
        if (CollectionHelper.isEmpty(registrations)) {
            return;
        }
        registrations.forEach(reg -> this.collectCollectionTypeRegistration(reg.getClassification(), this.toClassDetails(reg.getDescriptor()), this.extractParameterMap(reg.getParameters())));
    }

    private Map<String, String> extractParameterMap(List<JaxbConfigurationParameterImpl> parameters) {
        if (CollectionHelper.isEmpty(parameters)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        parameters.forEach(parameter -> result.put(parameter.getName(), parameter.getValue()));
        return result;
    }

    public void collectCollectionTypeRegistration(CollectionClassification classification, ClassDetails userTypeClass, Map<String, String> parameters) {
        if (this.collectionTypeRegistrations == null) {
            this.collectionTypeRegistrations = new ArrayList<CollectionTypeRegistration>();
        }
        this.collectionTypeRegistrations.add(new CollectionTypeRegistration(classification, userTypeClass, parameters));
    }

    public void collectCollectionTypeRegistration(CollectionClassification classification, Class<? extends UserCollectionType> userTypeClass, Map<String, String> parameters) {
        this.collectCollectionTypeRegistration(classification, this.toClassDetails(userTypeClass.getName()), parameters);
    }

    public void collectEmbeddableInstantiatorRegistrations(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.EMBEDDABLE_INSTANTIATOR_REGISTRATION, this.sourceModelContext, usage -> this.collectEmbeddableInstantiatorRegistration(usage.embeddableClass(), usage.instantiator()));
    }

    public void collectEmbeddableInstantiatorRegistrations(List<JaxbEmbeddableInstantiatorRegistrationImpl> registrations) {
        if (CollectionHelper.isEmpty(registrations)) {
            return;
        }
        registrations.forEach(reg -> this.collectEmbeddableInstantiatorRegistration(this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(reg.getEmbeddableClass()), this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(reg.getInstantiator())));
    }

    public void collectEmbeddableInstantiatorRegistration(ClassDetails embeddableClass, ClassDetails instantiator) {
        if (this.embeddableInstantiatorRegistrations == null) {
            this.embeddableInstantiatorRegistrations = new ArrayList<EmbeddableInstantiatorRegistration>();
        }
        this.embeddableInstantiatorRegistrations.add(new EmbeddableInstantiatorRegistration(embeddableClass, instantiator));
    }

    public void collectEmbeddableInstantiatorRegistration(Class<?> embeddableClass, Class<? extends EmbeddableInstantiator> instantiator) {
        this.collectEmbeddableInstantiatorRegistration(this.toClassDetails(embeddableClass.getName()), this.toClassDetails(instantiator.getName()));
    }

    public void collectFilterDefinitions(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.FILTER_DEF, this.sourceModelContext, usage -> {
            Map<String, ClassDetails> parameterResolvers;
            Map<String, ClassDetails> paramJdbcMappings;
            Object[] parameters = usage.parameters();
            if (CollectionHelper.isEmpty(parameters)) {
                paramJdbcMappings = Collections.emptyMap();
                parameterResolvers = Collections.emptyMap();
            } else {
                paramJdbcMappings = new HashMap();
                parameterResolvers = new HashMap();
                for (Object parameter : parameters) {
                    paramJdbcMappings.put(parameter.name(), this.toClassDetails(parameter.type()));
                    ClassDetails resolverClassDetails = this.toClassDetails(parameter.resolver());
                    if (resolverClassDetails.getName().equals(Supplier.class.getName())) continue;
                    parameterResolvers.put(parameter.name(), resolverClassDetails);
                }
            }
            this.collectFilterDefinition(usage.name(), usage.defaultCondition(), usage.autoEnabled(), usage.applyToLoadByKey(), paramJdbcMappings, parameterResolvers);
        });
    }

    private ClassDetails toClassDetails(Class<?> type) {
        return this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(type.getName());
    }

    private ClassDetails toClassDetails(String typeName) {
        return this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(typeName);
    }

    public void collectFilterDefinitions(List<JaxbFilterDefImpl> filterDefinitions) {
        if (CollectionHelper.isEmpty(filterDefinitions)) {
            return;
        }
        filterDefinitions.forEach(filterDefinition -> {
            Map<String, ClassDetails> parameterResolvers;
            Map<String, ClassDetails> paramJdbcMappings;
            List<JaxbFilterDefImpl.JaxbFilterParamImpl> jaxbParameters = filterDefinition.getFilterParams();
            if (jaxbParameters.isEmpty()) {
                paramJdbcMappings = Collections.emptyMap();
                parameterResolvers = Collections.emptyMap();
            } else {
                paramJdbcMappings = new HashMap();
                parameterResolvers = new HashMap();
                for (JaxbFilterDefImpl.JaxbFilterParamImpl jaxbParameter : jaxbParameters) {
                    ClassDetails targetClassDetails = XmlAnnotationHelper.resolveSimpleJavaType(jaxbParameter.getType(), this.sourceModelContext.getClassDetailsRegistry());
                    paramJdbcMappings.put(jaxbParameter.getName(), targetClassDetails);
                    if (!StringHelper.isNotEmpty(jaxbParameter.getResolver())) continue;
                    parameterResolvers.put(jaxbParameter.getName(), this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(jaxbParameter.getResolver()));
                }
            }
            this.collectFilterDefinition(filterDefinition.getName(), filterDefinition.getDefaultCondition(), filterDefinition.isAutoEnabled(), filterDefinition.isApplyToLoadByKey(), paramJdbcMappings, parameterResolvers);
        });
    }

    public void collectFilterDefinition(String name, String defaultCondition, boolean autoEnabled, boolean applyToLoadByKey, Map<String, ClassDetails> parameterTypes, Map<String, ClassDetails> parameterResolvers) {
        FilterDefRegistration previousEntry;
        if (this.filterDefRegistrations == null) {
            this.filterDefRegistrations = new HashMap<String, FilterDefRegistration>();
        }
        if ((previousEntry = this.filterDefRegistrations.put(name, new FilterDefRegistration(name, defaultCondition, autoEnabled, applyToLoadByKey, parameterTypes, parameterResolvers))) != null) {
            // empty if block
        }
    }

    public void collectImportRename(ClassDetails classDetails) {
        Imported importedUsage = (Imported)classDetails.getDirectAnnotationUsage(Imported.class);
        if (importedUsage == null) {
            return;
        }
        String explicitRename = importedUsage.rename();
        String rename = StringHelper.isNotEmpty(explicitRename) ? explicitRename : StringHelper.unqualify(classDetails.getName());
        this.collectImportRename(rename, classDetails.getName());
    }

    public void collectImportRename(String rename, String name) {
        if (this.importedRenameMap == null) {
            this.importedRenameMap = new HashMap<String, String>();
        }
        this.importedRenameMap.put(rename, name);
    }

    public void collectEntityListenerRegistrations(List<JaxbEntityListenerImpl> listeners, ModelsContext modelsContext) {
        if (CollectionHelper.isEmpty(listeners)) {
            return;
        }
        listeners.forEach(jaxbEntityListener -> {
            ClassDetails classDetails = this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(jaxbEntityListener.getClazz());
            JpaEventListener listener = JpaEventListener.from(JpaEventListenerStyle.LISTENER, classDetails, jaxbEntityListener, modelsContext);
            this.addJpaEventListener(listener);
        });
    }

    public void addJpaEventListener(JpaEventListener listener) {
        if (this.jpaEventListeners == null) {
            this.jpaEventListeners = new ArrayList<JpaEventListener>();
        }
        this.jpaEventListeners.add(listener);
    }

    public void collectIdGenerators(JaxbEntityMappingsImpl jaxbRoot) {
        this.collectSequenceGenerators(jaxbRoot.getSequenceGenerators());
        this.collectTableGenerators(jaxbRoot.getTableGenerators());
        this.collectGenericGenerators(jaxbRoot.getGenericGenerators());
    }

    public void collectIdGenerators(ClassDetails classDetails) {
        if (!classDetails.getName().endsWith(".package-info") && !this.bootstrapContext.getJpaCompliance().isGlobalGeneratorScopeEnabled()) {
            return;
        }
        classDetails.forEachRepeatedAnnotationUsages(JpaAnnotations.SEQUENCE_GENERATOR, this.sourceModelContext, sequenceGenerator -> this.collectSequenceGenerator(classDetails, (SequenceGenerator)sequenceGenerator));
        classDetails.forEachAnnotationUsage(JpaAnnotations.TABLE_GENERATOR, this.sourceModelContext, tableGenerator -> this.collectTableGenerator(classDetails, (TableGenerator)tableGenerator));
        classDetails.forEachAnnotationUsage(HibernateAnnotations.GENERIC_GENERATOR, this.sourceModelContext, this::collectGenericGenerator);
    }

    @Override
    public void collectIdGenerators(MemberDetails memberDetails) {
        if (!this.bootstrapContext.getJpaCompliance().isGlobalGeneratorScopeEnabled()) {
            return;
        }
        memberDetails.forEachRepeatedAnnotationUsages(JpaAnnotations.SEQUENCE_GENERATOR, this.sourceModelContext, sequenceGenerator -> this.collectSequenceGenerator(memberDetails, (SequenceGenerator)sequenceGenerator));
        memberDetails.forEachAnnotationUsage(JpaAnnotations.TABLE_GENERATOR, this.sourceModelContext, tableGenerator -> this.collectTableGenerator(memberDetails, (TableGenerator)tableGenerator));
        memberDetails.forEachAnnotationUsage(HibernateAnnotations.GENERIC_GENERATOR, this.sourceModelContext, this::collectGenericGenerator);
    }

    private String determineImplicitGeneratorNameBase(ClassDetails classDetails, GenerationType generationType) {
        if (classDetails.getName().endsWith(".package-info")) {
            throw new MappingException(String.format(Locale.ROOT, "@%s placed on package (%s) specified no name", generationType == GenerationType.SEQUENCE ? SequenceGenerator.class.getSimpleName() : TableGenerator.class.getSimpleName(), StringHelper.qualifier(classDetails.getName())));
        }
        Entity entityAnnotation = (Entity)classDetails.getDirectAnnotationUsage(JpaAnnotations.ENTITY);
        if (entityAnnotation != null) {
            String explicitEntityName = entityAnnotation.name();
            return StringHelper.isNotEmpty(explicitEntityName) ? explicitEntityName : StringHelper.unqualify(classDetails.getName());
        }
        return null;
    }

    public void collectSequenceGenerators(List<JaxbSequenceGeneratorImpl> sequenceGenerators) {
        if (CollectionHelper.isEmpty(sequenceGenerators)) {
            return;
        }
        sequenceGenerators.forEach(jaxbGenerator -> {
            SequenceGeneratorJpaAnnotation sequenceAnn = (SequenceGeneratorJpaAnnotation)((Object)JpaAnnotations.SEQUENCE_GENERATOR.createUsage(this.sourceModelContext));
            if (StringHelper.isNotEmpty(jaxbGenerator.getName())) {
                sequenceAnn.name(jaxbGenerator.getName());
            }
            if (jaxbGenerator.getSequenceName() != null) {
                sequenceAnn.sequenceName(jaxbGenerator.getSequenceName());
            }
            if (StringHelper.isNotEmpty(jaxbGenerator.getCatalog())) {
                sequenceAnn.catalog(jaxbGenerator.getCatalog());
            }
            if (StringHelper.isNotEmpty(jaxbGenerator.getSchema())) {
                sequenceAnn.schema(jaxbGenerator.getSchema());
            }
            if (jaxbGenerator.getInitialValue() != null) {
                sequenceAnn.initialValue(jaxbGenerator.getInitialValue());
            }
            if (jaxbGenerator.getAllocationSize() != null) {
                sequenceAnn.allocationSize(jaxbGenerator.getAllocationSize());
            }
            if (StringHelper.isNotEmpty(jaxbGenerator.getOptions())) {
                sequenceAnn.options(jaxbGenerator.getOptions());
            }
            this.collectSequenceGenerator(new SequenceGeneratorRegistration(jaxbGenerator.getName(), sequenceAnn));
        });
    }

    public void collectSequenceGenerator(MemberDetails memberDetails, SequenceGenerator usage) {
        this.collectSequenceGenerator(memberDetails.getDeclaringType(), usage);
    }

    public void collectSequenceGenerator(ClassDetails classDetails, SequenceGenerator usage) {
        Entity entityAnnotation;
        String registrationName = !usage.name().isEmpty() ? usage.name() : ((entityAnnotation = (Entity)classDetails.getDirectAnnotationUsage(Entity.class)) != null && !entityAnnotation.name().isEmpty() ? entityAnnotation.name() : StringHelper.unqualify(classDetails.getName()));
        this.collectSequenceGenerator(new SequenceGeneratorRegistration(registrationName, usage));
    }

    public void collectSequenceGenerator(SequenceGeneratorRegistration generatorRegistration) {
        this.checkGeneratorName(generatorRegistration.name());
        if (this.sequenceGeneratorRegistrations == null) {
            this.sequenceGeneratorRegistrations = new HashMap<String, SequenceGeneratorRegistration>();
        }
        this.sequenceGeneratorRegistrations.put(generatorRegistration.name(), generatorRegistration);
    }

    private void checkGeneratorName(String name) {
        this.checkGeneratorName(name, this.sequenceGeneratorRegistrations);
        this.checkGeneratorName(name, this.tableGeneratorRegistrations);
        this.checkGeneratorName(name, this.genericGeneratorRegistrations);
    }

    private void checkGeneratorName(String name, Map<String, ?> generatorMap) {
        if (generatorMap == null) {
            return;
        }
        if (generatorMap.containsKey(name)) {
            if (this.bootstrapContext.getJpaCompliance().isGlobalGeneratorScopeEnabled()) {
                throw new IllegalArgumentException("Duplicate generator name " + name + "; you will likely want to set the property hibernate.jpa.compliance.global_id_generators to false ");
            }
            CoreLogging.messageLogger(GlobalRegistrationsImpl.class).duplicateGeneratorName(name);
        }
    }

    public void collectTableGenerators(List<JaxbTableGeneratorImpl> jaxbGenerators) {
        if (CollectionHelper.isEmpty(jaxbGenerators)) {
            return;
        }
        jaxbGenerators.forEach(jaxbGenerator -> {
            TableGeneratorJpaAnnotation annotation = (TableGeneratorJpaAnnotation)JpaAnnotations.TABLE_GENERATOR.createUsage(this.sourceModelContext);
            if (StringHelper.isNotEmpty(jaxbGenerator.getName())) {
                annotation.name(jaxbGenerator.getName());
            }
            if (StringHelper.isNotEmpty(jaxbGenerator.getTable())) {
                annotation.table(jaxbGenerator.getTable());
            }
            if (StringHelper.isNotEmpty(jaxbGenerator.getCatalog())) {
                annotation.catalog(jaxbGenerator.getCatalog());
            }
            if (StringHelper.isNotEmpty(jaxbGenerator.getSchema())) {
                annotation.schema(jaxbGenerator.getSchema());
            }
            if (StringHelper.isNotEmpty(jaxbGenerator.getPkColumnName())) {
                annotation.pkColumnName(jaxbGenerator.getPkColumnName());
            }
            if (StringHelper.isNotEmpty(jaxbGenerator.getPkColumnValue())) {
                annotation.pkColumnValue(jaxbGenerator.getPkColumnValue());
            }
            if (StringHelper.isNotEmpty(jaxbGenerator.getValueColumnName())) {
                annotation.valueColumnName(jaxbGenerator.getValueColumnName());
            }
            if (jaxbGenerator.getInitialValue() != null) {
                annotation.initialValue(jaxbGenerator.getInitialValue());
            }
            if (jaxbGenerator.getAllocationSize() != null) {
                annotation.allocationSize(jaxbGenerator.getAllocationSize());
            }
            if (StringHelper.isNotEmpty(jaxbGenerator.getOptions())) {
                annotation.options(jaxbGenerator.getOptions());
            }
            annotation.uniqueConstraints(XmlAnnotationHelper.collectUniqueConstraints(jaxbGenerator.getUniqueConstraints(), this.sourceModelContext));
            annotation.indexes(XmlAnnotationHelper.collectIndexes(jaxbGenerator.getIndexes(), this.sourceModelContext));
            this.collectTableGenerator(new TableGeneratorRegistration(jaxbGenerator.getName(), annotation));
        });
    }

    public void collectTableGenerator(ClassDetails classDetails, TableGenerator usage) {
        TableGeneratorJpaAnnotation generatorAnnotation = new TableGeneratorJpaAnnotation(usage, this.sourceModelContext);
        Entity entityAnnotation = (Entity)classDetails.getDirectAnnotationUsage(Entity.class);
        String simpleName = entityAnnotation != null && !entityAnnotation.name().isEmpty() ? entityAnnotation.name() : StringHelper.unqualify(classDetails.getName());
        String registrationName = !usage.name().isEmpty() ? usage.name() : simpleName;
        generatorAnnotation.name(registrationName);
        this.collectTableGenerator(new TableGeneratorRegistration(registrationName, usage));
    }

    public void collectTableGenerator(MemberDetails memberDetails, TableGenerator usage) {
        Entity entityAnnotation;
        String registrationName = !usage.name().isEmpty() ? usage.name() : ((entityAnnotation = (Entity)memberDetails.getDeclaringType().getDirectAnnotationUsage(Entity.class)) != null && !entityAnnotation.name().isEmpty() ? entityAnnotation.name() : StringHelper.unqualify(memberDetails.getDeclaringType().getName()));
        this.collectTableGenerator(new TableGeneratorRegistration(registrationName, usage));
    }

    public void collectTableGenerator(TableGeneratorRegistration generatorRegistration) {
        this.checkGeneratorName(generatorRegistration.name());
        if (this.tableGeneratorRegistrations == null) {
            this.tableGeneratorRegistrations = new HashMap<String, TableGeneratorRegistration>();
        }
        this.tableGeneratorRegistrations.put(generatorRegistration.name(), generatorRegistration);
    }

    private void collectGenericGenerators(List<JaxbGenericIdGeneratorImpl> jaxbGenerators) {
        if (CollectionHelper.isEmpty(jaxbGenerators)) {
            return;
        }
        jaxbGenerators.forEach(jaxbGenerator -> {
            GenericGeneratorAnnotation annotation = (GenericGeneratorAnnotation)HibernateAnnotations.GENERIC_GENERATOR.createUsage(this.sourceModelContext);
            annotation.name(jaxbGenerator.getName());
            annotation.strategy(jaxbGenerator.getClazz());
            annotation.parameters(XmlAnnotationHelper.collectParameters(jaxbGenerator.getParameters(), this.sourceModelContext));
            this.collectGenericGenerator(new GenericGeneratorRegistration(jaxbGenerator.getName(), annotation));
        });
    }

    public void collectGenericGenerator(GenericGenerator usage) {
        if (usage.name().isEmpty()) {
            return;
        }
        this.collectGenericGenerator(new GenericGeneratorRegistration(usage.name(), usage));
    }

    public void collectGenericGenerator(GenericGeneratorRegistration generatorRegistration) {
        this.checkGeneratorName(generatorRegistration.name());
        if (this.genericGeneratorRegistrations == null) {
            this.genericGeneratorRegistrations = new HashMap<String, GenericGeneratorRegistration>();
        }
        this.genericGeneratorRegistrations.put(generatorRegistration.name(), generatorRegistration);
    }

    public void collectConverter(ClassDetails converterClassDetails) {
        if (this.jpaConverters == null) {
            this.jpaConverters = new HashSet<ConverterRegistration>();
        }
        this.jpaConverters.add(new ConverterRegistration(converterClassDetails, null));
    }

    public void collectConverters(List<JaxbConverterImpl> converters) {
        if (CollectionHelper.isEmpty(converters)) {
            return;
        }
        if (this.jpaConverters == null) {
            this.jpaConverters = CollectionHelper.setOfSize(converters.size());
        }
        converters.forEach(jaxbConverter -> {
            String converterClassName = jaxbConverter.getClazz();
            assert (converterClassName != null);
            ClassDetails converterType = this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(converterClassName);
            boolean autoApply = jaxbConverter.isAutoApply();
            this.jpaConverters.add(new ConverterRegistration(converterType, autoApply));
        });
    }

    public void collectQueryReferences(JaxbEntityMappingsImpl jaxbRoot, XmlDocumentContext xmlDocumentContext) {
        this.collectNamedSqlResultSetMappings(jaxbRoot.getSqlResultSetMappings(), xmlDocumentContext);
        this.collectNamedQueries(jaxbRoot.getNamedQueries(), xmlDocumentContext);
        this.collectNamedNativeQueries(jaxbRoot.getNamedNativeQueries(), xmlDocumentContext);
        this.collectStoredProcedureQueries(jaxbRoot.getNamedProcedureQueries(), xmlDocumentContext);
    }

    private void collectNamedSqlResultSetMappings(List<JaxbSqlResultSetMappingImpl> jaxbSqlResultSetMappings, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbSqlResultSetMappings)) {
            return;
        }
        if (this.sqlResultSetMappingRegistrations == null) {
            this.sqlResultSetMappingRegistrations = new HashMap<String, SqlResultSetMappingRegistration>();
        }
        jaxbSqlResultSetMappings.forEach(jaxbMapping -> {
            SqlResultSetMappingJpaAnnotation annotation = (SqlResultSetMappingJpaAnnotation)((Object)JpaAnnotations.SQL_RESULT_SET_MAPPING.createUsage(this.sourceModelContext));
            annotation.name(jaxbMapping.getName());
            annotation.columns(QueryProcessing.extractColumnResults(jaxbMapping.getColumnResult(), xmlDocumentContext));
            annotation.classes(QueryProcessing.extractConstructorResults(jaxbMapping.getConstructorResult(), xmlDocumentContext));
            annotation.entities(QueryProcessing.extractEntityResults(jaxbMapping.getEntityResult(), xmlDocumentContext));
            this.sqlResultSetMappingRegistrations.put(jaxbMapping.getName(), new SqlResultSetMappingRegistration(jaxbMapping.getName(), annotation));
        });
    }

    private void collectNamedQueries(List<JaxbNamedHqlQueryImpl> jaxbNamedQueries, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbNamedQueries)) {
            return;
        }
        if (this.namedQueryRegistrations == null) {
            this.namedQueryRegistrations = new HashMap<String, NamedQueryRegistration>();
        }
        for (JaxbNamedHqlQueryImpl jaxbNamedQuery : jaxbNamedQueries) {
            NamedQueryJpaAnnotation queryAnnotation = (NamedQueryJpaAnnotation)((Object)JpaAnnotations.NAMED_QUERY.createUsage(xmlDocumentContext.getModelBuildingContext()));
            this.namedQueryRegistrations.put(jaxbNamedQuery.getName(), new NamedQueryRegistration(jaxbNamedQuery.getName(), queryAnnotation));
            queryAnnotation.name(jaxbNamedQuery.getName());
            queryAnnotation.query(jaxbNamedQuery.getQuery());
            if (jaxbNamedQuery.getLockMode() != null) {
                queryAnnotation.lockMode(jaxbNamedQuery.getLockMode());
            }
            queryAnnotation.hints(this.collectQueryHints(jaxbNamedQuery, xmlDocumentContext));
        }
    }

    private QueryHint[] collectQueryHints(JaxbNamedHqlQueryImpl jaxbNamedQuery, XmlDocumentContext xmlDocumentContext) {
        QueryHintJpaAnnotation hint;
        List<QueryHint> hints = this.extractQueryHints(jaxbNamedQuery);
        if (jaxbNamedQuery.isCacheable() == Boolean.TRUE) {
            QueryHintJpaAnnotation cacheableHint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(xmlDocumentContext.getModelBuildingContext()));
            cacheableHint.name("org.hibernate.cacheable");
            cacheableHint.value(Boolean.TRUE.toString());
            hints.add(cacheableHint);
            if (jaxbNamedQuery.getCacheMode() != null) {
                QueryHintJpaAnnotation cacheModeHint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(xmlDocumentContext.getModelBuildingContext()));
                cacheModeHint.name("org.hibernate.cacheMode");
                cacheModeHint.value(jaxbNamedQuery.getCacheMode().name());
                hints.add(cacheModeHint);
            }
            if (StringHelper.isNotEmpty(jaxbNamedQuery.getCacheRegion())) {
                QueryHintJpaAnnotation cacheRegionHint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(xmlDocumentContext.getModelBuildingContext()));
                cacheRegionHint.name("org.hibernate.cacheRegion");
                cacheRegionHint.value(jaxbNamedQuery.getCacheRegion());
                hints.add(cacheRegionHint);
            }
        }
        if (StringHelper.isNotEmpty(jaxbNamedQuery.getComment())) {
            hint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(xmlDocumentContext.getModelBuildingContext()));
            hint.name("org.hibernate.comment");
            hint.value(jaxbNamedQuery.getComment());
            hints.add(hint);
        }
        if (jaxbNamedQuery.getFetchSize() != null) {
            hint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(xmlDocumentContext.getModelBuildingContext()));
            hint.name("org.hibernate.fetchSize");
            hint.value(jaxbNamedQuery.getFetchSize().toString());
            hints.add(hint);
        }
        if (jaxbNamedQuery.isReadOnly() == Boolean.TRUE) {
            hint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(xmlDocumentContext.getModelBuildingContext()));
            hint.name("org.hibernate.readOnly");
            hint.value(Boolean.TRUE.toString());
            hints.add(hint);
        }
        if (jaxbNamedQuery.getFlushMode() != null) {
            hint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(xmlDocumentContext.getModelBuildingContext()));
            hint.name("org.hibernate.flushMode");
            hint.value(jaxbNamedQuery.getFlushMode().name());
            hints.add(hint);
        }
        return (QueryHint[])hints.toArray(QueryHint[]::new);
    }

    private void collectNamedNativeQueries(List<JaxbNamedNativeQueryImpl> namedNativeQueries, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(namedNativeQueries)) {
            return;
        }
        if (this.namedNativeQueryRegistrations == null) {
            this.namedNativeQueryRegistrations = new HashMap<String, NamedNativeQueryRegistration>();
        }
        for (JaxbNamedNativeQueryImpl jaxbNamedQuery : namedNativeQueries) {
            NamedNativeQueryJpaAnnotation queryAnnotation = (NamedNativeQueryJpaAnnotation)((Object)JpaAnnotations.NAMED_NATIVE_QUERY.createUsage(xmlDocumentContext.getModelBuildingContext()));
            this.namedNativeQueryRegistrations.put(jaxbNamedQuery.getName(), new NamedNativeQueryRegistration(jaxbNamedQuery.getName(), queryAnnotation));
            queryAnnotation.name(jaxbNamedQuery.getName());
            queryAnnotation.query(jaxbNamedQuery.getQuery());
            if (StringHelper.isNotEmpty(jaxbNamedQuery.getResultClass())) {
                ClassDetails resultClassDetails = this.toClassDetails(jaxbNamedQuery.getResultClass());
                queryAnnotation.resultClass(resultClassDetails.toJavaClass());
            }
            this.applyResultSetMapping(jaxbNamedQuery, queryAnnotation, xmlDocumentContext);
            queryAnnotation.hints(this.collectNativeQueryHints(jaxbNamedQuery));
        }
    }

    private void applyResultSetMapping(JaxbNamedNativeQueryImpl jaxbNamedQuery, NamedNativeQueryJpaAnnotation queryAnnotation, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(jaxbNamedQuery.getResultSetMapping())) {
            queryAnnotation.resultSetMapping(jaxbNamedQuery.getResultSetMapping());
            return;
        }
        queryAnnotation.columns(QueryProcessing.extractColumnResults(jaxbNamedQuery.getColumnResult(), xmlDocumentContext));
        queryAnnotation.classes(QueryProcessing.extractConstructorResults(jaxbNamedQuery.getConstructorResult(), xmlDocumentContext));
        queryAnnotation.entities(QueryProcessing.extractEntityResults(jaxbNamedQuery.getEntityResult(), xmlDocumentContext));
    }

    private QueryHint[] collectNativeQueryHints(JaxbNamedNativeQueryImpl jaxbNamedQuery) {
        QueryHintJpaAnnotation hint;
        List<QueryHint> hints = this.extractQueryHints(jaxbNamedQuery);
        if (jaxbNamedQuery.isCacheable() == Boolean.TRUE) {
            QueryHintJpaAnnotation cacheableHint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(this.sourceModelContext));
            cacheableHint.name("org.hibernate.cacheable");
            cacheableHint.value(Boolean.TRUE.toString());
            hints.add(cacheableHint);
            if (jaxbNamedQuery.getCacheMode() != null) {
                QueryHintJpaAnnotation cacheModeHint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(this.sourceModelContext));
                cacheModeHint.name("org.hibernate.cacheMode");
                cacheModeHint.value(jaxbNamedQuery.getCacheMode().name());
                hints.add(cacheModeHint);
            }
            if (StringHelper.isNotEmpty(jaxbNamedQuery.getCacheRegion())) {
                QueryHintJpaAnnotation cacheRegionHint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(this.sourceModelContext));
                cacheRegionHint.name("org.hibernate.cacheRegion");
                cacheRegionHint.value(jaxbNamedQuery.getCacheRegion());
                hints.add(cacheRegionHint);
            }
        }
        if (jaxbNamedQuery.isReadOnly() == Boolean.TRUE) {
            hint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(this.sourceModelContext));
            hint.name("org.hibernate.readOnly");
            hint.value(Boolean.TRUE.toString());
            hints.add(hint);
        }
        if (StringHelper.isNotEmpty(jaxbNamedQuery.getComment())) {
            hint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(this.sourceModelContext));
            hint.name("org.hibernate.comment");
            hint.value(jaxbNamedQuery.getComment());
            hints.add(hint);
        }
        return (QueryHint[])hints.toArray(QueryHint[]::new);
    }

    private void collectStoredProcedureQueries(List<JaxbNamedStoredProcedureQueryImpl> namedProcedureQueries, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(namedProcedureQueries)) {
            return;
        }
        if (this.namedStoredProcedureQueryRegistrations == null) {
            this.namedStoredProcedureQueryRegistrations = new HashMap<String, NamedStoredProcedureQueryRegistration>();
        }
        for (JaxbNamedStoredProcedureQueryImpl jaxbQuery : namedProcedureQueries) {
            NamedStoredProcedureQueryJpaAnnotation queryAnnotation = (NamedStoredProcedureQueryJpaAnnotation)((Object)JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY.createUsage(this.sourceModelContext));
            this.namedStoredProcedureQueryRegistrations.put(jaxbQuery.getName(), new NamedStoredProcedureQueryRegistration(jaxbQuery.getName(), queryAnnotation));
            queryAnnotation.name(jaxbQuery.getName());
            queryAnnotation.procedureName(jaxbQuery.getProcedureName());
            queryAnnotation.resultClasses(QueryProcessing.collectResultClasses(jaxbQuery.getResultClasses(), xmlDocumentContext));
            if (CollectionHelper.isNotEmpty(jaxbQuery.getResultSetMappings())) {
                queryAnnotation.resultSetMappings((String[])jaxbQuery.getResultSetMappings().toArray(String[]::new));
            }
            queryAnnotation.hints((QueryHint[])this.extractQueryHints(jaxbQuery).toArray(QueryHint[]::new));
            queryAnnotation.parameters(QueryProcessing.collectParameters(jaxbQuery.getProcedureParameters(), xmlDocumentContext));
        }
    }

    private List<QueryHint> extractQueryHints(JaxbQueryHintContainer jaxbQuery) {
        ArrayList<QueryHint> hints = new ArrayList<QueryHint>();
        for (JaxbQueryHint jaxbQueryHint : jaxbQuery.getHints()) {
            QueryHintJpaAnnotation hint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(this.sourceModelContext));
            hint.name(jaxbQueryHint.getName());
            hint.value(jaxbQueryHint.getValue());
        }
        return hints;
    }
}

