/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.DefaultApplicationModel;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.ExtensionDevModeConfig;
import io.quarkus.bootstrap.model.JvmOptions;
import io.quarkus.bootstrap.model.JvmOptionsBuilder;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactCoordsPattern;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jboss.logging.Logger;

public class ApplicationModelBuilder {
    public static final String PARENT_FIRST_ARTIFACTS = "parent-first-artifacts";
    public static final String RUNNER_PARENT_FIRST_ARTIFACTS = "runner-parent-first-artifacts";
    public static final String EXCLUDED_ARTIFACTS = "excluded-artifacts";
    public static final String REMOVED_RESOURCES_DOT = "removed-resources.";
    public static final String LESSER_PRIORITY_ARTIFACTS = "lesser-priority-artifacts";
    private static final Logger log = Logger.getLogger(ApplicationModelBuilder.class);
    private static final String COMMA = ",";
    ResolvedDependencyBuilder appArtifact;
    final Map<ArtifactKey, ResolvedDependencyBuilder> dependencies = new LinkedHashMap<ArtifactKey, ResolvedDependencyBuilder>();
    final Collection<ArtifactKey> parentFirstArtifacts = new ConcurrentLinkedDeque<ArtifactKey>();
    final Collection<ArtifactKey> runnerParentFirstArtifacts = new ConcurrentLinkedDeque<ArtifactKey>();
    final Collection<ArtifactCoordsPattern> excludedArtifacts = new ConcurrentLinkedDeque<ArtifactCoordsPattern>();
    final Map<ArtifactKey, Set<String>> excludedResources = new ConcurrentHashMap<ArtifactKey, Set<String>>();
    final Collection<ArtifactKey> lesserPriorityArtifacts = new ConcurrentLinkedDeque<ArtifactKey>();
    final Collection<ArtifactKey> reloadableWorkspaceModules = new ConcurrentLinkedDeque<ArtifactKey>();
    final Collection<ExtensionCapabilities> extensionCapabilities = new ConcurrentLinkedDeque<ExtensionCapabilities>();
    PlatformImports platformImports;
    final Map<WorkspaceModuleId, WorkspaceModule.Mutable> projectModules = new HashMap<WorkspaceModuleId, WorkspaceModule.Mutable>();
    final Collection<ExtensionDevModeConfig> extensionDevConfig = new ConcurrentLinkedDeque<ExtensionDevModeConfig>();

    public ApplicationModelBuilder() {
        this.excludedArtifacts.add(ArtifactCoordsPattern.builder().setGroupId("io.quarkus").setArtifactId("quarkus-ide-launcher").build());
    }

    public ApplicationModelBuilder setAppArtifact(ResolvedDependencyBuilder appArtifact) {
        this.appArtifact = appArtifact;
        return this;
    }

    public ResolvedDependencyBuilder getApplicationArtifact() {
        return this.appArtifact;
    }

    public ApplicationModelBuilder setPlatformImports(PlatformImports platformImports) {
        this.platformImports = platformImports;
        return this;
    }

    public ApplicationModelBuilder addExtensionCapabilities(ExtensionCapabilities extensionCapabilities) {
        this.extensionCapabilities.add(extensionCapabilities);
        return this;
    }

    public ApplicationModelBuilder addDependency(ResolvedDependencyBuilder dep) {
        this.dependencies.put(dep.getKey(), dep);
        return this;
    }

    public ApplicationModelBuilder addDependencies(Collection<ResolvedDependencyBuilder> deps) {
        deps.forEach(this::addDependency);
        return this;
    }

    public boolean hasDependency(ArtifactKey key) {
        return this.dependencies.containsKey(key);
    }

    public ResolvedDependencyBuilder getDependency(ArtifactKey key) {
        return this.dependencies.get(key);
    }

    public Collection<ResolvedDependencyBuilder> getDependencies() {
        return this.dependencies.values();
    }

    public ApplicationModelBuilder addParentFirstArtifact(ArtifactKey deps) {
        this.parentFirstArtifacts.add(deps);
        return this;
    }

    public ApplicationModelBuilder addParentFirstArtifacts(List<ArtifactKey> deps) {
        this.parentFirstArtifacts.addAll(deps);
        return this;
    }

    public ApplicationModelBuilder addRunnerParentFirstArtifact(ArtifactKey deps) {
        this.runnerParentFirstArtifacts.add(deps);
        return this;
    }

    public ApplicationModelBuilder addRunnerParentFirstArtifacts(List<ArtifactKey> deps) {
        this.runnerParentFirstArtifacts.addAll(deps);
        return this;
    }

    public ApplicationModelBuilder addExcludedArtifact(ArtifactKey key) {
        this.excludedArtifacts.add(ArtifactCoordsPattern.builder().setGroupId(key.getGroupId()).setArtifactId(key.getArtifactId()).setClassifier(key.getClassifier()).setType(key.getType()).build());
        return this;
    }

    public ApplicationModelBuilder addExcludedArtifacts(List<ArtifactKey> keys) {
        for (ArtifactKey key : keys) {
            this.addExcludedArtifact(key);
        }
        return this;
    }

    public ApplicationModelBuilder addRemovedResources(ArtifactKey key, Set<String> resources) {
        this.excludedResources.computeIfAbsent(key, k -> new HashSet(resources.size())).addAll(resources);
        return this;
    }

    public ApplicationModelBuilder addLesserPriorityArtifact(ArtifactKey deps) {
        this.lesserPriorityArtifacts.add(deps);
        return this;
    }

    public ApplicationModelBuilder addReloadableWorkspaceModule(ArtifactKey key) {
        this.reloadableWorkspaceModules.add(key);
        return this;
    }

    public ApplicationModelBuilder addReloadableWorkspaceModules(Collection<ArtifactKey> key) {
        this.reloadableWorkspaceModules.addAll(key);
        return this;
    }

    public ApplicationModelBuilder addLesserPriorityArtifacts(List<ArtifactKey> deps) {
        this.lesserPriorityArtifacts.addAll(deps);
        return this;
    }

    public WorkspaceModule.Mutable getOrCreateProjectModule(WorkspaceModuleId id, File moduleDir, File buildDir) {
        return this.projectModules.computeIfAbsent(id, k -> WorkspaceModule.builder().setModuleId(id).setModuleDir(moduleDir.toPath()).setBuildDir(buildDir.toPath()));
    }

    public void handleExtensionProperties(Properties props, ArtifactKey extensionKey) {
        JvmOptionsBuilder jvmOptionsBuilder = null;
        Set<String> lockJvmOptions = Set.of();
        block15: for (Map.Entry<Object, Object> prop : props.entrySet()) {
            if (prop.getValue() == null) continue;
            String name = prop.getKey().toString();
            String value = prop.getValue().toString().trim();
            if (JvmOptionsBuilder.isExtensionDevModeJvmOptionProperty(name)) {
                log.debugf("Extension %s configures JVM option %s=%s in dev mode", (Object)extensionKey, (Object)name, (Object)value);
                if (jvmOptionsBuilder == null) {
                    jvmOptionsBuilder = JvmOptions.builder();
                }
                jvmOptionsBuilder.addFromQuarkusExtensionProperty(name, value);
                continue;
            }
            if (value.isBlank()) continue;
            switch (name) {
                case "parent-first-artifacts": {
                    this.addParentFirstArtifacts(value);
                    continue block15;
                }
                case "runner-parent-first-artifacts": {
                    this.addRunnerParentFirstArtifacts(value);
                    continue block15;
                }
                case "excluded-artifacts": {
                    this.addExcludedArtifacts(extensionKey, value);
                    continue block15;
                }
                case "lesser-priority-artifacts": {
                    this.addLesserPriorityArtifacts(extensionKey, value);
                    continue block15;
                }
                case "dev-mode.lock.xx-jvm-options": 
                case "dev-mode.lock.jvm-options": {
                    lockJvmOptions = ApplicationModelBuilder.splitByCommaAndAddAll(value, lockJvmOptions);
                    continue block15;
                }
            }
            if (!name.startsWith(REMOVED_RESOURCES_DOT)) continue;
            this.addRemovedResources(extensionKey, name, value);
        }
        if (jvmOptionsBuilder != null || lockJvmOptions != null) {
            this.extensionDevConfig.add(new ExtensionDevModeConfig(extensionKey, jvmOptionsBuilder == null ? JvmOptions.builder().build() : jvmOptionsBuilder.build(), lockJvmOptions));
        }
    }

    private static Set<String> splitByCommaAndAddAll(String commaList, Set<String> set) {
        String[] arr = commaList.split(COMMA);
        if (arr.length == 0) {
            return set;
        }
        if (set.isEmpty()) {
            return Set.of(arr);
        }
        set = new HashSet<String>(set);
        for (int i = 0; i < arr.length; ++i) {
            set.add(arr[i]);
        }
        return set;
    }

    private void addRemovedResources(ArtifactKey extension, String name, String value) {
        Set<String> resources;
        ArtifactKey key;
        String keyStr = name.substring(REMOVED_RESOURCES_DOT.length());
        if (keyStr.isBlank()) {
            return;
        }
        try {
            key = ArtifactKey.fromString(keyStr);
        }
        catch (IllegalArgumentException e) {
            log.warnf("Failed to parse artifact key %s in %s from descriptor of extension %s", (Object)keyStr, (Object)name, (Object)extension);
            return;
        }
        Collection existingResources = this.excludedResources.get(key);
        if (existingResources == null || existingResources.isEmpty()) {
            resources = Set.of(value.split(COMMA));
        } else {
            String[] split = value.split(COMMA);
            resources = new HashSet<String>(existingResources.size() + split.length);
            resources.addAll(existingResources);
            resources.addAll(List.of(split));
        }
        log.debugf("Extension %s is excluding resources %s from artifact %s", (Object)extension, resources, (Object)key);
        this.excludedResources.put(key, resources);
    }

    private void addLesserPriorityArtifacts(ArtifactKey extension, String value) {
        for (String artifact : value.split(COMMA)) {
            this.lesserPriorityArtifacts.add(ApplicationModelBuilder.toArtifactKey(artifact));
            log.debugf("Extension %s is making %s a lesser priority artifact", (Object)extension, (Object)artifact);
        }
    }

    private void addExcludedArtifacts(ArtifactKey extension, String value) {
        for (String artifact : value.split(COMMA)) {
            this.excludedArtifacts.add(ArtifactCoordsPattern.of(artifact));
            log.debugf("Extension %s is excluding %s", (Object)extension, (Object)artifact);
        }
    }

    private void addRunnerParentFirstArtifacts(String value) {
        for (String artifact : value.split(COMMA)) {
            this.runnerParentFirstArtifacts.add(ApplicationModelBuilder.toArtifactKey(artifact));
        }
    }

    private void addParentFirstArtifacts(String value) {
        for (String artifact : value.split(COMMA)) {
            this.parentFirstArtifacts.add(ApplicationModelBuilder.toArtifactKey(artifact));
        }
    }

    private static GACT toArtifactKey(String artifact) {
        return new GACT(artifact.split(":"));
    }

    List<ResolvedDependency> buildDependencies() {
        ResolvedDependencyBuilder d;
        for (ArtifactKey key : this.parentFirstArtifacts) {
            d = this.dependencies.get(key);
            if (d == null) continue;
            d.setFlags(256);
        }
        for (ArtifactKey key : this.runnerParentFirstArtifacts) {
            d = this.dependencies.get(key);
            if (d == null) continue;
            d.setFlags(512);
        }
        for (ArtifactKey key : this.lesserPriorityArtifacts) {
            d = this.dependencies.get(key);
            if (d == null) continue;
            d.setFlags(1024);
        }
        ArrayList<ResolvedDependency> result = new ArrayList<ResolvedDependency>(this.dependencies.size());
        ArtifactCoordsPattern[] excludePatterns = this.excludedArtifacts.toArray(new ArtifactCoordsPattern[0]);
        for (ResolvedDependencyBuilder db : this.dependencies.values()) {
            if (ApplicationModelBuilder.matches(db.getArtifactCoords(), excludePatterns)) continue;
            db.setDependencies(ApplicationModelBuilder.ensureNoMatches(db.getDependencies(), excludePatterns));
            result.add(db.build());
        }
        return result;
    }

    private static boolean matches(ArtifactCoords coords, ArtifactCoordsPattern[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            if (!patterns[i].matches(coords)) continue;
            return true;
        }
        return false;
    }

    private static Collection<ArtifactCoords> ensureNoMatches(Collection<ArtifactCoords> artifacts, ArtifactCoordsPattern[] patterns) {
        if (artifacts.isEmpty() || patterns.length == 0) {
            return artifacts;
        }
        for (ArtifactCoords dep : artifacts) {
            if (!ApplicationModelBuilder.matches(dep, patterns)) continue;
            return ApplicationModelBuilder.excludeMatches(artifacts, patterns);
        }
        return artifacts;
    }

    private static Collection<ArtifactCoords> excludeMatches(Collection<ArtifactCoords> artifacts, ArtifactCoordsPattern[] patterns) {
        ArrayList<ArtifactCoords> result = new ArrayList<ArtifactCoords>(artifacts.size() - 1);
        for (ArtifactCoords artifact : artifacts) {
            if (ApplicationModelBuilder.matches(artifact, patterns)) continue;
            result.add(artifact);
        }
        return result;
    }

    public DefaultApplicationModel build() {
        return new DefaultApplicationModel(this);
    }
}

