/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.keycloak.common.VerificationException;
import org.keycloak.sdjwt.ClaimVerifier;
import org.keycloak.sdjwt.JwsToken;

public class IssuerSignedJwtVerificationOpts
extends ClaimVerifier {
    public IssuerSignedJwtVerificationOpts(List<ClaimVerifier.Predicate<ObjectNode>> headerVerifiers, List<ClaimVerifier.Predicate<ObjectNode>> contentVerifiers) {
        super(headerVerifiers, contentVerifiers);
    }

    public void verify(JwsToken tokenToVerify) throws VerificationException {
        super.verifyClaims(tokenToVerify.getJwsHeaderAsNode(), tokenToVerify.getPayload());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ClaimVerifier.Builder {
        public Builder() {
        }

        public Builder(Integer clockSkew) {
            super(clockSkew);
        }

        @Override
        public Builder withIatCheck(Integer allowedMaxAge) {
            return (Builder)super.withIatCheck(allowedMaxAge);
        }

        @Override
        public Builder withIatCheck(boolean isCheckOptional) {
            return (Builder)super.withIatCheck(isCheckOptional);
        }

        @Override
        public Builder withIatCheck(Integer allowedMaxAge, boolean isCheckOptional) {
            return (Builder)super.withIatCheck(allowedMaxAge, isCheckOptional);
        }

        @Override
        public Builder withNbfCheck() {
            return (Builder)super.withNbfCheck();
        }

        @Override
        public Builder withNbfCheck(boolean isCheckOptional) {
            return (Builder)super.withNbfCheck(isCheckOptional);
        }

        @Override
        public Builder withExpCheck() {
            return (Builder)super.withExpCheck();
        }

        @Override
        public Builder withExpCheck(boolean isCheckOptional) {
            return (Builder)super.withExpCheck(isCheckOptional);
        }

        @Override
        public Builder withClockSkew(int clockSkew) {
            return (Builder)super.withClockSkew(clockSkew);
        }

        @Override
        public Builder withContentVerifiers(List<ClaimVerifier.Predicate<ObjectNode>> contentVerifiers) {
            return (Builder)super.withContentVerifiers(contentVerifiers);
        }

        @Override
        public Builder addContentVerifiers(List<ClaimVerifier.Predicate<ObjectNode>> contentVerifiers) {
            return (Builder)super.addContentVerifiers(contentVerifiers);
        }

        @Override
        public Builder withAudCheck(String expectedAud) {
            return (Builder)super.withAudCheck(expectedAud);
        }

        @Override
        public Builder withClaimCheck(String claimName, String expectedValue) {
            return (Builder)super.withClaimCheck(claimName, expectedValue);
        }

        @Override
        public Builder withClaimCheck(String claimName, String expectedValue, boolean isOptionalCheck) {
            return (Builder)super.withClaimCheck(claimName, expectedValue, isOptionalCheck);
        }

        @Override
        public IssuerSignedJwtVerificationOpts build() {
            return new IssuerSignedJwtVerificationOpts(this.headerVerifiers, this.contentVerifiers);
        }
    }
}

