/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.hibernate.orm.runtime.BuildTimeSettings;
import io.quarkus.hibernate.orm.runtime.IntegrationSettings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RuntimeSettings {
    private final Map<String, Object> settings;

    private RuntimeSettings(Map<String, Object> settings) {
        this.settings = Collections.unmodifiableMap(new HashMap<String, Object>(settings));
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public Object get(String key) {
        return this.settings.get(key);
    }

    public boolean getBoolean(String key) {
        Object propertyValue = this.settings.get(key);
        return propertyValue != null && Boolean.parseBoolean(propertyValue.toString());
    }

    public boolean isConfigured(String key) {
        return this.settings.containsKey(key);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {" + this.settings.toString() + "}";
    }

    public static class Builder {
        private final Map<String, Object> settings;

        public Builder(BuildTimeSettings buildTimeSettings, IntegrationSettings integrationSettings) {
            this.settings = new HashMap<String, Object>(buildTimeSettings.getQuarkusConfigSettings());
            this.settings.putAll(integrationSettings.getSettings());
        }

        public void put(String key, Object value) {
            this.settings.put(key, value);
        }

        public Object get(String key) {
            return this.settings.get(key);
        }

        public boolean isConfigured(String key) {
            return this.settings.containsKey(key);
        }

        public RuntimeSettings build() {
            return new RuntimeSettings(this.settings);
        }
    }
}

