/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public final class QualifierConfigurator<C extends Consumer<AnnotationInstance>> {
    private final C qualifierConsumer;
    private final List<AnnotationValue> values;
    private DotName annotationName;

    QualifierConfigurator(C qualifierConsumer) {
        this.qualifierConsumer = qualifierConsumer;
        this.values = new ArrayList<AnnotationValue>();
    }

    public QualifierConfigurator<C> annotation(Class<? extends Annotation> annotationClass) {
        this.annotationName = DotName.createSimple((String)annotationClass.getName());
        return this;
    }

    public QualifierConfigurator<C> annotation(DotName annotationName) {
        this.annotationName = annotationName;
        return this;
    }

    public QualifierConfigurator<C> addValue(String name, Object value) {
        this.values.add(QualifierConfigurator.createAnnotationValue(name, value));
        return this;
    }

    public C done() {
        this.qualifierConsumer.accept((AnnotationInstance)AnnotationInstance.create((DotName)this.annotationName, null, this.values));
        return this.qualifierConsumer;
    }

    static AnnotationValue createAnnotationValue(String name, Object val) {
        if (val instanceof String) {
            return AnnotationValue.createStringValue((String)name, (String)val.toString());
        }
        if (val instanceof Integer) {
            return AnnotationValue.createIntegerValue((String)name, (int)((Integer)val));
        }
        if (val instanceof Long) {
            return AnnotationValue.createLongValue((String)name, (long)((Long)val));
        }
        if (val instanceof Byte) {
            return AnnotationValue.createByteValue((String)name, (byte)((Byte)val));
        }
        if (val instanceof Float) {
            return AnnotationValue.createFloatValue((String)name, (float)((Float)val).floatValue());
        }
        if (val instanceof Double) {
            return AnnotationValue.createDoubleValue((String)name, (double)((Double)val));
        }
        if (val instanceof Short) {
            return AnnotationValue.createShortValue((String)name, (short)((Short)val));
        }
        if (val instanceof Boolean) {
            return AnnotationValue.createBooleanValue((String)name, (boolean)((Boolean)val));
        }
        if (val instanceof Character) {
            return AnnotationValue.createCharacterValue((String)name, (char)((Character)val).charValue());
        }
        if (val instanceof Enum) {
            return AnnotationValue.createEnumValue((String)name, (DotName)DotName.createSimple((String)val.getClass().getName()), (String)val.toString());
        }
        if (val instanceof Class) {
            return AnnotationValue.createClassValue((String)name, (Type)Type.create((DotName)DotName.createSimple((String)((Class)val).getName()), (Type.Kind)Type.Kind.CLASS));
        }
        if (val instanceof List) {
            List listOfVals = (List)val;
            AnnotationValue[] values = new AnnotationValue[listOfVals.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = QualifierConfigurator.createAnnotationValue(name, listOfVals.get(i));
            }
            return AnnotationValue.createArrayValue((String)name, (AnnotationValue[])values);
        }
        if (val.getClass().isArray()) {
            AnnotationValue[] values = new AnnotationValue[Array.getLength(val)];
            for (int i = 0; i < values.length; ++i) {
                values[i] = QualifierConfigurator.createAnnotationValue(name, Array.get(val, i));
            }
            return AnnotationValue.createArrayValue((String)name, (AnnotationValue[])values);
        }
        throw new IllegalArgumentException("Unsupported value type for [" + name + "]: " + String.valueOf(val));
    }
}

