/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.jdbc.spi;

import java.util.Locale;
import java.util.Objects;
import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.internal.util.StringHelper;

public enum PhysicalConnectionHandlingMode {
    IMMEDIATE_ACQUISITION_AND_HOLD(ConnectionAcquisitionMode.IMMEDIATELY, ConnectionReleaseMode.ON_CLOSE),
    DELAYED_ACQUISITION_AND_HOLD(ConnectionAcquisitionMode.AS_NEEDED, ConnectionReleaseMode.ON_CLOSE),
    DELAYED_ACQUISITION_AND_RELEASE_AFTER_STATEMENT(ConnectionAcquisitionMode.AS_NEEDED, ConnectionReleaseMode.AFTER_STATEMENT),
    DELAYED_ACQUISITION_AND_RELEASE_BEFORE_TRANSACTION_COMPLETION(ConnectionAcquisitionMode.AS_NEEDED, ConnectionReleaseMode.BEFORE_TRANSACTION_COMPLETION),
    DELAYED_ACQUISITION_AND_RELEASE_AFTER_TRANSACTION(ConnectionAcquisitionMode.AS_NEEDED, ConnectionReleaseMode.AFTER_TRANSACTION);

    private final ConnectionAcquisitionMode acquisitionMode;
    private final ConnectionReleaseMode releaseMode;

    private PhysicalConnectionHandlingMode(ConnectionAcquisitionMode acquisitionMode, ConnectionReleaseMode releaseMode) {
        this.acquisitionMode = acquisitionMode;
        this.releaseMode = releaseMode;
    }

    public ConnectionAcquisitionMode getAcquisitionMode() {
        return this.acquisitionMode;
    }

    public ConnectionReleaseMode getReleaseMode() {
        return this.releaseMode;
    }

    public static PhysicalConnectionHandlingMode interpret(Object setting) {
        if (setting instanceof PhysicalConnectionHandlingMode) {
            PhysicalConnectionHandlingMode mode = (PhysicalConnectionHandlingMode)((Object)setting);
            return mode;
        }
        if (setting instanceof String) {
            String string = (String)setting;
            return StringHelper.isBlank(string) ? null : PhysicalConnectionHandlingMode.valueOf(string.trim().toUpperCase(Locale.ROOT));
        }
        return null;
    }

    public static PhysicalConnectionHandlingMode interpret(ConnectionAcquisitionMode acquisitionMode, ConnectionReleaseMode releaseMode) {
        Objects.requireNonNull(acquisitionMode, "ConnectionAcquisitionMode must be specified");
        Objects.requireNonNull(acquisitionMode, "ConnectionReleaseMode must be specified");
        return switch (acquisitionMode) {
            default -> throw new IncompatibleClassChangeError();
            case ConnectionAcquisitionMode.AS_NEEDED -> {
                switch (releaseMode) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ON_CLOSE: {
                        yield DELAYED_ACQUISITION_AND_HOLD;
                    }
                    case AFTER_STATEMENT: {
                        yield DELAYED_ACQUISITION_AND_RELEASE_AFTER_STATEMENT;
                    }
                    case BEFORE_TRANSACTION_COMPLETION: {
                        yield DELAYED_ACQUISITION_AND_RELEASE_BEFORE_TRANSACTION_COMPLETION;
                    }
                    case AFTER_TRANSACTION: 
                }
                yield DELAYED_ACQUISITION_AND_RELEASE_AFTER_TRANSACTION;
            }
            case ConnectionAcquisitionMode.IMMEDIATELY -> {
                switch (releaseMode) {
                    case ON_CLOSE: {
                        yield IMMEDIATE_ACQUISITION_AND_HOLD;
                    }
                }
                throw new IllegalArgumentException("Only ConnectionReleaseMode.ON_CLOSE can be used in combination with ConnectionAcquisitionMode.IMMEDIATELY; but ConnectionReleaseMode." + releaseMode.name() + " was specified.");
            }
        };
    }
}

