/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.range;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.Locale;
import org.hibernate.query.range.Range;

record Pattern(String pattern, boolean caseSensitive) implements Range<String>
{
    private static final char ESCAPE = '\\';
    private static final char WILDCARD_CHAR = '_';
    private static final char WILDCARD_STRING = '%';

    Pattern(String pattern, boolean caseSensitive, char charWildcard, char stringWildcard) {
        this(Pattern.translate(pattern, charWildcard, stringWildcard), caseSensitive);
    }

    @Override
    public Predicate toPredicate(Path<? extends String> path, CriteriaBuilder builder) {
        Path<? extends String> stringPath = path;
        return this.caseSensitive ? builder.like(stringPath, this.pattern, '\\') : builder.like(builder.lower(stringPath), this.pattern.toLowerCase(Locale.ROOT), '\\');
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    private static String translate(String pattern, char charWildcard, char stringWildcard) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == charWildcard) {
                result.append('_');
                continue;
            }
            if (ch == stringWildcard) {
                result.append('%');
                continue;
            }
            if (ch == '%' || ch == '_' || ch == '\\') {
                result.append('\\');
            }
            result.append(ch);
        }
        return result.toString();
    }
}

