/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import oracle.jdbc.OracleType;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonGenerator;
import org.hibernate.dialect.OracleOsonJacksonHelper;
import org.hibernate.dialect.OracleOsonJdbcType;
import org.hibernate.dialect.type.OracleJsonArrayJdbcType;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JsonHelper;
import org.hibernate.type.descriptor.jdbc.spi.JsonGeneratingVisitor;
import org.hibernate.type.format.OsonDocumentReader;
import org.hibernate.type.format.OsonDocumentWriter;

public class OracleOsonArrayJdbcType
extends OracleJsonArrayJdbcType {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(OracleOsonArrayJdbcType.class);

    public OracleOsonArrayJdbcType(JdbcType elementJdbcType) {
        super(elementJdbcType);
    }

    @Override
    public String toString() {
        return "OracleOsonArrayJdbcType";
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            private <T> byte[] toOsonStream(T value, JavaType<T> javaType, WrapperOptions options) throws Exception {
                ByteArrayOutputStream out;
                block13: {
                    Object[] domainObjects = javaType.unwrap(value, Object[].class, options);
                    out = new ByteArrayOutputStream();
                    try (OracleJsonGenerator generator = OracleOsonJdbcType.OSON_JSON_FACTORY.createJsonBinaryGenerator((OutputStream)out);){
                        JavaType elementJavaType = ((BasicPluralJavaType)((Object)javaType)).getElementJavaType();
                        if (elementJavaType instanceof UnknownBasicJavaType) {
                            try (Closeable osonGen = OracleOsonJacksonHelper.createWriteTarget(out);){
                                options.getJsonFormatMapper().writeToTarget(value, javaType, osonGen, options);
                                break block13;
                            }
                        }
                        OsonDocumentWriter writer = new OsonDocumentWriter(generator);
                        JsonGeneratingVisitor.INSTANCE.visitArray(elementJavaType, OracleOsonArrayJdbcType.this.getElementJdbcType(), domainObjects, options, writer);
                    }
                }
                return out.toByteArray();
            }

            private boolean useUtf8(WrapperOptions options) {
                JavaType elementJavaType = ((BasicPluralJavaType)((Object)this.getJavaType())).getElementJavaType();
                return elementJavaType instanceof UnknownBasicJavaType && !options.getJsonFormatMapper().supportsTargetType(OracleOsonJacksonHelper.WRITER_CLASS);
            }

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                try {
                    if (this.useUtf8(options)) {
                        String json = OracleOsonArrayJdbcType.this.toString(value, this.getJavaType(), options);
                        st.setBytes(index, json.getBytes(StandardCharsets.UTF_8));
                    } else {
                        st.setObject(index, (Object)this.toOsonStream(value, this.getJavaType(), options), (SQLType)OracleType.JSON);
                    }
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                try {
                    if (this.useUtf8(options)) {
                        String json = OracleOsonArrayJdbcType.this.toString(value, this.getJavaType(), options);
                        st.setBytes(name, json.getBytes(StandardCharsets.UTF_8));
                    } else {
                        st.setObject(name, (Object)this.toOsonStream(value, this.getJavaType(), options), (SQLType)OracleType.JSON);
                    }
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            private X fromOson(InputStream osonBytes, WrapperOptions options) throws Exception {
                if (((BasicPluralJavaType)((Object)this.getJavaType())).getElementJavaType() instanceof UnknownBasicJavaType) {
                    try (Closeable oParser = OracleOsonJacksonHelper.createReadSource(osonBytes);){
                        Object j = options.getJsonFormatMapper().readFromSource(this.getJavaType(), oParser, options);
                        return j;
                    }
                }
                return JsonHelper.deserializeArray(javaType, OracleOsonArrayJdbcType.this.getElementJdbcType(), new OsonDocumentReader(OracleOsonJdbcType.OSON_JSON_FACTORY.createJsonBinaryParser(osonBytes)), options);
            }

            private X doExtraction(OracleJsonDatum datum, WrapperOptions options) throws SQLException {
                if (datum == null) {
                    return null;
                }
                InputStream osonBytes = datum.getStream();
                try {
                    return this.fromOson(osonBytes, options);
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }

            private boolean useUtf8(WrapperOptions options) {
                JavaType elementJavaType = ((BasicPluralJavaType)((Object)this.getJavaType())).getElementJavaType();
                return elementJavaType instanceof UnknownBasicJavaType && !options.getJsonFormatMapper().supportsTargetType(OracleOsonJacksonHelper.READER_CLASS);
            }

            private X fromString(byte[] json, WrapperOptions options) throws SQLException {
                if (json == null) {
                    return null;
                }
                return OracleOsonArrayJdbcType.this.fromString(new String(json, StandardCharsets.UTF_8), this.getJavaType(), options);
            }

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                try {
                    if (this.useUtf8(options)) {
                        return this.fromString(rs.getBytes(paramIndex), options);
                    }
                    OracleJsonDatum ojd = rs.getObject(paramIndex, OracleJsonDatum.class);
                    return this.doExtraction(ojd, options);
                }
                catch (SQLException exc) {
                    if (exc.getErrorCode() == 17004) {
                        LOG.invalidJSONColumnType(OracleType.CLOB.getName(), OracleType.JSON.getName());
                        return this.fromString(rs.getBytes(paramIndex), options);
                    }
                    throw exc;
                }
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                try {
                    if (this.useUtf8(options)) {
                        return this.fromString(statement.getBytes(index), options);
                    }
                    OracleJsonDatum ojd = statement.getObject(index, OracleJsonDatum.class);
                    return this.doExtraction(ojd, options);
                }
                catch (SQLException exc) {
                    if (exc.getErrorCode() == 17004) {
                        LOG.invalidJSONColumnType(OracleType.CLOB.getName(), OracleType.JSON.getName());
                        return this.fromString(statement.getBytes(index), options);
                    }
                    throw exc;
                }
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                try {
                    if (this.useUtf8(options)) {
                        return this.fromString(statement.getBytes(name), options);
                    }
                    OracleJsonDatum ojd = statement.getObject(name, OracleJsonDatum.class);
                    return this.doExtraction(ojd, options);
                }
                catch (SQLException exc) {
                    if (exc.getErrorCode() == 17004) {
                        LOG.invalidJSONColumnType(OracleType.CLOB.getName(), OracleType.JSON.getName());
                        return this.fromString(statement.getBytes(name), options);
                    }
                    throw exc;
                }
            }
        };
    }
}

