/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.HashingStrategy;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.HttpUtils;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;

public final class QuarkusHttpHeaders
extends io.netty.handler.codec.http.HttpHeaders
implements MultiMap {
    private Map<Class<?>, Object> contextObjects;
    private final MapEntry[] entries = new MapEntry[16];
    private final MapEntry head;
    private static final int COLON_AND_SPACE_SHORT = 14880;
    static final int CRLF_SHORT = 3338;

    public MultiMap setAll(MultiMap headers) {
        return this.set0((Iterable<Map.Entry<String, String>>)headers);
    }

    public MultiMap setAll(Map<String, String> headers) {
        return this.set0(headers.entrySet());
    }

    public int size() {
        return this.names().size();
    }

    public QuarkusHttpHeaders() {
        this.head.before = this.head.after = (this.head = new MapEntry());
    }

    public QuarkusHttpHeaders add(CharSequence name, CharSequence value) {
        Objects.requireNonNull(value);
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        this.add0(h, i, name, value);
        return this;
    }

    public QuarkusHttpHeaders add(CharSequence name, Object value) {
        return this.add(name, (CharSequence)value);
    }

    public io.netty.handler.codec.http.HttpHeaders add(String name, Object value) {
        return this.add((CharSequence)name, (CharSequence)value);
    }

    public QuarkusHttpHeaders add(String name, String strVal) {
        return this.add((CharSequence)name, (CharSequence)strVal);
    }

    public QuarkusHttpHeaders add(CharSequence name, Iterable values) {
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        for (Object vstr : values) {
            this.add0(h, i, name, (String)vstr);
        }
        return this;
    }

    public QuarkusHttpHeaders add(String name, Iterable values) {
        return this.add((CharSequence)name, values);
    }

    public MultiMap addAll(MultiMap headers) {
        return this.addAll(headers.entries());
    }

    public MultiMap addAll(Map<String, String> map) {
        return this.addAll(map.entrySet());
    }

    private MultiMap addAll(Iterable<Map.Entry<String, String>> headers) {
        for (Map.Entry<String, String> entry : headers) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public QuarkusHttpHeaders remove(CharSequence name) {
        Objects.requireNonNull(name, "name");
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        this.remove0(h, i, name);
        return this;
    }

    public QuarkusHttpHeaders remove(String name) {
        return this.remove((CharSequence)name);
    }

    public QuarkusHttpHeaders set(CharSequence name, CharSequence value) {
        return this.set0(name, value);
    }

    public QuarkusHttpHeaders set(String name, String value) {
        return this.set((CharSequence)name, (CharSequence)value);
    }

    public QuarkusHttpHeaders set(String name, Object value) {
        return this.set((CharSequence)name, (CharSequence)value);
    }

    public QuarkusHttpHeaders set(CharSequence name, Object value) {
        return this.set(name, (CharSequence)value);
    }

    public QuarkusHttpHeaders set(CharSequence name, Iterable values) {
        Objects.requireNonNull(values, "values");
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        this.remove0(h, i, name);
        for (Object v : values) {
            if (v == null) break;
            this.add0(h, i, name, (CharSequence)v);
        }
        return this;
    }

    public QuarkusHttpHeaders set(String name, Iterable values) {
        return this.set((CharSequence)name, values);
    }

    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCase) {
        HashingStrategy strategy;
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        MapEntry e = this.entries[i];
        HashingStrategy hashingStrategy = strategy = ignoreCase ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER;
        while (e != null) {
            CharSequence key = e.key;
            if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)key)) && strategy.equals((Object)value, (Object)e.getValue())) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public boolean contains(String name, String value, boolean ignoreCase) {
        return this.contains((CharSequence)name, (CharSequence)value, ignoreCase);
    }

    public boolean contains(CharSequence name) {
        return this.get0(name) != null;
    }

    public boolean contains(String name) {
        return this.contains((CharSequence)name);
    }

    public String get(CharSequence name) {
        Objects.requireNonNull(name, "name");
        CharSequence ret = this.get0(name);
        return ret != null ? ret.toString() : null;
    }

    public String get(String name) {
        return this.get((CharSequence)name);
    }

    public List<String> getAll(CharSequence name) {
        Objects.requireNonNull(name, "name");
        LinkedList<String> values = new LinkedList<String>();
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        MapEntry e = this.entries[i];
        while (e != null) {
            CharSequence key = e.key;
            if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)key))) {
                values.addFirst(e.getValue().toString());
            }
            e = e.next;
        }
        return values;
    }

    public List<String> getAll(String name) {
        return this.getAll((CharSequence)name);
    }

    public void forEach(Consumer<? super Map.Entry<String, String>> action) {
        MapEntry e = this.head.after;
        while (e != this.head) {
            action.accept(new AbstractMap.SimpleEntry<String, String>(e.key.toString(), e.value.toString()));
            e = e.after;
        }
    }

    public List<Map.Entry<String, String>> entries() {
        return super.entries();
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return new Iterator<Map.Entry<String, String>>(){
            MapEntry curr;
            {
                this.curr = QuarkusHttpHeaders.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.curr.after != QuarkusHttpHeaders.this.head;
            }

            @Override
            public Map.Entry<String, String> next() {
                final MapEntry next = this.curr.after;
                if (next == QuarkusHttpHeaders.this.head) {
                    throw new NoSuchElementException();
                }
                this.curr = next;
                return new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return next.key.toString();
                    }

                    @Override
                    public String getValue() {
                        return next.value.toString();
                    }

                    @Override
                    public String setValue(String value) {
                        return next.setValue(value).toString();
                    }

                    public String toString() {
                        return this.getKey() + ": " + this.getValue();
                    }
                };
            }
        };
    }

    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    public Set<String> names() {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        MapEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.getKey().toString());
            e = e.after;
        }
        return names;
    }

    public QuarkusHttpHeaders clear() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = null;
        }
        this.head.before = this.head.after = this.head;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            sb.append(entry).append('\n');
        }
        return sb.toString();
    }

    public Integer getInt(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    public int getInt(CharSequence name, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    public Short getShort(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    public short getShort(CharSequence name, short defaultValue) {
        throw new UnsupportedOperationException();
    }

    public Long getTimeMillis(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    public long getTimeMillis(CharSequence name, long defaultValue) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return new Iterator<Map.Entry<CharSequence, CharSequence>>(){
            MapEntry current;
            {
                this.current = QuarkusHttpHeaders.this.head.after;
            }

            @Override
            public boolean hasNext() {
                return this.current != QuarkusHttpHeaders.this.head;
            }

            @Override
            public Map.Entry<CharSequence, CharSequence> next() {
                MapEntry next = this.current;
                this.current = this.current.after;
                return next;
            }
        };
    }

    public io.netty.handler.codec.http.HttpHeaders addInt(CharSequence name, int value) {
        throw new UnsupportedOperationException();
    }

    public io.netty.handler.codec.http.HttpHeaders addShort(CharSequence name, short value) {
        throw new UnsupportedOperationException();
    }

    public io.netty.handler.codec.http.HttpHeaders setInt(CharSequence name, int value) {
        return this.set(name, (CharSequence)Integer.toString(value));
    }

    public io.netty.handler.codec.http.HttpHeaders setShort(CharSequence name, short value) {
        throw new UnsupportedOperationException();
    }

    public void encode(ByteBuf buf) {
        MapEntry current = this.head.after;
        while (current != this.head) {
            QuarkusHttpHeaders.encoderHeader(current.key, current.value, buf);
            current = current.after;
        }
    }

    static void encoderHeader(CharSequence name, CharSequence value, ByteBuf buf) {
        int nameLen = name.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        buf.ensureWritable(entryLen);
        int offset = buf.writerIndex();
        QuarkusHttpHeaders.writeAscii(buf, offset, name);
        ByteBufUtil.setShortBE((ByteBuf)buf, (int)(offset += nameLen), (int)14880);
        QuarkusHttpHeaders.writeAscii(buf, offset += 2, value);
        ByteBufUtil.setShortBE((ByteBuf)buf, (int)(offset += valueLen), (int)3338);
        buf.writerIndex(offset += 2);
    }

    private static void writeAscii(ByteBuf buf, int offset, CharSequence value) {
        if (value instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)((AsciiString)value), (int)0, (ByteBuf)buf, (int)offset, (int)value.length());
        } else {
            buf.setCharSequence(offset, value, CharsetUtil.US_ASCII);
        }
    }

    private void remove0(int h, int i, CharSequence name) {
        MapEntry next;
        MapEntry e;
        block4: {
            e = this.entries[i];
            if (e == null) {
                return;
            }
            while (true) {
                CharSequence key = e.key;
                if (e.hash != h || name != key && !AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)key)) break block4;
                e.remove();
                MapEntry next2 = e.next;
                if (next2 == null) break;
                this.entries[i] = next2;
                e = next2;
            }
            this.entries[i] = null;
            return;
        }
        while ((next = e.next) != null) {
            CharSequence key = next.key;
            if (next.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)key))) {
                e.next = next.next;
                next.remove();
                continue;
            }
            e = next;
        }
    }

    private void add0(int h, int i, CharSequence name, CharSequence value) {
        MapEntry newEntry;
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader((CharSequence)name, (CharSequence)value);
        }
        MapEntry e = this.entries[i];
        this.entries[i] = newEntry = new MapEntry(h, name, value);
        newEntry.next = e;
        newEntry.addBefore(this.head);
    }

    private QuarkusHttpHeaders set0(CharSequence name, CharSequence strVal) {
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        this.remove0(h, i, name);
        if (strVal != null) {
            this.add0(h, i, name, strVal);
        }
        return this;
    }

    private CharSequence get0(CharSequence name) {
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        MapEntry e = this.entries[i];
        CharSequence value = null;
        while (e != null) {
            CharSequence key = e.key;
            if (e.hash == h && (name == key || AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)key))) {
                value = e.getValue();
            }
            e = e.next;
        }
        return value;
    }

    private MultiMap set0(Iterable<Map.Entry<String, String>> map) {
        this.clear();
        for (Map.Entry<String, String> entry : map) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Map<Class<?>, Object> getContextObjects() {
        if (this.contextObjects == null) {
            return Collections.emptyMap();
        }
        return this.contextObjects;
    }

    public <T> QuarkusHttpHeaders setContextObject(Class<T> key, T type) {
        if (this.contextObjects == null) {
            this.contextObjects = new HashMap();
        }
        this.contextObjects.put(key, type);
        return this;
    }

    public <T> T getContextObject(Class<T> key) {
        return (T)this.getContextObjects().get(key);
    }

    private static final class MapEntry
    implements Map.Entry<CharSequence, CharSequence> {
        final int hash;
        final CharSequence key;
        CharSequence value;
        MapEntry next;
        MapEntry before;
        MapEntry after;

        MapEntry() {
            this.hash = -1;
            this.key = null;
            this.value = null;
        }

        MapEntry(int hash, CharSequence key, CharSequence value) {
            this.hash = hash;
            this.key = key;
            this.value = value;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        void addBefore(MapEntry e) {
            this.after = e;
            this.before = e.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence value) {
            Objects.requireNonNull(value, "value");
            if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
                HttpUtils.validateHeaderValue((CharSequence)value);
            }
            CharSequence oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }
    }
}

