/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorOffset;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorOffsets;
import org.apache.kafka.connect.runtime.rest.errors.BadRequestException;

public final class SinkUtils {
    public static final String KAFKA_TOPIC_KEY = "kafka_topic";
    public static final String KAFKA_PARTITION_KEY = "kafka_partition";
    public static final String KAFKA_OFFSET_KEY = "kafka_offset";

    private SinkUtils() {
    }

    public static String consumerGroupId(String connector) {
        return "connect-" + connector;
    }

    public static ConnectorOffsets consumerGroupOffsetsToConnectorOffsets(Map<TopicPartition, OffsetAndMetadata> consumerGroupOffsets) {
        ArrayList<ConnectorOffset> connectorOffsets = new ArrayList<ConnectorOffset>();
        for (Map.Entry<TopicPartition, OffsetAndMetadata> topicPartitionOffset : consumerGroupOffsets.entrySet()) {
            HashMap<String, Object> partition = new HashMap<String, Object>();
            partition.put(KAFKA_TOPIC_KEY, topicPartitionOffset.getKey().topic());
            partition.put(KAFKA_PARTITION_KEY, topicPartitionOffset.getKey().partition());
            connectorOffsets.add(new ConnectorOffset(partition, Map.of(KAFKA_OFFSET_KEY, topicPartitionOffset.getValue().offset())));
        }
        return new ConnectorOffsets(connectorOffsets);
    }

    public static Map<TopicPartition, Long> parseSinkConnectorOffsets(Map<Map<String, ?>, Map<String, ?>> partitionOffsets) {
        HashMap<TopicPartition, Long> parsedOffsetMap = new HashMap<TopicPartition, Long>();
        for (Map.Entry<Map<String, ?>, Map<String, ?>> partitionOffset : partitionOffsets.entrySet()) {
            long offset;
            int partition;
            Map<String, ?> partitionMap = partitionOffset.getKey();
            if (partitionMap == null) {
                throw new BadRequestException("The partition for a sink connector offset cannot be null or missing");
            }
            if (!partitionMap.containsKey(KAFKA_TOPIC_KEY) || !partitionMap.containsKey(KAFKA_PARTITION_KEY)) {
                throw new BadRequestException(String.format("The partition for a sink connector offset must contain the keys '%s' and '%s'", KAFKA_TOPIC_KEY, KAFKA_PARTITION_KEY));
            }
            if (partitionMap.get(KAFKA_TOPIC_KEY) == null) {
                throw new BadRequestException("Kafka topic names must be valid strings and may not be null");
            }
            if (partitionMap.get(KAFKA_PARTITION_KEY) == null) {
                throw new BadRequestException("Kafka partitions must be valid numbers and may not be null");
            }
            String topic = String.valueOf(partitionMap.get(KAFKA_TOPIC_KEY));
            try {
                partition = Integer.parseInt(String.valueOf(partitionMap.get(KAFKA_PARTITION_KEY)));
            }
            catch (Exception e) {
                throw new BadRequestException("Failed to parse the following Kafka partition value in the provided offsets: '" + String.valueOf(partitionMap.get(KAFKA_PARTITION_KEY)) + "'. Partition values for sink connectors need to be integers.", e);
            }
            TopicPartition tp = new TopicPartition(topic, partition);
            Map<String, ?> offsetMap = partitionOffset.getValue();
            if (offsetMap == null) {
                parsedOffsetMap.put(tp, null);
                continue;
            }
            if (!offsetMap.containsKey(KAFKA_OFFSET_KEY)) {
                throw new BadRequestException(String.format("The offset for a sink connector should either be null or contain the key '%s'", KAFKA_OFFSET_KEY));
            }
            try {
                offset = Long.parseLong(String.valueOf(offsetMap.get(KAFKA_OFFSET_KEY)));
            }
            catch (Exception e) {
                throw new BadRequestException("Failed to parse the following Kafka offset value in the provided offsets: '" + String.valueOf(offsetMap.get(KAFKA_OFFSET_KEY)) + "'. Offset values for sink connectors need to be integers.", e);
            }
            parsedOffsetMap.put(tp, offset);
        }
        return parsedOffsetMap;
    }
}

