/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

public class MouseState {
    public int x = -1000;
    public int y = -1000;
    int modifiers = 0;
    public long time = -1L;
    int modelIndex;
    public String name;
    public int keybuf;
    private static final int MIN_DELAY_MS = 20;

    MouseState(String name) {
        this.name = name;
    }

    void setModelIndex(int modelIndex) {
        this.modelIndex = modelIndex;
    }

    void set(long time, int x, int y, int modifiers) {
        this.time = time;
        this.x = x;
        this.y = y;
        this.modifiers = modifiers;
    }

    void setCurrent(MouseState current, int clickCount) {
        this.time = current.time;
        if (clickCount < 2) {
            this.x = current.x;
            this.y = current.y;
        }
        this.modifiers = current.modifiers;
    }

    public boolean inRange(int xyRange, int x, int y) {
        return Math.abs(this.x - x) <= xyRange && Math.abs(this.y - y) <= xyRange;
    }

    public boolean check(int xyRange, int x, int y, int modifiers, long time, long delayMax) {
        return this.modifiers == modifiers && (delayMax >= Integer.MAX_VALUE ? this.inRange(xyRange, x, y) : time - this.time < delayMax && time - this.time > 20L);
    }

    public boolean is(MouseState current) {
        return current.x == this.x && current.y == this.y && current.time == this.time;
    }
}

