/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution.run;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeFilters;
import com.intellij.build.BuildView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ViewManager;
import com.intellij.build.WeakFilterableSupplier;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.execution.CantRunException;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.EelTargetEnvironmentRequest;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.testDiscovery.JvmToggleAutoTestAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationViewManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.BuildToolConsoleProcessAdapter;
import org.jetbrains.idea.maven.buildtool.MavenBuildEventProcessor;
import org.jetbrains.idea.maven.execution.MavenRebuildAction;
import org.jetbrains.idea.maven.execution.MavenResumeAction;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.execution.run.MavenHandlerFilterSpyWrapper;
import org.jetbrains.idea.maven.execution.run.MavenRuntimeTargetResolver;
import org.jetbrains.idea.maven.execution.target.MavenCommandLineSetup;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTargetConfiguration;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTypeConstants;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionKt;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenTargetShCommandLineState
extends CommandLineState
implements TargetEnvironmentAwareRunProfileState {
    private final MavenRunConfiguration myConfiguration;
    @NotNull
    private final ExecutionEnvironment myEnvironment;
    @NotNull
    private TargetEnvironmentRequest myTargetEnvironmentRequest;
    @NotNull
    private TargetedCommandLineBuilder myCommandLineBuilder;

    public MavenTargetShCommandLineState(@NotNull ExecutionEnvironment environment, @NotNull MavenRunConfiguration configuration) {
        if (environment == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(1);
        }
        super(environment);
        this.myEnvironment = environment;
        this.myConfiguration = configuration;
    }

    public TargetEnvironmentRequest createCustomTargetEnvironmentRequest() {
        Project project = this.myConfiguration.getProject();
        EelDescriptor eelDescriptor = EelProviderUtil.getEelDescriptor((Project)project);
        if (eelDescriptor instanceof LocalEelDescriptor) {
            return null;
        }
        EelApi eel = EelProviderUtil.toEelApiBlocking((EelDescriptor)eelDescriptor);
        EelTargetEnvironmentRequest.Configuration configuration = new EelTargetEnvironmentRequest.Configuration(eel);
        MavenRuntimeTargetResolver targetResolver = new MavenRuntimeTargetResolver(project, eel);
        MavenRuntimeTargetConfiguration runtimeTarget = targetResolver.resolve(this.myConfiguration);
        configuration.addLanguageRuntime((LanguageRuntimeConfiguration)runtimeTarget);
        return new EelTargetEnvironmentRequest(configuration);
    }

    public ExecutionResult doRunExecute(@NotNull Executor executor, @NotNull ProgramRunner runner, ExternalSystemTaskId taskId, DefaultBuildDescriptor descriptor2, ProcessHandler processHandler, @NotNull Function<String, String> targetFileMapper) throws ExecutionException {
        BuildView buildView;
        if (executor == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(2);
        }
        if (runner == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(3);
        }
        if (targetFileMapper == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(4);
        }
        if ((buildView = this.createBuildView(executor, (BuildDescriptor)descriptor2, processHandler)) == null) {
            MavenLog.LOG.warn("buildView is null for " + this.myConfiguration.getName());
        }
        MavenBuildEventProcessor eventProcessor = new MavenBuildEventProcessor(this.myConfiguration, (BuildProgressListener)buildView, (BuildDescriptor)descriptor2, taskId, targetFileMapper, ctx -> new StartBuildEventImpl((BuildDescriptor)descriptor2, ""), this.useMaven4());
        processHandler.addProcessListener((ProcessListener)new BuildToolConsoleProcessAdapter(eventProcessor));
        buildView.attachToProcess((ProcessHandler)new MavenHandlerFilterSpyWrapper(processHandler, this.useMaven4(), false));
        AnAction[] actions = new AnAction[]{BuildTreeFilters.createFilteringActionsGroup((Supplier)new WeakFilterableSupplier((Object)buildView))};
        DefaultExecutionResult res = new DefaultExecutionResult((ExecutionConsole)buildView, processHandler, actions);
        ArrayList<JvmToggleAutoTestAction> restartActions = new ArrayList<JvmToggleAutoTestAction>();
        restartActions.add(new JvmToggleAutoTestAction());
        res.setRestartActions(restartActions.toArray(AnAction.EMPTY_ARRAY));
        return res;
    }

    private boolean useMaven4() {
        MavenDistributionsCache mavenCache = MavenDistributionsCache.getInstance(this.myConfiguration.getProject());
        MavenDistribution mavenDistribution = mavenCache.getMavenDistribution(this.myConfiguration.getRunnerParameters().getWorkingDirPath());
        return MavenDistributionKt.isMaven4(mavenDistribution);
    }

    @NotNull
    private Function<MavenParsingContext, StartBuildEvent> getStartBuildEventSupplier(@NotNull ProgramRunner runner, ProcessHandler processHandler, StartBuildEventImpl startBuildEvent, boolean withResumeAction) {
        if (runner == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(5);
        }
        Function<MavenParsingContext, StartBuildEvent> function = ctx -> withResumeAction ? startBuildEvent.withRestartActions(new AnAction[]{new MavenRebuildAction(this.myEnvironment), new MavenResumeAction(processHandler, runner, this.myEnvironment, (MavenParsingContext)ctx)}) : startBuildEvent.withRestartActions(new AnAction[]{new MavenRebuildAction(this.myEnvironment)});
        if (function == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(6);
        }
        return function;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        TargetedCommandLineBuilder targetedCommandLineBuilder;
        String targetWorkingDirectory;
        if (executor == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(7);
        }
        if (runner == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(8);
        }
        OSProcessHandler processHandler = this.startProcess();
        ExecutionEnvironment environment = this.myEnvironment;
        TargetEnvironment targetEnvironment = environment.getPreparedTargetEnvironment((RunProfileState)this, TargetProgressIndicator.EMPTY);
        Function<String, String> targetFileMapper = path -> path != null && SystemInfo.isWindows && path.charAt(0) == '/' ? path.substring(1) : path;
        LanguageRuntimeType.VolumeType mavenProjectFolderVolumeType = MavenRuntimeTypeConstants.getPROJECT_FOLDER_VOLUME().getType();
        Set uploadVolumes = this.myTargetEnvironmentRequest.getUploadVolumes();
        for (TargetEnvironment.UploadRoot uploadVolume : uploadVolumes) {
            String localPath = uploadVolume.getLocalRootPath().toString();
            TargetEnvironment.TargetPath targetRootPath = uploadVolume.getTargetRootPath();
            if (!(targetRootPath instanceof TargetEnvironment.TargetPath.Temporary) || !mavenProjectFolderVolumeType.getId().equals(((TargetEnvironment.TargetPath.Temporary)targetRootPath).getHint())) continue;
            String targetPath = (String)TargetEnvironmentFunctions.getTargetUploadPath((TargetEnvironment.UploadRoot)uploadVolume).apply(targetEnvironment);
            targetFileMapper = MavenTargetShCommandLineState.createTargetFileMapper(targetEnvironment, localPath, targetPath);
            break;
        }
        String workingDir = (targetWorkingDirectory = (targetedCommandLineBuilder = this.myCommandLineBuilder).build().getWorkingDirectory()) != null ? targetFileMapper.apply(targetWorkingDirectory) : this.myEnvironment.getProject().getBasePath();
        ExternalSystemTaskId taskId = ExternalSystemTaskId.create((ProjectSystemId)MavenUtil.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)this.myConfiguration.getProject());
        DefaultBuildDescriptor descriptor2 = new DefaultBuildDescriptor((Object)taskId, this.myConfiguration.getName(), workingDir, System.currentTimeMillis());
        ExecutionResult executionResult = this.doRunExecute(executor, runner, taskId, descriptor2, (ProcessHandler)processHandler, targetFileMapper);
        if (executionResult == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(9);
        }
        return executionResult;
    }

    public void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request, @NotNull TargetProgressIndicator targetProgressIndicator) throws ExecutionException {
        if (request == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(10);
        }
        if (targetProgressIndicator == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(11);
        }
        targetProgressIndicator.addSystemLine(ExecutionBundle.message((String)"progress.text.prepare.target.requirements", (Object[])new Object[0]));
        this.myTargetEnvironmentRequest = request;
        this.myCommandLineBuilder = this.createTargetedCommandLine(this.myTargetEnvironmentRequest);
    }

    @Nullable
    private BuildView createBuildView(@NotNull Executor executor, @NotNull BuildDescriptor descriptor2, @NotNull ProcessHandler processHandler) throws ExecutionException {
        ConsoleView console;
        if (executor == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(12);
        }
        if (descriptor2 == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(13);
        }
        if (processHandler == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(14);
        }
        if ((console = super.createConsole(executor)) == null) {
            return null;
        }
        Project project = this.myConfiguration.getProject();
        final ExternalSystemRunConfigurationViewManager viewManager = (ExternalSystemRunConfigurationViewManager)project.getService(ExternalSystemRunConfigurationViewManager.class);
        return new BuildView(project, (ExecutionConsole)console, descriptor2, "build.toolwindow.run.selection.state", (ViewManager)viewManager){

            public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
                if (buildId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.onEvent(buildId, event);
                viewManager.onEvent(buildId, event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "buildId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/execution/run/MavenTargetShCommandLineState$1";
                objectArray[2] = "onEvent";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request) throws ExecutionException {
        if (request == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(15);
        }
        if (request.getConfiguration() == null) {
            throw new CantRunException(RunnerBundle.message("cannot.find.target.environment.configuration", new Object[0]));
        }
        MavenRunConfiguration.MavenSettings settings = new MavenRunConfiguration.MavenSettings(this.myConfiguration.getProject());
        settings.setRunnerParameters(this.myConfiguration.getRunnerParameters());
        settings.setGeneralSettings(this.myConfiguration.getGeneralSettings());
        settings.setRunnerSettings(this.myConfiguration.getRunnerSettings());
        TargetedCommandLineBuilder targetedCommandLineBuilder = new MavenCommandLineSetup(this.myConfiguration.getProject(), this.myConfiguration.getName(), request).setupCommandLine(settings).getCommandLine();
        if (targetedCommandLineBuilder == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(16);
        }
        return targetedCommandLineBuilder;
    }

    public void handleCreatedTargetEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator targetProgressIndicator) {
        if (environment == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(17);
        }
        if (targetProgressIndicator == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(18);
        }
        TargetedCommandLineBuilder targetedCommandLineBuilder = this.myCommandLineBuilder;
        Objects.requireNonNull((MavenCommandLineSetup)targetedCommandLineBuilder.getUserData(MavenCommandLineSetup.getSetupKey())).provideEnvironment(environment, targetProgressIndicator);
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        ExecutionEnvironment environment = this.myEnvironment;
        TargetEnvironment remoteEnvironment = environment.getPreparedTargetEnvironment((RunProfileState)this, TargetProgressIndicator.EMPTY);
        TargetedCommandLine targetedCommandLine = this.myCommandLineBuilder.build();
        Process process2 = remoteEnvironment.createProcess(targetedCommandLine, (ProgressIndicator)new EmptyProgressIndicator());
        OSProcessHandler handler2 = this.createProcessHandler(remoteEnvironment, this.myCommandLineBuilder, targetedCommandLine, process2);
        ProcessTerminatedListener.attach((ProcessHandler)handler2);
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfiguration, (ProcessHandler)handler2, this.getRunnerSettings());
        OSProcessHandler oSProcessHandler = handler2;
        if (oSProcessHandler == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(19);
        }
        return oSProcessHandler;
    }

    @NotNull
    protected OSProcessHandler createProcessHandler(TargetEnvironment remoteEnvironment, TargetedCommandLineBuilder targetedCommandLineBuilder, TargetedCommandLine targetedCommandLine, Process process2) throws ExecutionException {
        return new KillableColoredProcessHandler.Silent(process2, targetedCommandLine.getCommandPresentation(remoteEnvironment), targetedCommandLine.getCharset(), targetedCommandLineBuilder.getFilesToDeleteOnTermination());
    }

    @NotNull
    private static Function<String, String> createTargetFileMapper(@NotNull TargetEnvironment targetEnvironment, @NotNull String projectRootlocalPath, @NotNull String projectRootTargetPath) {
        if (targetEnvironment == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(20);
        }
        if (projectRootlocalPath == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(21);
        }
        if (projectRootTargetPath == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(22);
        }
        Function<String, String> function = path -> {
            if (path == null) {
                return null;
            }
            boolean isWindows = targetEnvironment.getTargetPlatform().getPlatform() == Platform.WINDOWS;
            String string = path = isWindows && path.charAt(0) == '/' ? path.substring(1) : path;
            if (path.startsWith(projectRootTargetPath)) {
                return Paths.get(projectRootlocalPath, StringUtil.trimStart((String)path, (String)projectRootTargetPath)).toString();
            }
            if (path.startsWith("/private" + projectRootTargetPath)) {
                return Paths.get(projectRootlocalPath, StringUtil.trimStart((String)path, (String)("/private" + projectRootTargetPath))).toString();
            }
            return path;
        };
        if (function == null) {
            MavenTargetShCommandLineState.$$$reportNull$$$0(23);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 16, 19, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFileMapper";
                break;
            }
            case 6: 
            case 9: 
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/run/MavenTargetShCommandLineState";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProgressIndicator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironment";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootlocalPath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootTargetPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/run/MavenTargetShCommandLineState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartBuildEventSupplier";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetedCommandLine";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetFileMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doRunExecute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStartBuildEventSupplier";
                break;
            }
            case 6: 
            case 9: 
            case 16: 
            case 19: 
            case 23: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareTargetEnvironmentRequest";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createBuildView";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTargetedCommandLine";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleCreatedTargetEnvironment";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createTargetFileMapper";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 16, 19, 23 -> new IllegalStateException(string);
        };
    }
}

