/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.diagnostic.PluginException;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.openapi.util.text.Strings;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public abstract class FeatureUsagesCollector {
    @NonNls
    private static final String GROUP_ID_PATTERN = "([a-zA-Z]*\\.)*[a-zA-Z]*";
    @Nullable
    private String fileName = null;

    public FeatureUsagesCollector() {
        boolean isCollectorFileNameEnabled = Boolean.parseBoolean(System.getenv("FUS_COLLECTOR_FILENAME_ENABLED"));
        if (isCollectorFileNameEnabled) {
            this.calculateFileName();
        }
    }

    @TestOnly
    public void forceCalculateFileName() {
        this.calculateFileName();
    }

    public final boolean isValid() {
        return Pattern.compile(GROUP_ID_PATTERN).matcher(this.getGroupId()).matches();
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    private void calculateFileName() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        Optional<StackTraceElement> collectorStackTraceElement = Arrays.stream(stackTraceElements).filter(x -> Strings.areSameInstance((String)x.getClassName(), (String)this.getClass().getName())).findFirst();
        collectorStackTraceElement.ifPresent(element -> {
            this.fileName = element.getFileName();
        });
    }

    @Deprecated(forRemoval=true)
    @NonNls
    @NotNull
    public String getGroupId() {
        EventLogGroup group = this.getGroup();
        if (group == null) {
            throw PluginException.createByClass((String)("Please override either getGroupId() or getGroup() in " + this.getClass().getName()), null, this.getClass());
        }
        String string = group.getId();
        if (string == null) {
            FeatureUsagesCollector.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Deprecated(forRemoval=true)
    public int getVersion() {
        EventLogGroup group = this.getGroup();
        if (group != null) {
            return group.getVersion();
        }
        return 1;
    }

    public EventLogGroup getGroup() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector", "getGroupId"));
    }
}

