/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Serializable;
import java.util.Locale;
import org.apache.lucene.search.SortComparatorSource;

public class SortField
implements Serializable {
    public static final int SCORE = 0;
    public static final int DOC = 1;
    public static final int AUTO = 2;
    public static final int STRING = 3;
    public static final int INT = 4;
    public static final int FLOAT = 5;
    public static final int LONG = 6;
    public static final int DOUBLE = 7;
    public static final int SHORT = 8;
    public static final int CUSTOM = 9;
    public static final int BYTE = 10;
    public static final SortField FIELD_SCORE = new SortField(null, 0);
    public static final SortField FIELD_DOC = new SortField(null, 1);
    private String field;
    private int type = 2;
    private Locale locale;
    boolean reverse = false;
    private SortComparatorSource factory;

    public SortField(String field) {
        this.field = field.intern();
    }

    public SortField(String field, boolean reverse) {
        this.field = field.intern();
        this.reverse = reverse;
    }

    public SortField(String field, int type) {
        this.field = field != null ? field.intern() : field;
        this.type = type;
    }

    public SortField(String field, int type, boolean reverse) {
        this.field = field != null ? field.intern() : field;
        this.type = type;
        this.reverse = reverse;
    }

    public SortField(String field, Locale locale) {
        this.field = field.intern();
        this.type = 3;
        this.locale = locale;
    }

    public SortField(String field, Locale locale, boolean reverse) {
        this.field = field.intern();
        this.type = 3;
        this.locale = locale;
        this.reverse = reverse;
    }

    public SortField(String field, SortComparatorSource comparator) {
        this.field = field != null ? field.intern() : field;
        this.type = 9;
        this.factory = comparator;
    }

    public SortField(String field, SortComparatorSource comparator, boolean reverse) {
        this.field = field != null ? field.intern() : field;
        this.type = 9;
        this.reverse = reverse;
        this.factory = comparator;
    }

    public String getField() {
        return this.field;
    }

    public int getType() {
        return this.type;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public SortComparatorSource getFactory() {
        return this.factory;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        switch (this.type) {
            case 0: {
                buffer.append("<score>");
                break;
            }
            case 1: {
                buffer.append("<doc>");
                break;
            }
            case 9: {
                buffer.append("<custom:\"").append(this.field).append("\": ").append(this.factory).append('>');
                break;
            }
            default: {
                buffer.append('\"').append(this.field).append('\"');
            }
        }
        if (this.locale != null) {
            buffer.append('(').append(this.locale).append(')');
        }
        if (this.reverse) {
            buffer.append('!');
        }
        return buffer.toString();
    }
}

