/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.listeners.java;

public abstract class CoverageListener {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private Object myProjectData;

    protected static String sanitize(String className, String methodName) {
        return className + "," + CoverageListener.sanitize(methodName, className.length());
    }

    public static String sanitize(String name, int length) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch <= '\u0000' || ch >= '\u00ff') continue;
            if (Character.isJavaIdentifierPart(ch) || ch == ' ' || ch == '@' || ch == '-') {
                result.append(ch);
                continue;
            }
            result.append("_");
        }
        int methodNameLimit = 250 - length;
        if (result.length() >= methodNameLimit) {
            String hash = String.valueOf(result.toString().hashCode());
            return (methodNameLimit > hash.length() ? result.substring(0, methodNameLimit - hash.length()) : "") + hash;
        }
        return result.toString();
    }

    protected Object getData() {
        try {
            return Class.forName("com.intellij.rt.coverage.data.ProjectData").getMethod("getProjectData", EMPTY_CLASS_ARRAY).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

