/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator;

import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogBuildParser;
import com.intellij.internal.statistic.eventLog.validator.DictionaryStorage;
import com.intellij.internal.statistic.eventLog.validator.GroupValidators;
import com.intellij.internal.statistic.eventLog.validator.IEventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.IGroupValidators;
import com.intellij.internal.statistic.eventLog.validator.ValidationRuleStorage;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidationRulesFactory;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.UtilRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationSimpleRuleFactory;
import com.jetbrains.fus.reporting.MetadataStorage;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import com.jetbrains.fus.reporting.model.metadata.RecorderValidationData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0010\b\u0000\u0010\u0001*\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004BC\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\"\u001a\u00020\u0012H\u0016J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0$2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000bH\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(2\u0006\u0010%\u001a\u00020\u000bH\u0016J\b\u0010)\u001a\u00020\u0012H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0$H\u0016J\b\u0010+\u001a\u00020\u0012H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0006H\u0002J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000200H\u0016J\u0010\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\u0006H\u0016J\u0016\u00103\u001a\u0002052\u0006\u00106\u001a\u000207H\u0096@\u00a2\u0006\u0002\u00108R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/SimpleValidationRuleStorage;", "T", "", "Lcom/jetbrains/fus/reporting/MetadataStorage;", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationRuleStorage;", "initialMetadata", "Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;", "buildParser", "Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventLogBuildParser;", "excludedFields", "", "", "utilRulesProducer", "Lcom/intellij/internal/statistic/eventLog/validator/rules/utils/UtilRuleProducer;", "dictionaryStorage", "Lcom/intellij/internal/statistic/eventLog/validator/DictionaryStorage;", "(Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventLogBuildParser;Ljava/util/List;Lcom/intellij/internal/statistic/eventLog/validator/rules/utils/UtilRuleProducer;Lcom/intellij/internal/statistic/eventLog/validator/DictionaryStorage;)V", "clientDataValidators", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/RecorderDataValidationRule;", "getDictionaryStorage", "()Lcom/intellij/internal/statistic/eventLog/validator/DictionaryStorage;", "eventsValidators", "", "Lcom/intellij/internal/statistic/eventLog/validator/rules/beans/EventGroupRules;", "filterRules", "Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventGroupsFilterRules;", "idsValidators", "lock", "", "getLock", "()Ljava/lang/Object;", "systemDataValidators", "validationRuleFactory", "Lcom/intellij/internal/statistic/eventLog/validator/rules/utils/ValidationSimpleRuleFactory;", "getClientDataRulesRevisions", "getFieldsToAnonymize", "", "groupId", "eventId", "getGroupValidators", "Lcom/intellij/internal/statistic/eventLog/validator/IGroupValidators;", "getIdsRulesRevisions", "getSkipAnonymizationIds", "getSystemDataRulesRevisions", "internalUpdate", "", "descriptors", "isUnreachable", "", "reload", "", "update", "metadata", "Lkotlinx/coroutines/Job;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ap-validation"})
public class SimpleValidationRuleStorage<T extends Comparable<? super T>>
implements MetadataStorage<T>,
ValidationRuleStorage<T> {
    @NotNull
    private final EventLogBuildParser<T> buildParser;
    @NotNull
    private final List<String> excludedFields;
    @Nullable
    private final DictionaryStorage dictionaryStorage;
    @NotNull
    private final ValidationSimpleRuleFactory validationRuleFactory;
    @NotNull
    private final Object lock;
    @NotNull
    private final Map<String, EventGroupRules> eventsValidators;
    private EventGroupsFilterRules<T> filterRules;
    private RecorderDataValidationRule clientDataValidators;
    private RecorderDataValidationRule systemDataValidators;
    private RecorderDataValidationRule idsValidators;

    @JvmOverloads
    public SimpleValidationRuleStorage(@NotNull EventGroupRemoteDescriptors initialMetadata, @NotNull EventLogBuildParser<T> buildParser, @NotNull List<String> excludedFields, @NotNull UtilRuleProducer utilRulesProducer, @Nullable DictionaryStorage dictionaryStorage) {
        Intrinsics.checkNotNullParameter((Object)initialMetadata, (String)"initialMetadata");
        Intrinsics.checkNotNullParameter(buildParser, (String)"buildParser");
        Intrinsics.checkNotNullParameter(excludedFields, (String)"excludedFields");
        Intrinsics.checkNotNullParameter((Object)utilRulesProducer, (String)"utilRulesProducer");
        this.buildParser = buildParser;
        this.excludedFields = excludedFields;
        this.dictionaryStorage = dictionaryStorage;
        this.validationRuleFactory = new ValidationSimpleRuleFactory(utilRulesProducer);
        this.lock = new Object();
        this.eventsValidators = new HashMap();
        this.internalUpdate(initialMetadata);
    }

    public /* synthetic */ SimpleValidationRuleStorage(EventGroupRemoteDescriptors eventGroupRemoteDescriptors, EventLogBuildParser eventLogBuildParser, List list, UtilRuleProducer utilRuleProducer, DictionaryStorage dictionaryStorage, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            UtilRuleProducer utilRuleProducer2 = ValidationSimpleRuleFactory.REJECTING_UTIL_URL_PRODUCER;
            Intrinsics.checkNotNullExpressionValue((Object)utilRuleProducer2, (String)"REJECTING_UTIL_URL_PRODUCER");
            utilRuleProducer = utilRuleProducer2;
        }
        if ((n & 0x10) != 0) {
            dictionaryStorage = null;
        }
        this(eventGroupRemoteDescriptors, eventLogBuildParser, list, utilRuleProducer, dictionaryStorage);
    }

    @Override
    @Nullable
    public DictionaryStorage getDictionaryStorage() {
        return this.dictionaryStorage;
    }

    @NotNull
    protected final Object getLock() {
        return this.lock;
    }

    public void update(@NotNull EventGroupRemoteDescriptors metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.internalUpdate(metadata);
    }

    @Override
    @Nullable
    public Object update(@NotNull CoroutineScope scope, @NotNull Continuation<? super Job> $completion) {
        return SimpleValidationRuleStorage.update$suspendImpl(this, scope, $completion);
    }

    static /* synthetic */ <T extends Comparable<? super T>> Object update$suspendImpl(SimpleValidationRuleStorage<T> $this, CoroutineScope scope, Continuation<? super Job> $completion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean update() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void reload() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<String> getFieldsToAnonymize(@NotNull String groupId, @NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<String> getSkipAnonymizationIds() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IGroupValidators<T> getGroupValidators(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            IEventGroupRules iEventGroupRules = this.eventsValidators.get(groupId);
            EventGroupsFilterRules<T> eventGroupsFilterRules = this.filterRules;
            if (eventGroupsFilterRules == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"filterRules");
                eventGroupsFilterRules = null;
            }
            IGroupValidators iGroupValidators = new GroupValidators(iEventGroupRules, eventGroupsFilterRules);
            return iGroupValidators;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RecorderDataValidationRule getClientDataRulesRevisions() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            RecorderDataValidationRule recorderDataValidationRule = this.clientDataValidators;
            if (recorderDataValidationRule == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clientDataValidators");
                recorderDataValidationRule = null;
            }
            RecorderDataValidationRule recorderDataValidationRule2 = recorderDataValidationRule;
            return recorderDataValidationRule2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RecorderDataValidationRule getSystemDataRulesRevisions() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            RecorderDataValidationRule recorderDataValidationRule = this.systemDataValidators;
            if (recorderDataValidationRule == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"systemDataValidators");
                recorderDataValidationRule = null;
            }
            RecorderDataValidationRule recorderDataValidationRule2 = recorderDataValidationRule;
            return recorderDataValidationRule2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RecorderDataValidationRule getIdsRulesRevisions() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            RecorderDataValidationRule recorderDataValidationRule = this.idsValidators;
            if (recorderDataValidationRule == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"idsValidators");
                recorderDataValidationRule = null;
            }
            RecorderDataValidationRule recorderDataValidationRule2 = recorderDataValidationRule;
            return recorderDataValidationRule2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void internalUpdate(EventGroupRemoteDescriptors descriptors) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.eventsValidators.clear();
            this.eventsValidators.putAll(this.createValidators(descriptors, this.validationRuleFactory, this.excludedFields));
            EventGroupsFilterRules<T> eventGroupsFilterRules = EventGroupsFilterRules.create(descriptors, this.buildParser);
            Intrinsics.checkNotNullExpressionValue(eventGroupsFilterRules, (String)"create(descriptors, buildParser)");
            this.filterRules = eventGroupsFilterRules;
            this.clientDataValidators = RecorderDataValidationRulesFactory.INSTANCE.create(this.validationRuleFactory, (List<RecorderValidationData>)descriptors.client_data, descriptors.rules, this.getDictionaryStorage());
            this.systemDataValidators = RecorderDataValidationRulesFactory.INSTANCE.create(this.validationRuleFactory, (List<RecorderValidationData>)descriptors.system_data, descriptors.rules, this.getDictionaryStorage());
            this.idsValidators = RecorderDataValidationRulesFactory.INSTANCE.create(this.validationRuleFactory, (List<RecorderValidationData>)descriptors.ids, descriptors.rules, this.getDictionaryStorage());
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean isUnreachable() {
        return false;
    }

    @JvmOverloads
    public SimpleValidationRuleStorage(@NotNull EventGroupRemoteDescriptors initialMetadata, @NotNull EventLogBuildParser<T> buildParser, @NotNull List<String> excludedFields, @NotNull UtilRuleProducer utilRulesProducer) {
        Intrinsics.checkNotNullParameter((Object)initialMetadata, (String)"initialMetadata");
        Intrinsics.checkNotNullParameter(buildParser, (String)"buildParser");
        Intrinsics.checkNotNullParameter(excludedFields, (String)"excludedFields");
        Intrinsics.checkNotNullParameter((Object)utilRulesProducer, (String)"utilRulesProducer");
        this(initialMetadata, buildParser, excludedFields, utilRulesProducer, null, 16, null);
    }

    @JvmOverloads
    public SimpleValidationRuleStorage(@NotNull EventGroupRemoteDescriptors initialMetadata, @NotNull EventLogBuildParser<T> buildParser, @NotNull List<String> excludedFields) {
        Intrinsics.checkNotNullParameter((Object)initialMetadata, (String)"initialMetadata");
        Intrinsics.checkNotNullParameter(buildParser, (String)"buildParser");
        Intrinsics.checkNotNullParameter(excludedFields, (String)"excludedFields");
        this(initialMetadata, buildParser, excludedFields, null, null, 24, null);
    }

    @JvmOverloads
    public SimpleValidationRuleStorage(@NotNull EventGroupRemoteDescriptors initialMetadata, @NotNull EventLogBuildParser<T> buildParser) {
        Intrinsics.checkNotNullParameter((Object)initialMetadata, (String)"initialMetadata");
        Intrinsics.checkNotNullParameter(buildParser, (String)"buildParser");
        this(initialMetadata, buildParser, null, null, null, 28, null);
    }
}

