/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.AbstractTypeRemapper;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/ir/util/SimpleTypeRemapper;", "Lorg/jetbrains/kotlin/ir/util/AbstractTypeRemapper;", "symbolRemapper", "Lorg/jetbrains/kotlin/ir/util/SymbolRemapper;", "<init>", "(Lorg/jetbrains/kotlin/ir/util/SymbolRemapper;)V", "remapTypeOrNull", "Lorg/jetbrains/kotlin/ir/types/IrType;", "type", "ir.tree"})
public final class SimpleTypeRemapper
extends AbstractTypeRemapper {
    @NotNull
    private final SymbolRemapper symbolRemapper;

    public SimpleTypeRemapper(@NotNull SymbolRemapper symbolRemapper2) {
        Intrinsics.checkNotNullParameter((Object)symbolRemapper2, (String)"symbolRemapper");
        this.symbolRemapper = symbolRemapper2;
    }

    @Override
    @Nullable
    protected IrType remapTypeOrNull(@NotNull IrType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!(type instanceof IrSimpleType)) {
            return null;
        }
        IrClassifierSymbol symbol = this.symbolRemapper.getReferencedClassifier(((IrSimpleType)type).getClassifier());
        List<IrTypeArgument> arguments = this.remapTypeArguments(((IrSimpleType)type).getArguments());
        if (Intrinsics.areEqual((Object)symbol, (Object)((IrSimpleType)type).getClassifier()) && arguments == null) {
            return null;
        }
        SimpleTypeNullability simpleTypeNullability = ((IrSimpleType)type).getNullability();
        List<IrTypeArgument> list = arguments;
        if (list == null) {
            list = ((IrSimpleType)type).getArguments();
        }
        return IrSimpleTypeImplKt.IrSimpleTypeImpl$default(symbol, simpleTypeNullability, list, type.getAnnotations(), null, 16, null);
    }
}

