/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.tree.Formatter;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public record UnformattedChange(List<TextChange.Replacement> changes, List<TextRange> toFormat) {
    public static UnformattedChange from(TextChange.Replacement replacement) {
        return new UnformattedChange(List.of(replacement), List.of(replacement.range()));
    }

    public static List<UnformattedChange> join(List<UnformattedChange> changes1, List<UnformattedChange> changes2) {
        return StreamEx.of(changes1).flatMap(c1 -> changes2.stream().map(c2 -> c1.and((UnformattedChange)c2))).toList();
    }

    private UnformattedChange and(UnformattedChange c2) {
        return new UnformattedChange(StreamEx.of(this.changes).append(c2.changes).toList(), TextRange.mergeConditionally((Stream<TextRange>)StreamEx.of(this.toFormat).append(c2.toFormat), (r1, r2) -> r1.touches((TextRange)r2)));
    }

    public TextChange formatChange(Tree tree) {
        List<TextRange> toFormat = this.toFormat();
        return toFormat.isEmpty() ? TextChange.mergeReplacements(tree.text(), (StreamEx<TextChange.Replacement>)StreamEx.of(this.changes)) : new Formatter(tree).formatChanges(toFormat, TextChange.mergeReplacements((StreamEx<TextChange.Replacement>)StreamEx.of(this.changes), UnformattedChange::mergeDeletions));
    }

    @Nullable
    private static TextChange.Replacement mergeDeletions(TextChange.Replacement r1, TextChange.Replacement r2) {
        if (r1.replacement().isEmpty() && r2.replacement().isEmpty() && r1.range().end() == r2.range().start()) {
            return new TextChange.Replacement(new TextRange(r1.range().start(), r2.range().end()), "");
        }
        return null;
    }
}

