/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene103;

import java.util.Objects;
import org.apache.lucene.util.FixedBitSet;

class BitSetUtil {
    BitSetUtil() {
    }

    static int denseBitsetToArray(FixedBitSet bitSet, int from, int to, int base, int[] array) {
        assert (bitSet.cardinality(from, to) + 1 <= array.length) : "Array length must be at least bitSet.cardinality(from, to) + 1";
        Objects.checkFromToIndex(from, to, bitSet.length());
        int offset = 0;
        long[] bits = bitSet.getBits();
        if ((from & 0x3F) != 0) {
            long word = bits[from >> 6] >>> from;
            int numBitsTilNextWord = -from & 0x3F;
            if (to - from < numBitsTilNextWord) {
                return BitSetUtil.word2Array(word &= (1L << to - from) - 1L, from + base, array, offset);
            }
            offset = BitSetUtil.word2Array(word, from + base, array, offset);
            assert (((from += numBitsTilNextWord) & 0x3F) == 0);
        }
        int end = to >> 6;
        for (int i = from >> 6; i < end; ++i) {
            long word = bits[i];
            offset = BitSetUtil.word2Array(word, base + (i << 6), array, offset);
        }
        if ((to & 0x3F) != 0) {
            long word = bits[to >> 6] & (1L << to) - 1L;
            offset = BitSetUtil.word2Array(word, base + (to & 0xFFFFFFC0), array, offset);
        }
        return offset;
    }

    private static int word2Array(long word, int base, int[] docs, int offset) {
        int bitCount = Long.bitCount(word);
        if (bitCount >= 32) {
            return BitSetUtil.denseWord2Array(word, base, docs, offset);
        }
        for (int i = 0; i < bitCount; ++i) {
            int ntz = Long.numberOfTrailingZeros(word);
            docs[offset++] = base + ntz;
            word ^= 1L << ntz;
        }
        return offset;
    }

    private static int denseWord2Array(long word, int base, int[] docs, int offset) {
        int offset32;
        int lWord = (int)word;
        int hWord = (int)(word >>> 32);
        int hOffset = offset32 = offset + Integer.bitCount(lWord);
        for (int i = 0; i < 32; ++i) {
            docs[offset] = base + i;
            docs[hOffset] = base + i + 32;
            offset += lWord >>> i & 1;
            hOffset += hWord >>> i & 1;
        }
        docs[offset32] = base + 32 + Integer.numberOfTrailingZeros(hWord);
        return hOffset;
    }
}

