/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.vfilefinder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.restrictedAnalysis.KotlinRestrictedAnalysisService;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinBuiltInsMetadataIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinClassFileIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinMetadataFileIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinMetadataFilePackageIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinStdlibIndexKt;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0019\u001a\u00020\u00162\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020 0\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/IdeVirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/psi/search/GlobalSearchScope;Lcom/intellij/openapi/project/Project;)V", "restrictedAnalysisService", "Lorg/jetbrains/kotlin/analysis/api/platform/restrictedAnalysis/KotlinRestrictedAnalysisService;", "getRestrictedAnalysisService", "()Lorg/jetbrains/kotlin/analysis/api/platform/restrictedAnalysis/KotlinRestrictedAnalysisService;", "restrictedAnalysisService$delegate", "Lkotlin/Lazy;", "findMetadata", "Ljava/io/InputStream;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findMetadataTopLevelClassesInPackage", "", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "hasMetadataPackage", "", "fqName", "findBuiltInsData", "findSourceOrBinaryVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findVirtualFileWithHeader", "key", "Lcom/intellij/util/indexing/ID;", "Ljava/lang/Void;", "Companion", "intellij.kotlin.base.projectStructure"})
@SourceDebugExtension(value={"SMAP\nIdeVirtualFileFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeVirtualFileFinder.kt\norg/jetbrains/kotlin/idea/vfilefinder/IdeVirtualFileFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KotlinRestrictedAnalysisService.kt\norg/jetbrains/kotlin/analysis/api/platform/restrictedAnalysis/KotlinRestrictedAnalysisServiceKt\n*L\n1#1,66:1\n1#2:67\n91#3,4:68\n*S KotlinDebug\n*F\n+ 1 IdeVirtualFileFinder.kt\norg/jetbrains/kotlin/idea/vfilefinder/IdeVirtualFileFinder\n*L\n53#1:68,4\n*E\n"})
public final class IdeVirtualFileFinder
extends VirtualFileFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlobalSearchScope scope;
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy restrictedAnalysisService$delegate;
    @NotNull
    private static final Logger LOG;

    public IdeVirtualFileFinder(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(null, 1, null);
        this.scope = scope;
        this.project = project;
        this.restrictedAnalysisService$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> IdeVirtualFileFinder.restrictedAnalysisService_delegate$lambda$0(this));
        if (!Intrinsics.areEqual((Object)this.scope, (Object)GlobalSearchScope.EMPTY_SCOPE) && this.scope.getProject() == null) {
            LOG.info("Scope with null project " + this.scope);
        }
    }

    private final KotlinRestrictedAnalysisService getRestrictedAnalysisService() {
        Lazy lazy = this.restrictedAnalysisService$delegate;
        return (KotlinRestrictedAnalysisService)lazy.getValue();
    }

    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        InputStream inputStream;
        Object object;
        block5: {
            block4: {
                VirtualFile virtualFile;
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                object = this.findVirtualFileWithHeader(classId.asSingleFqName(), KotlinMetadataFileIndex.Companion.getNAME());
                if (object == null) break block4;
                VirtualFile it = virtualFile = object;
                boolean bl = false;
                object = it.exists() ? virtualFile : null;
                if (object != null) break block5;
            }
            return null;
        }
        VirtualFile file = object;
        try {
            inputStream = file.getInputStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            inputStream = null;
        }
        return inputStream;
    }

    @Nullable
    public Set<String> findMetadataTopLevelClassesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return null;
    }

    public boolean hasMetadataPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return KotlinStdlibIndexKt.hasSomethingInPackage(KotlinMetadataFilePackageIndex.Companion.getNAME(), fqName2, this.scope);
    }

    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        VirtualFile virtualFile = this.findVirtualFileWithHeader(packageFqName, KotlinBuiltInsMetadataIndex.Companion.getNAME());
        return virtualFile != null ? virtualFile.getInputStream() : null;
    }

    @Nullable
    public VirtualFile findSourceOrBinaryVirtualFile(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.findVirtualFileWithHeader(classId);
    }

    @Nullable
    public VirtualFile findVirtualFileWithHeader(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.findVirtualFileWithHeader(classId.asSingleFqName(), KotlinClassFileIndex.Companion.getNAME());
    }

    private final VirtualFile findVirtualFileWithHeader(FqName fqName2, ID<FqName, Void> key) {
        Object object;
        KotlinRestrictedAnalysisService $this$withRestrictedDataAccess$iv = this.getRestrictedAnalysisService();
        boolean $i$f$withRestrictedDataAccess = false;
        if ($this$withRestrictedDataAccess$iv != null && $this$withRestrictedDataAccess$iv.isAnalysisRestricted() && $this$withRestrictedDataAccess$iv.isRestrictedAnalysisAllowed()) {
            object = $this$withRestrictedDataAccess$iv.runWithRestrictedDataAccess((Function0)new Function0<VirtualFile>(key, fqName2, this){
                final /* synthetic */ ID $key$inlined;
                final /* synthetic */ FqName $fqName$inlined;
                final /* synthetic */ IdeVirtualFileFinder this$0;
                {
                    this.$key$inlined = iD;
                    this.$fqName$inlined = fqName2;
                    this.this$0 = ideVirtualFileFinder;
                }

                public final VirtualFile invoke() {
                    boolean bl = false;
                    Iterator iterator2 = FileBasedIndex.getInstance().getContainingFilesIterator(this.$key$inlined, (Object)this.$fqName$inlined, IdeVirtualFileFinder.access$getScope$p(this.this$0));
                    Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"getContainingFilesIterator(...)");
                    Iterator iterator3 = iterator2;
                    return iterator3.hasNext() ? (VirtualFile)iterator3.next() : null;
                }
            });
        } else {
            boolean bl = false;
            Iterator iterator2 = FileBasedIndex.getInstance().getContainingFilesIterator(key, (Object)fqName2, this.scope);
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"getContainingFilesIterator(...)");
            Iterator iterator3 = iterator2;
            object = iterator3.hasNext() ? (VirtualFile)iterator3.next() : null;
        }
        return (VirtualFile)object;
    }

    private static final KotlinRestrictedAnalysisService restrictedAnalysisService_delegate$lambda$0(IdeVirtualFileFinder this$0) {
        return KotlinRestrictedAnalysisService.Companion.getInstance(this$0.project);
    }

    static {
        Logger logger = Logger.getInstance(IdeVirtualFileFinder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/IdeVirtualFileFinder$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.kotlin.base.projectStructure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

