/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.configuration;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.module.Module;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeDetector;
import org.jetbrains.kotlin.idea.gradle.configuration.GradleModuleDetectorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/configuration/GradleModuleDetector;", "Lorg/jetbrains/kotlin/idea/configuration/BuildSystemTypeDetector;", "<init>", "()V", "detectBuildSystemType", "Lorg/jetbrains/kotlin/idea/configuration/BuildSystemType;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.kotlin.gradle.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleModuleDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleModuleDetector.kt\norg/jetbrains/kotlin/idea/gradle/configuration/GradleModuleDetector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,55:1\n12970#2,2:56\n*S KotlinDebug\n*F\n+ 1 GradleModuleDetector.kt\norg/jetbrains/kotlin/idea/gradle/configuration/GradleModuleDetector\n*L\n24#1:56,2\n*E\n"})
public final class GradleModuleDetector
implements BuildSystemTypeDetector {
    @Override
    @Nullable
    public BuildSystemType detectBuildSystemType(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (ProjectStructureUtils.isGradleModule(module)) {
            boolean bl;
            block4: {
                if (GradleModuleDetectorKt.isConfiguredViaAmperFiles(module)) {
                    return BuildSystemType.AmperGradle;
                }
                Facet[] facetArray = FacetManager.getInstance((Module)module).getAllFacets();
                Intrinsics.checkNotNullExpressionValue((Object)facetArray, (String)"getAllFacets(...)");
                Object[] $this$any$iv = facetArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Facet it = (Facet)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Android")) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) {
                return BuildSystemType.AndroidGradle;
            }
            return BuildSystemType.Gradle;
        }
        return null;
    }
}

