/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.Location;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/RunningCoroutineStackFrameItem;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "location", "Lcom/sun/jdi/Location;", "spilledVariables", "", "Lcom/intellij/debugger/engine/JavaValue;", "<init>", "(Lcom/intellij/debugger/jdi/StackFrameProxyImpl;Lcom/sun/jdi/Location;Ljava/util/List;)V", "getFrame", "()Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "createFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "intellij.kotlin.jvm.debugger.coroutines"})
public non-sealed class RunningCoroutineStackFrameItem
extends CoroutineStackFrameItem {
    @NotNull
    private final StackFrameProxyImpl frame;

    public RunningCoroutineStackFrameItem(@NotNull StackFrameProxyImpl frame, @NotNull Location location, @NotNull List<? extends JavaValue> spilledVariables) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter(spilledVariables, (String)"spilledVariables");
        super(location, spilledVariables, null);
        this.frame = frame;
    }

    public /* synthetic */ RunningCoroutineStackFrameItem(StackFrameProxyImpl stackFrameProxyImpl, Location location, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(stackFrameProxyImpl, location, list2);
    }

    @NotNull
    public final StackFrameProxyImpl getFrame() {
        return this.frame;
    }

    @Override
    @Nullable
    public XStackFrame createFrame(@NotNull DebugProcessImpl debugProcess, @Nullable SourcePosition sourcePosition) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        XSourcePosition position = CoroutineUtilsKt.toXSourcePosition(sourcePosition);
        return (XStackFrame)new CoroutineStackFrame(this.frame, position, null, false, null, 28, null);
    }
}

