---
stage: Application Security Testing
group: Secret Detection
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: クライアントサイドシークレット検出
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 15.11で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/368434)されました。
- カスタムプレフィックス付きのパーソナルアクセストークンの検出がGitLab 16.1で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/411146)されました。GitLabでのみGitLab Self-Managedで利用できます。

{{< /history >}}

イシューを作成したり、マージリクエストに説明を追加したり、コメントを書いたりする際に、誤ってシークレットを投稿してしまうことがあります。たとえば、APIリクエストの詳細や、認証トークンを含む環境変数を誤って貼り付けてしまうことがあります。シークレットが漏洩した場合、攻撃者はそれを使用して正当なユーザーになりすます可能性があります。

クライアント側のシークレット検出は、偶発的なシークレットの露出のリスクを最小限に抑えるのに役立ちます。説明を編集したり、イシューまたはマージリクエストにコメントしたりすると、GitLabはコンテンツを自動的にスキャンしてシークレットを検出します。

## シークレット検出 {#secret-detection-workflow}

クライアント側のシークレット検出は、パターンマッチングを使用してブラウザ内で完全に動作します。このアプローチにより、次のことが保証されます:

- シークレットは、GitLabに送信される前に検出されます。
- 検出プロセス中に機密情報が送信されることはありません。
- この機能は、追加の設定を必要とせずにシームレスに動作します。

## はじめに {#getting-started}

クライアント側のシークレット検出は、すべてのGitLabティアでデフォルトで有効になっています。セットアップや設定は必要ありません。

この機能をテストするには、次の手順に従ってください:

1. 任意のイシューまたはマージリクエストに移動します
1. テスト用のシークレットパターン（`glpat-xxxxxxxxxxxxxxxxxxxx`など）を含むコメントを追加します
1. 送信する前に表示される警告メッセージを確認します

実際のシークレットを公開しないように、テスト時には常にプレースホルダーの値を使用してください。

## カバレッジ {#coverage}

クライアント側のシークレット検出は、次のコンテンツを分析します:

- イシューの説明とコメント
- マージリクエストの説明とコメント

検出されるシークレットの特定の種類の詳細については、[検出されたシークレット](../detected_secrets.md)のドキュメントを参照してください。

## 結果について理解する {#understanding-the-results}

クライアント側のシークレット検出が潜在的なシークレットを識別すると、GitLabは検出されたシークレットを強調表示する警告を表示します。次のいずれかの方法があります:

- コメントまたは説明のコンテンツを**編集**して、シークレットを削除します。
- 変更を加えずにコンテンツを**追加**します。潜在的なシークレットを含むコンテンツを追加する前に、注意してください。

検出はブラウザ内で完全に実行されます。**追加**を選択しない限り、情報は送信されません。

## 最適化 {#optimization}

クライアント側のシークレット検出の効果を最大限に高めるには、次の手順を実行します:

- 警告を注意深く確認してください。続行する前に、フラグが立てられたコンテンツを必ず調査してください。
- プレースホルダーを使用してください。実際のシークレットを`[REDACTED]`や`<API_KEY>`のようなプレースホルダーテキストに置き換えます。
