---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: DASTオンデマンドスキャン
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< alert type="warning" >}}

DASTスキャンを本番環境サーバーに対して実行しないでください。ユーザーができる機能（ボタンのクリックやフォームの送信など）を実行できるだけでなく、バグをトリガーして、本番環境データの変更や損失につながる可能性があります。テストサーバーに対してのみDASTスキャンを実行してください。

{{< /alert >}}

## オンデマンドスキャン {#on-demand-scans}

{{< history >}}

- Runnerタグの選択が、GitLab 16.3で[GitLab.comおよびGitLab Self-Managedで有効になりました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111499)。
- ブラウザベースのオンデマンドDASTスキャンは、GitLab 17.0バージョン以降で利用可能です。[プロキシベースのDASTが同じバージョンで削除された](../../../update/deprecations.md#proxy-based-dast-deprecated)ためです。

{{< /history >}}

オンデマンドDASTスキャンは、DevOpsライフサイクルの外で実行されます。リポジトリの変更は、スキャンをトリガーしません。手動で開始するか、実行するようにスケジュールする必要があります。オンデマンドDASTスキャンの場合、[サイトプロファイル](profiles.md#site-profile)はスキャン対象の**what**（内容）を定義し、[スキャナープロファイル](profiles.md#scanner-profile)はアプリケーションの**how**（方法）を定義します。

オンデマンドスキャンは、アクティブモードまたはパッシブモードで実行できます:

- **Passive mode**（パッシブモード）: [パッシブブラウザベーススキャン](browser/_index.md#passive-scans)を実行するデフォルトモード。
- **Active mode**（アクティブモード）: [アクティブブラウザベーススキャン](browser/_index.md#active-scans)を実行します。これは、スキャン対象のサイトに潜在的な損害を与える可能性があります。偶発的な損害のリスクを最小限に抑えるために、アクティブスキャンの実行には[検証済みのサイトプロファイル](profiles.md#site-profile-validation)が必要です。

### オンデマンドDASTスキャンを表示 {#view-on-demand-dast-scans}

オンデマンドスキャンを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **オンデマンドのスキャン**を選択します。

オンデマンドスキャンは、ステータス別にグループ化されています。スキャンライブラリには、利用可能なすべてのオンデマンドスキャンが含まれています。

### DASTオンデマンドスキャンの実行 {#run-an-on-demand-dast-scan}

前提要件:

- 保護ブランチに対してオンデマンドDASTスキャンを実行する権限が必要です。デフォルトブランチは自動的に保護されます。詳しくは、[保護ブランチのパイプラインセキュリティ](../../../ci/pipelines/_index.md#pipeline-security-on-protected-branches)をご覧ください。

既存のオンデマンドスキャンを実行するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **オンデマンドのスキャン**を選択します。
1. **ライブラリをスキャン**タブを選択します。
1. スキャンの行で、**スキャンを実行**を選択します。

   スキャンに保存されているブランチが存在しなくなった場合は、次の操作を行う必要があります:

   1. [スキャンを編集します](#edit-an-on-demand-scan)。
   1. 新しいブランチを選択します。
   1. 編集したスキャンを保存します。

オンデマンドDASTスキャンが実行され、プロジェクトのダッシュボードに結果が表示されます。

#### オンデマンドスキャンを作成 {#create-an-on-demand-scan}

オンデマンドスキャンを作成する目的:

- すぐに実行する。
- 将来実行できるように保存する。
- 指定されたスケジュールで実行されるようにスケジュールする。

オンデマンドDASTスキャンを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **オンデマンドのスキャン**を選択します。
1. **新規スキャン**を選択します。
1. **スキャン名**フィールドと**説明**フィールドに入力します。
1. **ブランチ**ドロップダウンリストで、目的のブランチを選択します。
1. オプション。Runnerタグを選択します。
1. **スキャナープロファイルを選択します**または**スキャナープロファイルを変更します**を選択してドロワーを開き、次のいずれかを実行します:
   - ドロワーからスキャナープロファイルを選択します**または**
   - **新しいプロファイル**を選択し、[スキャナープロファイル](profiles.md#scanner-profile)を作成し、**プロファイルの保存**を選択します。
1. **サイトプロファイルを選択します**または**サイトのプロファイルを変更します**を選択してドロワーを開き、次のいずれかを実行します:
   - **Site profile library**（サイトプロファイルライブラリ）ドロワーからサイトプロファイルを選択するか、
   - **新しいプロファイル**を選択し、[サイトプロファイル](profiles.md#site-profile)を作成し、**プロファイルの保存**を選択します。
1. オンデマンドスキャンを実行するには:

   - すぐに実行するには、**スキャンを保存して実行**を選択します。
   - 将来実行するには、**スキャンを保存**を選択します。
   - スケジュール通りに実行するには:

     - **スキャンスケジュールを有効にする**切替をオンにします。
     - スケジュールフィールドに入力します。
     - **スキャンを保存**を選択します。

オンデマンドDASTスキャンが指定どおりに実行され、プロジェクトのダッシュボードに結果が表示されます。

### オンデマンドスキャンの詳細を表示 {#view-details-of-an-on-demand-scan}

前提要件:

- DASTスキャンに関連付けられているブランチにプッシュできる必要があります。

オンデマンドスキャンの詳細を表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **オンデマンドのスキャン**を選択します。
1. **ライブラリをスキャン**タブを選択します。
1. 保存されたスキャンの行で、**追加のアクション**（{{< icon name="ellipsis_v" >}}）を選択し、**編集**を選択します。

### オンデマンドスキャンを編集 {#edit-an-on-demand-scan}

前提要件:

- DASTスキャンに関連付けられているブランチにプッシュできる必要があります。

オンデマンドスキャンを編集するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **オンデマンドのスキャン**を選択します。
1. **ライブラリをスキャン**タブを選択します。
1. 保存されたスキャンの行で、**追加のアクション**（{{< icon name="ellipsis_v" >}}）を選択し、**編集**を選択します。
1. 保存されたスキャンの詳細を編集します。
1. **スキャンを保存**を選択します。

### オンデマンドスキャンを削除 {#delete-an-on-demand-scan}

前提要件:

- DASTスキャンに関連付けられているブランチにプッシュできる必要があります。

オンデマンドスキャンを削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **オンデマンドのスキャン**を選択します。
1. **ライブラリをスキャン**タブを選択します。
1. 保存されたスキャンの行で、**追加のアクション**（{{< icon name="ellipsis_v" >}}）を選択し、**削除**を選択します。
1. 確認ダイアログで、**削除**を選択します。
