---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密性の高いシークレットまたはトークンであるAdobeクライアントのシークレットの公開'
---

## 説明 {#description}

応答本文に、Adobeクライアントのシークレットのパターンに一致するコンテンツが検出されました。Adobeクライアントのシークレットは、さまざまなAPIまたはWebhookイベントベースのサービスに接続するために使用されます。プロジェクトに対して定義されたサービスの種類によっては、そのシークレットにアクセスできる悪意のある攻撃者は、それを使用して、機密情報を含む可能性のあるさまざまなAPIまたはイベントにアクセスできます。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

流出したキーに関するセキュリティインシデントの処理に関する一般的なガイダンスについては、[認証情報のインターネットへの公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)に関するGitLabドキュメントを参照してください。修正手順は、流出したクライアントのシークレットの種類によって異なります。以下の修正手順の種類を参照し、検出されたシークレットに適用されるものを使用してください。

OAuth（サーバー間）:

- <https://developer.adobe.com/console>で自分のアカウントにサインインします。
- 影響を受けるプロジェクトを見つけるために、プロジェクトまたは[すべてのプロジェクト]を選択します - 左側の[認証情報]で、[OAuthサーバー間]を選択します
- [クライアントのシークレット]で、[クライアントのシークレットを取得する]を選択します
- シークレットの表が表示されたら、表の下にある[新しいクライアントのシークレットを追加]を選択します
- 新しいシークレットが作成されたら、流出した値を見つけて、ごみ箱アイコンを選択して削除します
- シークレット値をコピーし、新しいクライアントのシークレットですべてのサービスを更新します

OAuth Webアプリ（イベントベースのプロジェクト）:

- 影響を受けるプロジェクトを見つけるために、プロジェクトまたは[すべてのプロジェクト]を選択します
- 左側の[認証情報]で、[OAuth Webアプリ]を選択します。
- [クライアントのシークレットを取得する]を選択します
- これが流出したシークレットであることを確認します
- このプロジェクトがイベント用に構成されている場合は、削除する前にすべてのイベントの詳細をコピーします。これを行うには、右側にリストされているイベントを見つけて選択します。イベント配信方法、プロバイダー、サブスクライブされたイベント、接続された認証情報などの詳細を示すダッシュボードが表示されます。
- イベントを削除するには、プロジェクトページの右側、[別のサービスを接続]の上にある、イベントの[... ]を選択します。
- [削除]を選択します。
- プロンプトが表示されたら、プロジェクト名を入力し、[イベント登録を削除]を選択します
- 右上隅で、[認証情報を削除]を選択します
- プロンプトが表示されたら、プロジェクト名を入力し、[認証情報を削除]を選択します
- 以前と同じ詳細を使用してイベントを再度追加します
- 認証情報を再度追加するように求められたら、必ず[ユーザー認証] OAuthを使用してください
- OAuth 2.0の認証と認可のために[Webアプリ]を選択します
- イベントが再度追加されたら、左側の[認証情報]の下にある[OAuth Webアプリ]を選択します
- [クライアントのシークレットを取得する]を選択します
- シークレット値をコピーし、新しいクライアントのシークレットですべてのサービスを更新します

OAuth Webアプリ（APIサービスベースのプロジェクト）:

- <https://developer.adobe.com/console>で自分のアカウントにサインインします。
- 影響を受けるプロジェクトを見つけるために、プロジェクトまたは[すべてのプロジェクト]を選択します
- 左側の[認証情報]で、[OAuth Webアプリ]を選択します
- [クライアントのシークレットを取得する]を選択します
- このプロジェクトがAPI用に構成されている場合は、ごみ箱アイコン[削除]を選択して、接続されている製品とサービスを削除します。
- プロンプトが表示されたら、プロジェクト名を入力し、[APIを削除]を選択します
- 右上隅で、[認証情報を削除]を選択します
- プロンプトが表示されたら、プロジェクト名を入力し、[認証情報を削除]を選択します
- 以前と同じ詳細を使用してAPIを再度追加します
- OAuth 2.0の認証と認可のために[Webアプリ]を選択します
- サービスが再度追加されたら、左側の[認証情報]の下にある[OAuth Webアプリ]を選択します
- [クライアントのシークレットを取得する]を選択します
- シークレット値をコピーし、新しいクライアントのシークレットですべてのサービスを更新します

## 詳細 {#details}

| ID | 集約 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.3 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
