# frozen_string_literal: true

class SlackIntegrationShardingKeyNotNull < Gitlab::Database::Migration[2.3]
  disable_ddl_transaction!
  milestone '18.9'

  def up
    add_multi_column_not_null_constraint(
      :slack_integrations,
      :project_id,
      :group_id,
      :organization_id
    )
  end

  def down
    remove_multi_column_not_null_constraint(
      :slack_integrations,
      :project_id,
      :group_id,
      :organization_id
    )
  end
end
