/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.decompile;

import docking.action.MenuData;
import ghidra.app.services.FunctionComparisonService;
import ghidra.features.codecompare.decompile.AbstractMatchedCalleeTokensAction;
import ghidra.features.codecompare.decompile.DecompilerCodeComparisonView;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;

public class CompareFuncsFromMatchedTokensAction
extends AbstractMatchedCalleeTokensAction {
    private PluginTool tool;
    private static final String ACTION_NAME = "Compare Matching Callees";

    public CompareFuncsFromMatchedTokensAction(DecompilerCodeComparisonView diffPanel, PluginTool tool) {
        super(ACTION_NAME, tool.getName(), diffPanel, false);
        this.tool = tool;
        MenuData menuData = new MenuData(new String[]{ACTION_NAME}, null, "A2_ApplyCallee");
        this.setPopupMenuData(menuData);
        this.setHelpLocation(new HelpLocation("FunctionComparison", ACTION_NAME));
    }

    @Override
    protected void doCalleeActionPerformed(Function leftFunction, Function rightFunction) {
        FunctionComparisonService service = (FunctionComparisonService)this.tool.getService(FunctionComparisonService.class);
        if (service == null) {
            Msg.error((Object)((Object)this), (Object)"Function Comparison Service not found!");
            return;
        }
        service.createComparison(leftFunction, rightFunction);
    }
}

