/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.transform;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import org.jungrapht.visualization.transform.Lens;
import org.jungrapht.visualization.transform.MutableAffineTransformer;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.jungrapht.visualization.transform.MutableTransformerDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LensTransformer
extends MutableTransformerDecorator
implements MutableTransformer {
    private static final Logger log = LoggerFactory.getLogger(LensTransformer.class);
    protected Lens lens;

    protected LensTransformer(Dimension d) {
        this(new Lens());
    }

    protected LensTransformer(Lens lens) {
        super(new MutableAffineTransformer());
        this.lens = lens;
    }

    protected LensTransformer(Dimension d, MutableTransformer delegate) {
        this(new Lens(), delegate);
    }

    protected LensTransformer(Lens lens, MutableTransformer delegate) {
        super(delegate);
        this.lens = lens;
    }

    public Lens getLens() {
        return this.lens;
    }

    @Override
    public void setToIdentity() {
        this.delegate.setToIdentity();
    }

    @Override
    public abstract Point2D transform(Point2D var1);

    @Override
    public Point2D transform(double x, double y) {
        return this.transform(new Point2D.Double(x, y));
    }

    @Override
    public abstract Point2D inverseTransform(Point2D var1);

    @Override
    public Point2D inverseTransform(double x, double y) {
        return this.inverseTransform(new Point2D.Double(x, y));
    }

    public static abstract class Builder<T extends LensTransformer, B extends Builder<T, B>>
    extends MutableTransformerDecorator.Builder<T, B> {
        protected Lens lens;
        protected Dimension dimension = new Dimension(600, 600);

        protected Builder(Lens lens) {
            this.lens = lens;
        }

        protected Builder(Dimension dimension) {
            this.dimension = dimension;
        }

        @Override
        protected B self() {
            return (B)this;
        }

        public B lens(Lens lens) {
            this.lens = lens;
            return (B)this.self();
        }

        public B dimension(Dimension dimension) {
            this.dimension = dimension;
            return (B)this.self();
        }

        @Override
        protected abstract T build();
    }
}

