/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target.path;

import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.path.PathPattern;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class PathMatcher
implements PathFilter {
    protected static final Set<String> WILD_SINGLETON = Set.of("");
    protected final Set<PathPattern> patterns;

    public static PathMatcher any(Stream<PathPattern> patterns) {
        return new PathMatcher(patterns.collect(Collectors.toUnmodifiableSet()));
    }

    public static PathMatcher any(Collection<PathFilter> filters) {
        return PathMatcher.any(filters.stream().flatMap(f -> f.getPatterns().stream()));
    }

    public static PathMatcher any(PathFilter ... filters) {
        return PathMatcher.any(Stream.of(filters).flatMap(f -> f.getPatterns().stream()));
    }

    PathMatcher(Set<PathPattern> patterns) {
        this.patterns = patterns;
    }

    public String toString() {
        return String.format("<PathMatcher\n  %s\n>", StringUtils.join(this.patterns, (String)"\n  "));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PathMatcher)) {
            return false;
        }
        PathMatcher that = (PathMatcher)obj;
        return Objects.equals(this.patterns, that.patterns);
    }

    @Override
    public PathFilter or(PathFilter that) {
        HashSet<PathPattern> patterns = new HashSet<PathPattern>();
        patterns.addAll(this.patterns);
        patterns.addAll(that.getPatterns());
        return new PathMatcher(Collections.unmodifiableSet(patterns));
    }

    protected boolean anyPattern(Predicate<PathPattern> pred) {
        for (PathPattern p : this.patterns) {
            if (!pred.test(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(KeyPath path) {
        return this.anyPattern(p -> p.matches(path));
    }

    @Override
    public boolean successorCouldMatch(KeyPath path, boolean strict) {
        return this.anyPattern(p -> p.successorCouldMatch(path, strict));
    }

    @Override
    public boolean ancestorMatches(KeyPath path, boolean strict) {
        return this.anyPattern(p -> p.ancestorMatches(path, strict));
    }

    @Override
    public boolean ancestorCouldMatchRight(KeyPath path, boolean strict) {
        return this.anyPattern(p -> p.ancestorCouldMatchRight(path, strict));
    }

    @Override
    public KeyPath getSingletonPath() {
        if (this.patterns.size() != 1) {
            return null;
        }
        return this.patterns.iterator().next().getSingletonPath();
    }

    @Override
    public PathPattern getSingletonPattern() {
        if (this.patterns.size() != 1) {
            return null;
        }
        return this.patterns.iterator().next();
    }

    @Override
    public Set<PathPattern> getPatterns() {
        return this.patterns;
    }

    protected void coalesceWilds(Set<String> result) {
        if (result.contains("")) {
            result.removeIf(KeyPath::isName);
            result.add("");
        }
        if (result.contains("[]")) {
            result.removeIf(KeyPath::isIndex);
            result.add("[]");
        }
    }

    @Override
    public Set<String> getNextKeys(KeyPath path) {
        HashSet<String> result = new HashSet<String>();
        for (PathPattern pattern : this.patterns) {
            result.addAll(pattern.getNextKeys(path));
        }
        this.coalesceWilds(result);
        return result;
    }

    @Override
    public Set<String> getNextNames(KeyPath path) {
        HashSet<String> result = new HashSet<String>();
        for (PathPattern pattern : this.patterns) {
            result.addAll(pattern.getNextNames(path));
            if (!result.contains("")) continue;
            return WILD_SINGLETON;
        }
        return result;
    }

    @Override
    public Set<String> getNextIndices(KeyPath path) {
        HashSet<String> result = new HashSet<String>();
        for (PathPattern pattern : this.patterns) {
            result.addAll(pattern.getNextIndices(path));
            if (!result.contains("")) continue;
            return WILD_SINGLETON;
        }
        return result;
    }

    @Override
    public Set<String> getPrevKeys(KeyPath path) {
        HashSet<String> result = new HashSet<String>();
        for (PathPattern pattern : this.patterns) {
            result.addAll(pattern.getPrevKeys(path));
        }
        this.coalesceWilds(result);
        return result;
    }

    @Override
    public boolean isNone() {
        return this.patterns.isEmpty();
    }

    @Override
    public PathMatcher applyKeys(PathFilter.Align align, List<String> indices) {
        HashSet<PathFilter> patterns = new HashSet<PathFilter>();
        for (PathPattern pat : this.patterns) {
            patterns.add(pat.applyKeys(align, (List)indices));
        }
        return new PathMatcher(Collections.unmodifiableSet(patterns));
    }

    @Override
    public PathMatcher removeRight(int count) {
        HashSet<PathPattern> patterns = new HashSet<PathPattern>();
        for (PathPattern pat : this.patterns) {
            pat.doRemoveRight(count, patterns);
        }
        return new PathMatcher(Collections.unmodifiableSet(patterns));
    }
}

