/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import generic.Span;
import java.awt.Graphics;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

public interface SpannedRenderer<N extends Number> {
    public static DoubleSpan validateViewRange(Span<? extends Number, ?> fullSpan) {
        return new DoubleSpan(((Number)fullSpan.min()).doubleValue(), ((Number)fullSpan.max()).doubleValue());
    }

    public void setFullRange(Span<N, ?> var1);

    public Span<N, ?> getFullRange();

    public Span<Double, ?> getFullRangeDouble();

    public double getSpan();

    default public int interpolate(int w, double val) {
        Span<Double, ?> fullRangeDouble = this.getFullRangeDouble();
        double span = this.getSpan();
        double lower = (Double)fullRangeDouble.min();
        if (val <= lower) {
            return 0;
        }
        if (val >= (Double)fullRangeDouble.max()) {
            return w;
        }
        double dif = val - lower;
        return (int)(dif / span * (double)w);
    }

    public int getWidth();

    public int getHeight();

    default public void paintRange(Graphics g, Span<N, ?> range) {
        int width = this.getWidth();
        int height = this.getHeight();
        int x1 = range.minIsFinite() ? this.interpolate(width, ((Number)range.min()).doubleValue()) : 0;
        int x2 = range.maxIsFinite() ? this.interpolate(width, ((Number)range.max()).doubleValue()) : width;
        int y1 = height > 2 ? 1 : 0;
        int y2 = height > 2 ? height - 1 : height;
        g.fillRect(x1, y1, x2 - x1, y2 - y1);
    }

    public static final class DoubleSpan
    extends Record
    implements Span<Double, DoubleSpan> {
        private final Span.Domain<Double, DoubleSpan> domain;
        private final Double min;
        private final Double max;

        public DoubleSpan(double min, double max) {
            this(null, min, max);
        }

        public DoubleSpan(Span.Domain<Double, DoubleSpan> domain, Double min, Double max) {
            this.domain = domain;
            this.min = min;
            this.max = max;
        }

        @Override
        public String toString() {
            return "[" + this.min + ".." + this.max + "]";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DoubleSpan.class, "domain;min;max", "domain", "min", "max"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DoubleSpan.class, "domain;min;max", "domain", "min", "max"}, this, o);
        }

        public Span.Domain<Double, DoubleSpan> domain() {
            return this.domain;
        }

        public Double min() {
            return this.min;
        }

        public Double max() {
            return this.max;
        }
    }
}

