/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import ghidra.app.plugin.core.strings.StringInfoFeature;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public record StringInfo(String stringValue, Set<Character.UnicodeScript> scripts, Set<StringInfoFeature> stringFeatures) {
    private static final Set<Character> STD_CTRL_CHARS = Set.of(Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('\r'));

    public static StringInfo fromString(String s) {
        s = Objects.requireNonNullElse(s, "");
        EnumSet<Character.UnicodeScript> scripts = EnumSet.noneOf(Character.UnicodeScript.class);
        EnumSet<StringInfoFeature> features = EnumSet.noneOf(StringInfoFeature.class);
        s.codePoints().forEach(codePoint -> {
            try {
                Character.UnicodeScript script = Character.UnicodeScript.of(codePoint);
                if (script == Character.UnicodeScript.UNKNOWN) {
                    features.add(StringInfoFeature.CODEC_ERROR);
                } else {
                    scripts.add(script);
                }
                if (codePoint == 65533) {
                    features.add(StringInfoFeature.CODEC_ERROR);
                }
                if (codePoint < 32 && !STD_CTRL_CHARS.contains(Character.valueOf((char)codePoint)) || !Character.isDefined(codePoint)) {
                    features.add(StringInfoFeature.NON_STD_CTRL_CHARS);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        return new StringInfo(s, scripts, features);
    }

    public boolean hasCodecError() {
        return this.stringFeatures.contains((Object)StringInfoFeature.CODEC_ERROR);
    }

    public boolean hasNonStdCtrlChars() {
        return this.stringFeatures.contains((Object)StringInfoFeature.NON_STD_CTRL_CHARS);
    }
}

