/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import generic.theme.GIcon;
import ghidra.program.model.data.Playable;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.swing.Icon;

public class ScorePlayer
implements Playable,
MetaEventListener {
    private static final Icon MIDI_ICON = new GIcon("icon.data.type.audio.player");
    private static final int END_OF_TRACK_MESSAGE = 47;
    private static volatile Sequencer currentSequencer;
    private byte[] bytes;

    public ScorePlayer(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public Icon getImageIcon() {
        return MIDI_ICON;
    }

    @Override
    public void clicked(MouseEvent event) {
        try {
            if (currentSequencer != null) {
                this.stop();
                return;
            }
            Sequencer sequencer = MidiSystem.getSequencer(true);
            sequencer.addMetaEventListener(this);
            sequencer.setLoopCount(0);
            sequencer.setSequence(MidiSystem.getSequence(new ByteArrayInputStream(this.bytes)));
            sequencer.open();
            currentSequencer = sequencer;
            currentSequencer.start();
        }
        catch (IOException | InvalidMidiDataException | MidiUnavailableException e) {
            Msg.error((Object)this, (Object)"Unable to play score", (Throwable)e);
        }
    }

    @Override
    public void meta(MetaMessage message) {
        if (message.getType() == 47) {
            Swing.runNow(() -> this.stop());
        }
    }

    private void stop() {
        if (currentSequencer == null) {
            return;
        }
        currentSequencer.removeMetaEventListener(this);
        currentSequencer.stop();
        currentSequencer.close();
        currentSequencer = null;
    }
}

