/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.VectorSTL;
import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.ValueSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public class VarnodeListSymbol
extends ValueSymbol {
    private VectorSTL<VarnodeSymbol> varnode_table = new VectorSTL();
    private boolean tableisfilled;

    public VarnodeListSymbol(Location location) {
        super(location);
    }

    @Override
    public symbol_type getType() {
        return symbol_type.varnodelist_symbol;
    }

    public VarnodeListSymbol(Location location, String nm, PatternValue pv, VectorSTL<SleighSymbol> vt) {
        super(location, nm, pv);
        for (int i = 0; i < vt.size(); ++i) {
            this.varnode_table.push_back((Object)((VarnodeSymbol)vt.get(i)));
        }
        this.checkTableFill();
    }

    private void checkTableFill() {
        long min = this.patval.minValue();
        long max = this.patval.maxValue();
        this.tableisfilled = min >= 0L && max < (long)this.varnode_table.size();
        for (int i = 0; i < this.varnode_table.size(); ++i) {
            if (this.varnode_table.get(i) != null) continue;
            this.tableisfilled = false;
        }
    }

    @Override
    public int getSize() {
        for (int i = 0; i < this.varnode_table.size(); ++i) {
            VarnodeSymbol vnsym = (VarnodeSymbol)this.varnode_table.get(i);
            if (vnsym == null) continue;
            return vnsym.getSize();
        }
        throw new SleighError("No register attached to: " + this.getName(), this.getLocation());
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_VARLIST_SYM);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_ID, this.id);
        this.patval.encode(encoder);
        for (int i = 0; i < this.varnode_table.size(); ++i) {
            if (this.varnode_table.get(i) == null) {
                encoder.openElement(SlaFormat.ELEM_NULL);
                encoder.closeElement(SlaFormat.ELEM_NULL);
                continue;
            }
            encoder.openElement(SlaFormat.ELEM_VAR);
            encoder.writeUnsignedInteger(SlaFormat.ATTRIB_ID, ((VarnodeSymbol)this.varnode_table.get(i)).getId());
            encoder.closeElement(SlaFormat.ELEM_VAR);
        }
        encoder.closeElement(SlaFormat.ELEM_VARLIST_SYM);
    }

    @Override
    public void encodeHeader(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_VARLIST_SYM_HEAD);
        this.encodeSleighSymbolHeader(encoder);
        encoder.closeElement(SlaFormat.ELEM_VARLIST_SYM_HEAD);
    }
}

