/*
 * Decompiled with CFR 0.152.
 */
package mobiledevices.dmg.btree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mobiledevices.dmg.btree.BTreeHeaderRecord;
import mobiledevices.dmg.btree.BTreeNodeRecord;
import mobiledevices.dmg.ghidra.GBinaryReader;

public class BTreeNodeDescriptor {
    private int fLink;
    private int bLink;
    private byte kind;
    private byte height;
    private short numRecords;
    private short reserved;
    private List<Short> _recordOffsets = new ArrayList<Short>();
    private List<BTreeNodeRecord> _records = new ArrayList<BTreeNodeRecord>();

    BTreeNodeDescriptor(GBinaryReader reader) throws IOException {
        this.fLink = reader.readNextInt();
        this.bLink = reader.readNextInt();
        this.kind = reader.readNextByte();
        this.height = reader.readNextByte();
        this.numRecords = reader.readNextShort();
        this.reserved = reader.readNextShort();
    }

    protected void readRecordOffsets(GBinaryReader reader, long nodeStartIndex, BTreeHeaderRecord header) throws IOException {
        short recordOffset;
        long position = nodeStartIndex + (long)header.getNodeSize() - 2L;
        while ((recordOffset = reader.readShort(position)) != 0) {
            this._recordOffsets.add(recordOffset);
            position -= 2L;
        }
    }

    protected void readRecords(GBinaryReader reader, long nodeStartIndex) throws IOException {
        for (int i = 0; i < this.getNumRecords(); ++i) {
            short offset = this.getRecordOffsets().get(i);
            long recordIndex = (long)(offset & 0xFFFF) + nodeStartIndex;
            reader.setPointerIndex(recordIndex);
            BTreeNodeRecord record = new BTreeNodeRecord(reader, this);
            this._records.add(record);
        }
    }

    public List<Short> getRecordOffsets() {
        return this._recordOffsets;
    }

    public List<BTreeNodeRecord> getRecords() {
        return this._records;
    }

    public int getFLink() {
        return this.fLink;
    }

    public int getBLink() {
        return this.bLink;
    }

    public byte getKind() {
        return this.kind;
    }

    public byte getHeight() {
        return this.height;
    }

    public short getNumRecords() {
        return this.numRecords;
    }

    public short getReserved() {
        return this.reserved;
    }
}

