/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractArgumentsListMsType
extends AbstractMsType {
    protected List<RecordNumber> argRecordNumbers = new ArrayList<RecordNumber>();

    public AbstractArgumentsListMsType(AbstractPdb pdb, PdbByteReader reader, int intSize) throws PdbException {
        super(pdb, reader);
        long count = reader.parseVarSizedUInt(intSize);
        int i = 0;
        while ((long)i < count) {
            RecordNumber argRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, intSize);
            this.argRecordNumbers.add(argRecordNumber);
            ++i;
        }
    }

    public List<RecordNumber> getArgRecordNumbers() {
        return this.argRecordNumbers;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        DelimiterState ds = new DelimiterState("", ", ");
        builder.append("(");
        for (RecordNumber recNumber : this.argRecordNumbers) {
            AbstractMsType type = this.pdb.getTypeRecord(recNumber);
            builder.append(ds.out(true, type.toString()));
        }
        builder.append(")");
    }
}

